/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * FUPixaps.h: Icons used to represent Functional Units
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/FUPixmaps.h,v 1.8 1994/02/25 04:28:12 aydt Exp $
 */
#ifndef FUPixmaps_h
#define FUPixmaps_h


/***	Generic Icon 	***/

const int FUIcon_width = 64;
const int FUIcon_height = 64;
static char FUIcon_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x40, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x80, 0x01, 0x40, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80,
   0x79, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x80, 0x79, 0x10, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x80, 0xf9, 0x0c, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x80,
   0x79, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x80, 0x11, 0x1a, 0x00, 0x00,
   0x18, 0xe0, 0x3f, 0x80, 0xd1, 0x61, 0x00, 0x00, 0x10, 0x00, 0x23, 0x80,
   0x71, 0x80, 0x03, 0x00, 0x30, 0x00, 0x22, 0x80, 0x31, 0x00, 0x0c, 0x80,
   0x3f, 0x00, 0x26, 0x80, 0x19, 0x00, 0x70, 0xc0, 0x20, 0x00, 0x1c, 0x80,
   0x1d, 0x30, 0x80, 0x61, 0x20, 0x00, 0x00, 0x80, 0x19, 0x48, 0x00, 0x46,
   0x20, 0x00, 0x00, 0x80, 0x19, 0x48, 0x00, 0x78, 0x2f, 0x00, 0x00, 0x80,
   0x19, 0x78, 0x00, 0xc0, 0x4f, 0x00, 0x00, 0x80, 0x19, 0x48, 0x00, 0xe0,
   0x8f, 0x00, 0x00, 0x80, 0x19, 0x48, 0x00, 0x38, 0x8f, 0x01, 0x00, 0xf0,
   0x19, 0x00, 0x00, 0x27, 0x1a, 0x03, 0x00, 0x90, 0x19, 0x00, 0xe0, 0xe0,
   0x22, 0x0e, 0x00, 0x98, 0x19, 0x00, 0x1c, 0x3c, 0xff, 0x70, 0x00, 0x8e,
   0x19, 0x00, 0x03, 0x06, 0x82, 0x83, 0x87, 0x83, 0x2d, 0xe0, 0x00, 0x01,
   0x02, 0x0e, 0xc4, 0x80, 0x2f, 0x1c, 0x80, 0x00, 0x02, 0x34, 0x38, 0x80,
   0x49, 0x03, 0x80, 0x00, 0x02, 0x58, 0x10, 0x80, 0xfd, 0x00, 0x40, 0x00,
   0x02, 0x60, 0x10, 0x80, 0x3d, 0x01, 0x40, 0x00, 0x02, 0xc0, 0x20, 0x80,
   0x3d, 0x02, 0x20, 0x00, 0x02, 0x80, 0x61, 0x80, 0x3d, 0x7c, 0x1e, 0x00,
   0x02, 0x80, 0x42, 0x80, 0x21, 0xc0, 0x01, 0x00, 0x02, 0x40, 0x44, 0x80,
   0x79, 0x80, 0x00, 0x1f, 0x02, 0x40, 0x98, 0x80, 0xef, 0x00, 0x81, 0x20,
   0x02, 0x40, 0xa0, 0x80, 0xc1, 0x01, 0x81, 0x20, 0x02, 0x40, 0xc0, 0x80,
   0x01, 0x83, 0x81, 0x20, 0x02, 0xb0, 0xc0, 0x81, 0x01, 0xce, 0x80, 0x20,
   0x02, 0x08, 0x41, 0x9e, 0x01, 0x7c, 0x00, 0x1f, 0x02, 0x04, 0x42, 0x9e,
   0x01, 0xc8, 0x0f, 0x00, 0x02, 0x02, 0x4c, 0x9e, 0x01, 0x10, 0x08, 0x00,
   0x01, 0x03, 0x50, 0x9e, 0x01, 0x20, 0x10, 0x00, 0x81, 0x01, 0x60, 0x81,
   0x01, 0x40, 0x20, 0x00, 0x41, 0x00, 0xf0, 0x80, 0x01, 0x80, 0xc0, 0x00,
   0x21, 0x00, 0x20, 0x80, 0x01, 0x00, 0x81, 0x00, 0x31, 0x00, 0x30, 0x80,
   0x01, 0x00, 0x82, 0x00, 0x09, 0x00, 0x28, 0x80, 0x01, 0x00, 0x04, 0x11,
   0x05, 0x00, 0x44, 0x80, 0x01, 0x00, 0x08, 0x29, 0x07, 0x00, 0x43, 0x80,
   0x01, 0x00, 0x10, 0x29, 0x03, 0x80, 0xc0, 0x80, 0x01, 0x00, 0x20, 0x49,
   0x01, 0x40, 0x80, 0x80, 0x01, 0x0e, 0x40, 0x45, 0x01, 0x20, 0x80, 0x80,
   0x01, 0x11, 0x80, 0x43, 0x01, 0x10, 0xc0, 0x80, 0x01, 0x11, 0x00, 0x81,
   0x01, 0x08, 0x60, 0x80, 0x01, 0x0f, 0x00, 0x83, 0x01, 0x06, 0xc0, 0xc3,
   0x01, 0x11, 0x00, 0x03, 0x01, 0x01, 0x00, 0xbe, 0x01, 0x11, 0x00, 0x05,
   0xa3, 0x00, 0x00, 0x80, 0x01, 0x0f, 0x80, 0x08, 0xdd, 0x01, 0x00, 0x80,
   0x01, 0x00, 0x00, 0x11, 0x21, 0x03, 0x00, 0x80, 0x01, 0x00, 0x00, 0x21,
   0x19, 0x02, 0x80, 0x80, 0x01, 0x00, 0x00, 0xc1, 0x07, 0x04, 0x80, 0x80,
   0x01, 0x00, 0xc0, 0xc1, 0x03, 0x08, 0x80, 0x80, 0x01, 0x00, 0x60, 0xc0,
   0x03, 0x08, 0xfe, 0x80, 0x01, 0x00, 0x30, 0xc0, 0x03, 0x08, 0x00, 0x80,
   0x01, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x80, 0x01, 0x00, 0x06, 0x00,
   0x00, 0x08, 0x00, 0x80, 0x01, 0x00, 0x03, 0x00, 0x00, 0x10, 0x00, 0x80,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


/***	File Input Icon 	***/

const int fileIn_width = 64;
const int fileIn_height = 64;
static char fileIn_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xc4, 0xff, 0xff,
   0xff, 0xff, 0x1f, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
   0x00, 0x11, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x80, 0x88, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x80, 0x44, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0x22, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x12, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x80, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x80, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x2a, 0x00, 0xfe,
   0x04, 0x02, 0x00, 0x01, 0x80, 0x2a, 0x00, 0x10, 0x0c, 0x02, 0x00, 0x01,
   0x80, 0x2a, 0x00, 0x10, 0x14, 0x02, 0x00, 0x01, 0x80, 0x2a, 0x00, 0x10,
   0x24, 0x02, 0x00, 0x01, 0x80, 0x2a, 0x00, 0x10, 0x44, 0x02, 0x00, 0x01,
   0x80, 0x2a, 0x00, 0x10, 0x84, 0x02, 0x00, 0x01, 0x80, 0x2a, 0x00, 0x10,
   0x04, 0x03, 0x00, 0x01, 0x80, 0x2b, 0x00, 0xfe, 0x04, 0x02, 0x00, 0x01,
   0x00, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x2e, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Bargraph Icon 	***/

const int barGraph_width = 64;
const int barGraph_height = 64;
static char barGraph_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0xe0, 0x9c, 0x73, 0x00,
   0x00, 0x00, 0x0e, 0x00, 0xe0, 0x9c, 0x73, 0x00, 0x00, 0x00, 0x0e, 0x00,
   0xe0, 0x9c, 0x73, 0x00, 0x00, 0x00, 0x0e, 0x00, 0xe0, 0x9c, 0x73, 0x00,
   0x00, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x00, 0x00, 0x00, 0x0e, 0x38,
   0xe0, 0x9c, 0x73, 0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x00,
   0x00, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x00, 0x00, 0x00, 0x0e, 0x38,
   0xe0, 0x9c, 0x73, 0x00, 0x00, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x00,
   0x1c, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x00, 0x1c, 0x00, 0x0e, 0x38,
   0xe0, 0x9c, 0x73, 0x00, 0x1c, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x00,
   0x1c, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x0e, 0x1c, 0x00, 0x0e, 0x38,
   0xe0, 0x9c, 0x73, 0x0e, 0x1c, 0x00, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x0e,
   0x9c, 0x03, 0x0e, 0x38, 0xe0, 0x9c, 0x73, 0x0e, 0x9c, 0x03, 0x0e, 0x38,
   0xe0, 0x9c, 0x73, 0x0e, 0x9c, 0x03, 0xce, 0x39, 0xe0, 0x9c, 0x73, 0x0e,
   0x9c, 0x03, 0xce, 0x39, 0xe0, 0x9c, 0x73, 0x0e, 0x9c, 0x03, 0xce, 0x39,
   0xe0, 0x9c, 0x73, 0x0e, 0x9c, 0x03, 0xce, 0x39, 0xe0, 0x9c, 0x73, 0xce,
   0x9c, 0x03, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x03, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x03, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x03, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x03, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x03, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x03, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39,
   0xe7, 0x9c, 0x73, 0xce, 0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce,
   0x9c, 0x73, 0xce, 0x39, 0xe7, 0x9c, 0x73, 0xce};


/***	Bubble Icon 	***/

const int bubble_width = 64;
const int bubble_height = 64;
static char bubble_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0xee, 0x00, 0x00, 0x80, 0x08, 0x7c, 0x00, 0x00, 0x01, 0x01, 0x00,
   0x40, 0x10, 0x83, 0x01, 0x00, 0x01, 0x01, 0x00, 0x40, 0x10, 0x01, 0x01,
   0x00, 0x01, 0x01, 0x00, 0x40, 0x90, 0x00, 0x02, 0x80, 0x00, 0x02, 0x00,
   0x80, 0x88, 0x00, 0x02, 0x00, 0x01, 0x01, 0x00, 0x00, 0x87, 0x00, 0x02,
   0x00, 0x01, 0x01, 0x00, 0x00, 0x80, 0x00, 0x02, 0x00, 0x01, 0x01, 0x00,
   0x00, 0x80, 0x00, 0x02, 0x00, 0xee, 0x00, 0x00, 0xf8, 0x00, 0x01, 0x01,
   0x00, 0x10, 0x00, 0x00, 0x04, 0x01, 0x83, 0x01, 0xf8, 0x00, 0x00, 0x00,
   0x02, 0x02, 0x7c, 0x00, 0x06, 0x03, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
   0x01, 0x04, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x01, 0x04, 0x10, 0x00,
   0x02, 0x02, 0x00, 0x80, 0x00, 0x08, 0xee, 0x00, 0x02, 0x02, 0x00, 0x80,
   0x00, 0x88, 0x01, 0x03, 0x04, 0x01, 0x7c, 0x80, 0x00, 0x48, 0x00, 0x04,
   0xf8, 0x00, 0x82, 0x80, 0x00, 0x48, 0x00, 0x04, 0x00, 0x00, 0x01, 0x81,
   0x00, 0x28, 0x00, 0x08, 0x00, 0x00, 0x01, 0x01, 0x01, 0x24, 0x00, 0x08,
   0x00, 0x00, 0x01, 0x01, 0x01, 0x24, 0x00, 0x08, 0x00, 0x00, 0x01, 0x01,
   0x06, 0x13, 0x00, 0x10, 0x00, 0x00, 0x01, 0x01, 0xf8, 0x20, 0x00, 0x08,
   0x00, 0x00, 0x82, 0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xee, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x83, 0x01, 0x10, 0x00, 0x60, 0x30, 0x00, 0x80,
   0x00, 0x02, 0x00, 0x00, 0x20, 0x20, 0x00, 0x80, 0x00, 0x02, 0x00, 0x00,
   0x10, 0x40, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x10, 0x40, 0x00, 0x40,
   0x00, 0x04, 0x00, 0x00, 0x10, 0x40, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00,
   0x10, 0x40, 0x00, 0x40, 0x00, 0x04, 0x00, 0x00, 0x10, 0x40, 0x00, 0x40,
   0x00, 0x04, 0x1c, 0x00, 0x20, 0x20, 0xfc, 0x81, 0x00, 0x02, 0x22, 0x00,
   0x60, 0x30, 0x02, 0x82, 0x00, 0x02, 0x41, 0x00, 0x80, 0x0f, 0x01, 0x04,
   0x83, 0x01, 0x41, 0x00, 0x00, 0x80, 0x00, 0x08, 0x7c, 0x00, 0x41, 0x00,
   0x00, 0x40, 0x00, 0x10, 0x00, 0x00, 0x22, 0x00, 0x00, 0x40, 0x00, 0x10,
   0x00, 0x00, 0x1c, 0x00, 0x00, 0x40, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
   0x70, 0x40, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x88, 0x40, 0x00, 0x10,
   0x00, 0x00, 0x00, 0x00, 0x04, 0x41, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x42, 0x00, 0x10, 0x00, 0x00, 0x7c, 0x00, 0x02, 0x82, 0x00, 0x08,
   0x7c, 0x00, 0x83, 0x01, 0x02, 0x02, 0x01, 0x04, 0x82, 0x80, 0x00, 0x02,
   0x04, 0x01, 0x02, 0x02, 0x01, 0x41, 0x00, 0x04, 0x88, 0x00, 0xfc, 0x81,
   0x00, 0x42, 0x00, 0x04, 0x70, 0x00, 0x00, 0x80, 0x00, 0x22, 0x00, 0x08,
   0x00, 0x1c, 0x00, 0x80, 0x00, 0x22, 0x00, 0x08, 0x00, 0x22, 0x00, 0x80,
   0x00, 0x22, 0x00, 0x08, 0x00, 0x22, 0x00, 0x80, 0x00, 0x22, 0x00, 0x08,
   0x00, 0x22, 0x00, 0x00, 0x01, 0x21, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x00,
   0x82, 0x40, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40, 0x00, 0x04,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Constour Icon 	***/

const int contour_width = 64;
const int contour_height = 64;
static char contour_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x12, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc9, 0x49, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x15, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x54, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x15, 0x54, 0x00, 0x00, 0x00, 0x0a, 0x00,
   0x00, 0x25, 0x52, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0xc9, 0x49, 0x00,
   0x80, 0xff, 0xff, 0x3f, 0x00, 0x13, 0x64, 0x00, 0x80, 0x40, 0x40, 0x20,
   0x00, 0xe2, 0x23, 0x00, 0x80, 0xfe, 0xff, 0x2f, 0x00, 0x02, 0x20, 0x00,
   0x80, 0x12, 0x00, 0x29, 0x00, 0xfe, 0x3f, 0x00, 0x80, 0x8a, 0x3f, 0x2a,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x46, 0x5f, 0x2c, 0x00, 0x00, 0x00, 0x00,
   0x80, 0xe2, 0xe0, 0x28, 0x00, 0x00, 0x00, 0x00, 0x80, 0x33, 0x9f, 0x39,
   0x00, 0x00, 0x00, 0x00, 0x80, 0xaa, 0xae, 0x2a, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x5a, 0x51, 0x6b, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xda, 0x60, 0xab,
   0x00, 0x00, 0x00, 0x00, 0x90, 0xda, 0x60, 0x2b, 0x01, 0x00, 0x00, 0x00,
   0xa0, 0xda, 0x60, 0xab, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x5a, 0x51, 0x6b,
   0x00, 0x00, 0x00, 0x00, 0x80, 0xaa, 0xae, 0x2a, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x33, 0x9f, 0x39, 0x00, 0x00, 0x00, 0x00, 0x80, 0xe2, 0xe0, 0x28,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x46, 0x5f, 0x2c, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x8a, 0x3f, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x80, 0x12, 0x00, 0x29,
   0x00, 0x00, 0x00, 0x00, 0x80, 0xfe, 0xff, 0x2f, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x40, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x20, 0x1e, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x61, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x80, 0x04, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x50, 0x80, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x50, 0x80, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x80, 0x04, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x90, 0x80, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x41, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x3e, 0x02, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Chart Icon 	***/

const int chart_width = 64;
const int chart_height = 64;
static char chart_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x0e, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x20, 0x0e,
   0x00, 0x03, 0x20, 0x00, 0x00, 0x01, 0x20, 0x0e, 0x00, 0x03, 0x20, 0x00,
   0x00, 0x01, 0x30, 0x0f, 0x00, 0x03, 0x30, 0x02, 0x00, 0x03, 0x30, 0x0f,
   0x10, 0x43, 0x30, 0x23, 0x00, 0x03, 0x74, 0x0f, 0x10, 0x47, 0x70, 0x27,
   0x00, 0x23, 0x74, 0x0f, 0xb0, 0xc7, 0xf0, 0x37, 0x00, 0x27, 0x7c, 0x0f,
   0xb8, 0xe7, 0xf0, 0x77, 0x80, 0x77, 0x7e, 0x1f, 0xb8, 0xe7, 0xfc, 0x77,
   0x80, 0x77, 0x7e, 0x9f, 0xf8, 0xef, 0xfe, 0x7f, 0x80, 0x77, 0x7e, 0x9f,
   0xf9, 0xef, 0xff, 0x7f, 0x80, 0x7f, 0xfe, 0x9f, 0xf9, 0xff, 0xff, 0x7f,
   0x80, 0xff, 0xff, 0xdf, 0xfb, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xdf,
   0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x82, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xc6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xce, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


/***    Cluster Icon    ***/
#define cluster_width 64
#define cluster_height 64
static char cluster_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0f, 0x0f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x80, 0x01,
   0x00, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x80, 0x01, 0x00, 0xff, 0xff, 0x1f,
   0xc0, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x1f, 0xc0, 0x07, 0x00, 0x00,
   0x00, 0xfe, 0xff, 0x1f, 0xe0, 0x07, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x1f,
   0xf0, 0x0f, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0xf8, 0x1f, 0x00, 0x00,
   0x00, 0xf8, 0xff, 0x1f, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x0f,
   0xfe, 0x3f, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x07, 0xff, 0x7f, 0x00, 0x00,
   0x00, 0xf8, 0xff, 0xfb, 0xff, 0xff, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xfc,
   0xff, 0xff, 0x03, 0x00, 0x00, 0xf8, 0x0f, 0xfe, 0xff, 0xff, 0xff, 0x03,
   0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xfe,
   0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x3f,
   0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xfc,
   0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x1f,
   0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0x0f, 0xc0, 0xff, 0x03, 0x00,
   0x00, 0xf8, 0xff, 0x07, 0xc0, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x03,
   0xe0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0xf8, 0x01, 0xe0, 0xff, 0xff, 0x0f,
   0x00, 0x00, 0xf0, 0x00, 0xe0, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x80, 0x00,
   0xe0, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x7f,
   0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff,
   0x07, 0xe0, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0x07, 0xf0, 0x07, 0x00,
   0xf0, 0xff, 0xff, 0xff, 0x07, 0xf8, 0x3f, 0x00, 0xf0, 0xff, 0xff, 0xff,
   0x03, 0xfc, 0xff, 0x01, 0xf0, 0xff, 0xff, 0xff, 0x01, 0xfc, 0xff, 0x07,
   0xf0, 0xff, 0xff, 0xff, 0x00, 0xfe, 0xff, 0x07, 0xe0, 0xff, 0xff, 0x7f,
   0x00, 0xfe, 0xff, 0x0f, 0xc0, 0xff, 0xff, 0x1f, 0x00, 0xff, 0xff, 0x0f,
   0xc0, 0xff, 0xff, 0x07, 0x80, 0xff, 0xff, 0x0f, 0x80, 0xff, 0xff, 0x00,
   0x80, 0xff, 0xff, 0x07, 0x80, 0xff, 0x7f, 0x00, 0x80, 0xff, 0xff, 0x03,
   0x80, 0xff, 0x07, 0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0xfc, 0x03, 0x00,
   0x00, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x0f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Dial Icon 	***/

const int dial_width = 64;
const int dial_height = 64;
static char dial_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
   0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x38, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x60, 0x00, 0x00,
   0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x41, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0xc0, 0x41, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x81, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x20, 0x81, 0x00, 0x40, 0x00, 0x00, 0x00,
   0x00, 0x10, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02,
   0x20, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x02, 0x00, 0x02, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04,
   0x10, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x00,
   0x40, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
   0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
   0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0xc0, 0x00, 0x00,
   0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x60, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	History Dial Icon 	***/

const int historyDial_width = 64;
const int historyDial_height = 64;
static char historyDial_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
   0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x38, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x60, 0x00, 0x00,
   0x00, 0xc0, 0x00, 0x00, 0x00, 0x87, 0x01, 0x00, 0x00, 0x20, 0x00, 0x00,
   0x80, 0x07, 0x02, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x07, 0x04, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x41, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0xc0, 0x41, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x81, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x20, 0x81, 0x00, 0x40, 0x00, 0x00, 0x00,
   0x00, 0x10, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02,
   0x20, 0x00, 0x00, 0x00, 0x00, 0x04, 0x78, 0x02, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x02, 0x70, 0x02, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x04,
   0x10, 0x00, 0x00, 0x00, 0x80, 0x00, 0x20, 0x04, 0x10, 0x00, 0x00, 0x00,
   0x40, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
   0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
   0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
   0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0xc0, 0x00, 0x00,
   0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x60, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Interval Icon 	***/

const int interval_width = 64;
const int interval_height = 64;
static char interval_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0xaa, 0xaa, 0xaa,
   0xaa, 0xaa, 0x2a, 0x01, 0x80, 0x54, 0x55, 0x55, 0x55, 0x55, 0x55, 0x01,
   0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x2a, 0x01, 0x80, 0x54, 0x55, 0x55,
   0x55, 0x55, 0x55, 0x01, 0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x2a, 0x01,
   0x80, 0x54, 0x55, 0x55, 0x55, 0x55, 0x55, 0x01, 0x80, 0xaa, 0xaa, 0xaa,
   0xaa, 0xaa, 0x2a, 0x01, 0x80, 0x54, 0x55, 0x55, 0x55, 0x55, 0x55, 0x01,
   0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x2a, 0x01, 0x80, 0x54, 0x55, 0x55,
   0x55, 0x55, 0x55, 0x01, 0x80, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x2a, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
   0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Kiviat Icon 	***/

const int kiviat_width = 64;
const int kiviat_height = 64;
static char kiviat_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x81,
   0xc0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x38, 0x80, 0x00, 0x0e, 0x00, 0x00,
   0x00, 0x00, 0x06, 0x80, 0x00, 0x30, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80,
   0x00, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x20, 0x00, 0x80, 0x00, 0x00, 0x02, 0x00, 0x00, 0x10, 0x00, 0x80,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x04, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0x0a, 0x00, 0x80,
   0x00, 0x00, 0x28, 0x00, 0x00, 0x11, 0x00, 0x80, 0x00, 0x00, 0x44, 0x00,
   0x80, 0x20, 0x00, 0x80, 0x00, 0x00, 0x82, 0x00, 0x40, 0x40, 0x00, 0x80,
   0x00, 0xf0, 0x01, 0x01, 0x40, 0x80, 0x7f, 0x80, 0xf0, 0xff, 0x01, 0x01,
   0x20, 0x80, 0xff, 0xff, 0xff, 0xff, 0x01, 0x02, 0x20, 0x80, 0xff, 0xff,
   0xff, 0xff, 0x03, 0x02, 0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x04,
   0x10, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x03, 0x04, 0x10, 0xe0, 0xff, 0xff,
   0xff, 0xff, 0x03, 0x04, 0x08, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x08,
   0x08, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x08, 0x08, 0xf0, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x08, 0x04, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x07, 0x10,
   0x04, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x10, 0x04, 0xf8, 0xff, 0xff,
   0xff, 0xff, 0x0f, 0x10, 0x04, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x10,
   0x04, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x10, 0x04, 0xfc, 0xff, 0xff,
   0xff, 0xff, 0x1f, 0x10, 0x04, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x10,
   0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x04, 0xfc, 0xff, 0xff,
   0xff, 0xff, 0x07, 0x10, 0x04, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x10,
   0x04, 0xe0, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x10, 0x04, 0x80, 0xff, 0xff,
   0xff, 0x0f, 0x00, 0x10, 0x04, 0x00, 0xfe, 0xff, 0xff, 0x01, 0x00, 0x10,
   0x08, 0x00, 0xfc, 0xff, 0x7f, 0x00, 0x00, 0x08, 0x08, 0x00, 0xf0, 0xff,
   0x5f, 0x00, 0x00, 0x08, 0x08, 0x00, 0xe0, 0xff, 0x9f, 0x00, 0x00, 0x08,
   0x10, 0x00, 0xc0, 0xff, 0x0f, 0x01, 0x00, 0x04, 0x10, 0x00, 0x20, 0xff,
   0x0f, 0x02, 0x00, 0x04, 0x10, 0x00, 0x10, 0xfe, 0x07, 0x04, 0x00, 0x04,
   0x20, 0x00, 0x08, 0xfc, 0x03, 0x08, 0x00, 0x02, 0x20, 0x00, 0x04, 0xf8,
   0x03, 0x10, 0x00, 0x02, 0x40, 0x00, 0x02, 0xe0, 0x01, 0x20, 0x00, 0x01,
   0x40, 0x00, 0x01, 0xc0, 0x01, 0x40, 0x00, 0x01, 0x80, 0x80, 0x00, 0x80,
   0x00, 0x80, 0x80, 0x00, 0x00, 0x41, 0x00, 0x80, 0x00, 0x00, 0x41, 0x00,
   0x00, 0x22, 0x00, 0x80, 0x00, 0x00, 0x22, 0x00, 0x00, 0x14, 0x00, 0x80,
   0x00, 0x00, 0x14, 0x00, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x20, 0x00, 0x80,
   0x00, 0x00, 0x02, 0x00, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x80, 0x01, 0x80, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x06, 0x80,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x38, 0x80, 0x00, 0x0e, 0x00, 0x00,
   0x00, 0x00, 0xc0, 0x81, 0xc0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
   0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	LED Icon 	***/

const int led_width = 64;
const int led_height = 64;
static char led_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff,
   0xff, 0xff, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff,
   0xff, 0xff, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x55, 0x55, 0x55, 0x55, 0x01, 0x00,
   0x00, 0x40, 0xaa, 0xaa, 0xaa, 0x2a, 0x01, 0x00, 0x00, 0x40, 0x55, 0x55,
   0x55, 0x55, 0x01, 0x00, 0x00, 0x40, 0xaa, 0xaa, 0xaa, 0x2a, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff,
   0xff, 0xff, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x40, 0x55, 0x55, 0x55, 0x55, 0x01, 0x00, 0x00, 0x40, 0xaa, 0xaa,
   0xaa, 0x2a, 0x01, 0x00, 0x00, 0x40, 0x55, 0x55, 0x55, 0x55, 0x01, 0x00,
   0x00, 0x40, 0xaa, 0xaa, 0xaa, 0x2a, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0xaa, 0xaa,
   0xaa, 0x2a, 0x01, 0x00, 0x00, 0x40, 0x55, 0x55, 0x55, 0x55, 0x01, 0x00,
   0x00, 0x40, 0xaa, 0xaa, 0xaa, 0x2a, 0x01, 0x00, 0x00, 0x40, 0x55, 0x55,
   0x55, 0x55, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00};


/***	Matrix Icon 	***/

const int matrix_width = 64;
const int matrix_height = 64;
static char matrix_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0xa9, 0xaa, 0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0x55, 0x95,
   0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0xa9, 0xaa, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0x55, 0x95, 0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0xa9, 0xaa,
   0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0x55, 0x95, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0xa9, 0xaa, 0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0x55, 0x95,
   0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0xa9, 0xaa, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0x55, 0x95, 0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0xa9, 0xaa,
   0x00, 0x40, 0x00, 0x40, 0x02, 0x00, 0x55, 0x95, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0x24, 0x49, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80,
   0x48, 0x52, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80, 0x92, 0x44, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0x24, 0x49, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80,
   0x48, 0x52, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80, 0x92, 0x44, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0x24, 0x49, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80,
   0x48, 0x52, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80, 0x92, 0x44, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0x24, 0x49, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80,
   0x48, 0x52, 0x00, 0x40, 0x02, 0x00, 0x01, 0x80, 0x92, 0x44, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80,
   0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80,
   0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80,
   0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80,
   0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0xfe, 0xff, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x7f, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0x00, 0x40,
   0x02, 0x00, 0x01, 0x80, 0xfe, 0x5f, 0x55, 0x55, 0x02, 0x00, 0x01, 0x80,
   0x00, 0x40, 0xaa, 0x4a, 0x02, 0x00, 0x01, 0x80, 0xfe, 0x5f, 0x55, 0x55,
   0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0xaa, 0x4a, 0x02, 0x00, 0x01, 0x80,
   0xfe, 0x5f, 0x55, 0x55, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0xaa, 0x4a,
   0x02, 0x00, 0x01, 0x80, 0xfe, 0x5f, 0x55, 0x55, 0x02, 0x00, 0x01, 0x80,
   0x00, 0x40, 0xaa, 0x4a, 0x02, 0x00, 0x01, 0x80, 0xfe, 0x5f, 0x55, 0x55,
   0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0xaa, 0x4a, 0x02, 0x00, 0x01, 0x80,
   0xfe, 0x5f, 0x55, 0x55, 0x02, 0x00, 0x01, 0x80, 0x00, 0x40, 0xaa, 0x4a,
   0x02, 0x00, 0x01, 0x80, 0xfe, 0x5f, 0x55, 0x55, 0x02, 0x00, 0x01, 0x80,
   0x00, 0x40, 0x00, 0x40, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***    ParallelCoords  ***/

#define parallelCoords_width 64
#define parallelCoords_height 64
static char parallelCoords_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08,
   0x20, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02,
   0x80, 0x00, 0x02, 0x08, 0x20, 0x80, 0x00, 0x02, 0x80, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Piechart Icon 	***/

const int piechart_width = 64;
const int piechart_height = 64;
static char piechart_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff,
   0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x18, 0xfe, 0xff, 0x0f, 0x00, 0x00,
   0x00, 0x00, 0x06, 0xfe, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x80, 0x01, 0xfe,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x40, 0x00, 0xfe, 0xff, 0xff, 0x01, 0x00,
   0x00, 0x30, 0x00, 0xfc, 0xff, 0xff, 0x07, 0x00, 0x00, 0x08, 0x00, 0xfc,
   0xff, 0xff, 0x0f, 0x00, 0x00, 0x04, 0x00, 0xfc, 0xff, 0xff, 0x1f, 0x00,
   0x00, 0x02, 0x00, 0xfc, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x01, 0x00, 0xf8,
   0xff, 0xff, 0x4f, 0x00, 0x00, 0x01, 0x00, 0xf8, 0xff, 0xff, 0x47, 0x00,
   0x80, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x83, 0x00, 0x40, 0x00, 0x00, 0xf8,
   0xff, 0xff, 0x01, 0x01, 0x40, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x01,
   0x20, 0x00, 0x00, 0xf0, 0xff, 0x7f, 0x7e, 0x02, 0xe0, 0x00, 0x00, 0xf0,
   0xff, 0x3f, 0x00, 0x02, 0x10, 0x03, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0x04,
   0x50, 0x0c, 0x00, 0xe0, 0xff, 0xcf, 0xff, 0x05, 0x48, 0x30, 0x00, 0xe0,
   0xff, 0x07, 0x00, 0x08, 0x48, 0xc2, 0x00, 0xe0, 0xff, 0x01, 0x00, 0x08,
   0x48, 0x12, 0x03, 0xe0, 0xff, 0xfc, 0xff, 0x0b, 0x44, 0x12, 0x04, 0xc0,
   0x7f, 0x00, 0x00, 0x10, 0x44, 0x92, 0x18, 0xc0, 0x3f, 0x00, 0x00, 0x10,
   0x44, 0x92, 0x60, 0xc0, 0x9f, 0xff, 0xff, 0x17, 0x44, 0x92, 0x84, 0xc1,
   0x0f, 0x00, 0x00, 0x10, 0x44, 0x92, 0x24, 0x86, 0x07, 0x00, 0x00, 0x10,
   0x44, 0x92, 0x24, 0x98, 0xf3, 0xff, 0xff, 0x17, 0x44, 0x92, 0x24, 0x61,
   0x01, 0x00, 0x00, 0x10, 0x44, 0x92, 0x24, 0xe0, 0x00, 0x00, 0x00, 0x10,
   0x44, 0x92, 0x04, 0xfe, 0xf9, 0xff, 0xff, 0x17, 0x44, 0x92, 0xe0, 0x55,
   0x03, 0x00, 0x00, 0x10, 0x44, 0x02, 0xbe, 0xaa, 0x06, 0x00, 0x00, 0x10,
   0x44, 0xe0, 0x55, 0x55, 0xe5, 0xff, 0xff, 0x17, 0x04, 0xbe, 0xaa, 0xaa,
   0x0a, 0x00, 0x00, 0x10, 0xe4, 0x55, 0x55, 0x55, 0x15, 0x00, 0x00, 0x10,
   0xbc, 0xaa, 0xaa, 0xaa, 0x2a, 0xff, 0xff, 0x13, 0x58, 0x55, 0x55, 0x55,
   0x55, 0x00, 0x00, 0x08, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x08,
   0x58, 0x55, 0x55, 0x55, 0x55, 0xf9, 0xff, 0x09, 0xb0, 0xaa, 0xaa, 0xaa,
   0xaa, 0x01, 0x00, 0x04, 0x50, 0x55, 0x55, 0x55, 0x55, 0x03, 0x00, 0x04,
   0xa0, 0xaa, 0xaa, 0xaa, 0xaa, 0xe6, 0xff, 0x02, 0x60, 0x55, 0x55, 0x55,
   0x55, 0x0d, 0x00, 0x02, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0x1a, 0x00, 0x01,
   0x40, 0x55, 0x55, 0x55, 0x55, 0x35, 0x3f, 0x01, 0x80, 0xaa, 0xaa, 0xaa,
   0xaa, 0x6a, 0x80, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40, 0x00,
   0x00, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0x4c, 0x00, 0x00, 0x56, 0x55, 0x55,
   0x55, 0x55, 0x21, 0x00, 0x00, 0xac, 0xaa, 0xaa, 0xaa, 0xaa, 0x12, 0x00,
   0x00, 0x58, 0x55, 0x55, 0x55, 0x55, 0x09, 0x00, 0x00, 0xb0, 0xaa, 0xaa,
   0xaa, 0xaa, 0x06, 0x00, 0x00, 0x40, 0x55, 0x55, 0x55, 0x55, 0x01, 0x00,
   0x00, 0x80, 0xab, 0xaa, 0xaa, 0xea, 0x00, 0x00, 0x00, 0x00, 0x56, 0x55,
   0x55, 0x35, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xaa, 0xaa, 0x0e, 0x00, 0x00,
   0x00, 0x00, 0x70, 0x55, 0xd5, 0x03, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff,
   0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Polar Plot Icon 	***/

const int polarPlot_width = 64;
const int polarPlot_height = 64;
static char polarPlot_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xbf, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x80,
   0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x80, 0x00, 0x1c, 0x00, 0x00,
   0x00, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80,
   0x00, 0x80, 0x00, 0x00, 0x00, 0x60, 0x00, 0x80, 0x00, 0x00, 0x03, 0x00,
   0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0x80,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0xfe, 0x3f, 0x00, 0x10, 0x00,
   0x00, 0x0a, 0xc0, 0x81, 0xc0, 0x01, 0x28, 0x00, 0x00, 0x11, 0x20, 0x80,
   0x00, 0x02, 0x44, 0x00, 0x80, 0x20, 0x18, 0x80, 0x00, 0x0c, 0x82, 0x00,
   0x80, 0x40, 0x04, 0x80, 0x00, 0x10, 0x81, 0x00, 0x40, 0x80, 0x03, 0x80,
   0x00, 0xe0, 0x00, 0x01, 0x20, 0x80, 0x01, 0x80, 0x00, 0xc0, 0x00, 0x02,
   0x20, 0x80, 0x02, 0x80, 0x00, 0xa0, 0x00, 0x02, 0x10, 0x40, 0x04, 0xf8,
   0x0f, 0x10, 0x01, 0x04, 0x10, 0x20, 0x08, 0x86, 0x30, 0x08, 0x02, 0x04,
   0x10, 0x20, 0x90, 0x81, 0xc0, 0x04, 0x02, 0x04, 0x08, 0x10, 0x60, 0x80,
   0x00, 0x03, 0x04, 0x08, 0x08, 0x08, 0x60, 0x80, 0x00, 0x03, 0x08, 0x08,
   0x08, 0x08, 0x90, 0x80, 0x80, 0x04, 0x08, 0x08, 0x04, 0x08, 0x10, 0x81,
   0x40, 0x04, 0x08, 0x10, 0x04, 0x04, 0x08, 0xf2, 0x27, 0x08, 0x10, 0x10,
   0x04, 0x04, 0x08, 0x8c, 0x18, 0x08, 0x10, 0x10, 0x04, 0x04, 0x04, 0x8c,
   0x18, 0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x92, 0x24, 0x10, 0x10, 0x10,
   0x04, 0x04, 0x04, 0xa2, 0x22, 0x10, 0x10, 0x10, 0x02, 0x04, 0x04, 0xc2,
   0x21, 0x10, 0x10, 0x20, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
   0x02, 0x04, 0x04, 0xc2, 0x21, 0x10, 0x10, 0x20, 0x04, 0x04, 0x04, 0xa2,
   0x22, 0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x92, 0x24, 0x10, 0x10, 0x10,
   0x04, 0x04, 0x04, 0x8c, 0x18, 0x10, 0x10, 0x10, 0x04, 0x04, 0x08, 0x8c,
   0x18, 0x08, 0x10, 0x10, 0x04, 0x04, 0x08, 0xf2, 0x27, 0x08, 0x10, 0x10,
   0x04, 0x08, 0x10, 0x81, 0x40, 0x04, 0x08, 0x10, 0x08, 0x08, 0x90, 0x80,
   0x80, 0x04, 0x08, 0x08, 0x08, 0x08, 0x60, 0x80, 0x00, 0x03, 0x08, 0x08,
   0x08, 0x10, 0x60, 0x80, 0x00, 0x03, 0x04, 0x08, 0x10, 0x20, 0x90, 0x81,
   0xc0, 0x04, 0x02, 0x04, 0x10, 0x20, 0x08, 0x86, 0x30, 0x08, 0x02, 0x04,
   0x10, 0x40, 0x04, 0xf8, 0x0f, 0x10, 0x01, 0x04, 0x20, 0x80, 0x02, 0x80,
   0x00, 0xa0, 0x00, 0x02, 0x20, 0x80, 0x01, 0x80, 0x00, 0xc0, 0x00, 0x02,
   0x40, 0x80, 0x03, 0x80, 0x00, 0xe0, 0x00, 0x01, 0x80, 0x40, 0x04, 0x80,
   0x00, 0x10, 0x81, 0x00, 0x80, 0x20, 0x18, 0x80, 0x00, 0x0c, 0x82, 0x00,
   0x00, 0x11, 0x20, 0x80, 0x00, 0x02, 0x44, 0x00, 0x00, 0x0a, 0xc0, 0x81,
   0xc0, 0x01, 0x28, 0x00, 0x00, 0x04, 0x00, 0xfe, 0x3f, 0x00, 0x10, 0x00,
   0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x80,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x60, 0x00, 0x80, 0x00, 0x00, 0x03, 0x00,
   0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80,
   0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x80, 0x00, 0x1c, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x80, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf,
   0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Printer Icon 	***/

const int printer_width = 64;
const int printer_height = 64;
static char printer_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0x9f, 0x3f, 0xdf, 0x7f, 0xfc, 0xf1, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0xe3, 0xe7, 0x7f, 0xfc, 0xc7, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xf8, 0xef,
   0x7f, 0xff, 0xf8, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x78, 0xf8, 0xe3, 0x87, 0x7f, 0x7c, 0xfc, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x9f, 0x3f, 0xdf,
   0x7f, 0xfc, 0xf1, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0xe3, 0xe7, 0x7f, 0xfc, 0xc7, 0xff, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0xff, 0xf8, 0xef, 0x7f, 0xff, 0xf8, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xf8, 0xe3, 0x87,
   0x7f, 0x7c, 0xfc, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x9f, 0x3f, 0xdf, 0x7f, 0xfc, 0xf1, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xe3, 0xe7, 0x7f,
   0xfc, 0xc7, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xf8, 0xef, 0x7f, 0xff, 0xf8, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x67, 0xfc, 0xf8, 0x1f, 0xfc, 0xcf, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xe3, 0xe7, 0x7f,
   0xfc, 0xc7, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xf8, 0xef, 0x7f, 0xff, 0xf8, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x78, 0xf8, 0xe3, 0x87, 0x7f, 0x7c, 0xfc, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***    Profile Icon    ***/

#define profile_width 64
#define profile_height 64
static char profile_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,
   0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x2e, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xfe, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00};


/***    ScatterPlotMatrix Icon ***/

#define scatterPlotMatrix_width 64
#define scatterPlotMatrix_height 64
static char scatterPlotMatrix_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x1f, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10,
   0x50, 0x55, 0x05, 0x00, 0x01, 0x40, 0x00, 0x10, 0x90, 0xaa, 0x04, 0x00,
   0x01, 0x40, 0x00, 0x10, 0x50, 0x55, 0x05, 0x00, 0x01, 0x40, 0x00, 0x10,
   0x90, 0xaa, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10, 0x50, 0x55, 0x05, 0x00,
   0x01, 0x40, 0x00, 0x10, 0x90, 0xaa, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10,
   0x50, 0x55, 0x05, 0x00, 0x01, 0x40, 0x00, 0x10, 0x90, 0xaa, 0x04, 0x00,
   0x01, 0x40, 0x00, 0x10, 0x50, 0x55, 0x05, 0x00, 0x01, 0x40, 0x00, 0x10,
   0x90, 0xaa, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10, 0x50, 0x55, 0x05, 0x00,
   0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x10, 0x00, 0x04, 0x00,
   0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x54, 0x55, 0x01, 0x40, 0x00, 0x10,
   0x10, 0x00, 0xa4, 0x2a, 0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x54, 0x55,
   0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0xa4, 0x2a, 0x01, 0x40, 0x00, 0x10,
   0x10, 0x00, 0x54, 0x55, 0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0xa4, 0x2a,
   0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x54, 0x55, 0x01, 0x40, 0x00, 0x10,
   0x10, 0x00, 0xa4, 0x2a, 0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x54, 0x55,
   0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0xa4, 0x2a, 0x01, 0x40, 0x00, 0x10,
   0x10, 0x00, 0x54, 0x55, 0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00,
   0x01, 0x40, 0x00, 0x10, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00,
   0x55, 0x55, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00, 0xa9, 0x4a, 0x00, 0x10,
   0x10, 0x00, 0x04, 0x00, 0x55, 0x55, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00,
   0xa9, 0x4a, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00, 0x55, 0x55, 0x00, 0x10,
   0x10, 0x00, 0x04, 0x00, 0xa9, 0x4a, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00,
   0x55, 0x55, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00, 0xa9, 0x4a, 0x00, 0x10,
   0x10, 0x00, 0x04, 0x00, 0x55, 0x55, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00,
   0xa9, 0x4a, 0x00, 0x10, 0x10, 0x00, 0x04, 0x00, 0x55, 0x55, 0x00, 0x10,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10, 0xf0, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x1f, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x55, 0x15, 0x10, 0x00, 0x04, 0x00,
   0x01, 0x40, 0xaa, 0x12, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x55, 0x15,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0xaa, 0x12, 0x10, 0x00, 0x04, 0x00,
   0x01, 0x40, 0x55, 0x15, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0xaa, 0x12,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x55, 0x15, 0x10, 0x00, 0x04, 0x00,
   0x01, 0x40, 0xaa, 0x12, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x55, 0x15,
   0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0xaa, 0x12, 0x10, 0x00, 0x04, 0x00,
   0x01, 0x40, 0x55, 0x15, 0x10, 0x00, 0x04, 0x00, 0x01, 0x40, 0x00, 0x10,
   0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/***	Scatter3D Icon 	***/

const int scatter3D_width = 64;
const int scatter3D_height = 64;
static char scatter3D_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f,
   0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x40, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x0a, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x09,
   0x00, 0x10, 0x01, 0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x08, 0x01, 0x00,
   0x00, 0x00, 0x40, 0x08, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x20, 0x08,
   0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x01, 0x01, 0x00,
   0x00, 0x00, 0x08, 0x08, 0x80, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x08,
   0x40, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x08, 0xe0, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08,
   0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x20, 0x00, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x0f, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
   0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x20, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x01, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x81, 0x00,
   0x20, 0x08, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x20, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
   0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0xa0, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x05, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
   0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

/***	XYgraph Icon 	***/

const int XYgraph_width = 64;
const int XYgraph_height = 64;
static char XYgraph_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x10, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0xe0, 0x7f, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x18,
   0x80, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x06, 0x00, 0x78, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x03, 0x40, 0x80, 0x03, 0x00, 0x08, 0x00, 0xc0, 0x00,
   0x00, 0x00, 0x0c, 0x00, 0x08, 0x00, 0x20, 0x00, 0x00, 0x00, 0x30, 0x00,
   0x08, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80, 0x00, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
   0x08, 0x20, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x04, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x20, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x0c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#endif FUPixmaps_h
