/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *               University of Illinois at Urbana-Champaign
 *               Department of Computer Science
 *               1304 W. Springfield Avenue
 *               Urbana, IL     61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *      All Rights Reserved.
 *
 * Author: Keith A. Shields (shields@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * 
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Help.h: Implements a hierarchical help system.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/Help.h,v 1.11 1994/03/01 18:56:55 aydt Exp $
 */

#ifndef Help_h
#define Help_h

#include "Obj.h"
#include "Callback.h"

#define MAX_DETAIL_DIRS 256

class Help : public Obj, public virtual Callback {
/*
* Help manages a hierarchical help system for Pablo.
*/
private:
	static const char *const MY_CLASS;      // My class name

	Boolean_ doesDialogExist;

   	char *baseHelpDir; 			// Entry point base directory
	char *currentDir; 			// Current help directory
	char *helpFile;				// Name of help file 
	char *detailDirList[MAX_DETAIL_DIRS];   // List of detail directories

protected:
   	Widget HelpDialog; 			// Popup shell
	Widget HelpPane; 			// Paned window
	Widget ControlArea, ActionArea;		// Form Widgets; parent is Pane
        Widget CurrentTopicLabel, HelpText, DetailLabel, DetailList; 
        Widget okButton, topButton, previousButton;

   Arg    wargs[20];

	/* Method _initializeActionWidgets:	Initializes the action area of
	*					the dialog		      */
   	void _initializeActionWidgets();

	/* Method _initializeControlWidgets:	Initializes the control area of
	*					the dialog	              */
   	void _initializeControlWidgets();

	/* Method _clearDetailList:		Free the space taken by entries
	*					in the detailDirList and also
	*					clear the list on the screen  */
	void _clearDetailList();

	/* Method _getDetailList:		Build a list of the detail 
	*					topics for directory.         */
   	void _getDetailList( const char *directory );

	/* Method _getDetailText:		Sets the detailed topic for
	*					the directory from the first
	*					line of the actual help file. */
   	void _getDetailText( const char *directory );

	/* Method _getHelpText:			Returns help text string      */
   	Boolean_ _getHelpText( const char *directory );

	/* Method _setInitialWidth:		Sets the initial width of the
	*					help box		      */
   	void _setInitialWidth();


public: 
	/* Method Help:			The class constructor		      */
   	Help( Widget partent, char *startdirectory, char *filename );

	/* Method ~Help:		The class descructor		      */
   	~Help();

	/* Method callback1:		Generic callback to accommodate C++.
	*				Used when detailed topic selected.    */
   	virtual void callback1( Widget w, 
				XtPointer clientData, 
				XtPointer callData );
	
	/* Method callback2:		Generic callback to accommodate C++.
	*			        Used when OK selected.                */
   	virtual void callback2( Widget w, 
				XtPointer clientData, 
				XtPointer callData );

	/* Method callback3:		Generic callback to accommodate C++.
	*			        Used when TOP selected.               */
   	virtual void callback3( Widget w, 
				XtPointer clientData, 
				XtPointer callData );

	/* Method callback4:		Generic callback to accommodate C++.
	*			        Used when PREVIOUS selected.          */
   	virtual void callback4( Widget w, 
				XtPointer clientData, 
				XtPointer callData );

	/* Method  dialogExists:	Returns true if the dialog
	*				has been created earlier	      */
   	Boolean_ dialogExists() const ;
};

#endif
