/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

/*
 * IntList.h: A generic list of int objects. Automatically generated.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/IntList.h,v 1.10 1994/02/25 04:30:11 aydt Exp $
 *	
 */

#ifndef IntList_h
#define IntList_h

#include "Obj.h"

class IntList : public Obj {
/*
 *	A IntList is a simple array-like list of int objects. It is
 *	automatically generated from a prototype file.
 */
protected:
	int * list;
	int nItems;
	int nItemsAllocated;

        /* Method computeNewSize:       Determines the updated size of
        *                               the list.			     */
	int computeNewSize(int requestedIndex);

      	/* Method growList:             Increases the size of the list
        *                               of integers.			     */
	void growList(int n);

        /* Method resizeListTo:         Resizes the list to the specified
        *                               size.			            */
	Boolean_ resizeListTo(int n);
	
public:
	/* Method IntList: The IntList constructor */
	IntList(int initialSize = 10);

	/* Method ~IntList: The IntList destructor */
	~IntList();

        /* Method IntList: The IntList constructor */
	IntList(IntList &list);

        /* Method operator=:    integer list assignment                 */
	IntList & operator=(IntList &list);

	/* Method setElement: set element n to elt, expanding 
			      the list if needed			*/
	int setElement( int n, int elt );

	/* Method addElement: Add an element to the end of the list  */
	int addElement( int elt );

	/* Method getElement: Get the n'th element from the list  */ 
	const int getElement( int n ) const;

	/* Method operator[]:	List element selection			*/
	int & operator[]( int n );
	
	/* Method insertElementAt: Insert elt at location n, shifting over all
				   entries to its right to the right */
	int insertElementAt( int n, int elt );

	/* Method deleteElementAt: Delete element n, shifting
				   all entries to its right to the left */
	void deleteElementAt( int n );

	/* Method lookup: Look for elt in the list, returning its index  */
	int lookup( int elt ) const;

	/* Method count: Return the number of elements present
			 (defined as the index of the highest element
			  set) */
	int count() const;

	/* Method allocatedSize: Returns the allocated size of the list  */
	int allocatedSize() const;

	/* Method isEmpty: Returns TRUE_ if the list is empty */
	int isEmpty() const;

	/* Method reset: Reset the list to empty */
	void reset();

	/* Method printOn: Stream output function */
	void printOn(ostream & os) const;
};

inline ostream & operator<<(ostream & os, IntList & var)
{
	var.printOn(os);
	return os;
}

#endif
