/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Author: Ruth Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ModuleId.h: Keeps track of modules and their corresponding information.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ModuleId.h,v 1.12 1994/02/25 04:29:39 aydt Exp $
 *	
 */
#ifndef ModuleId_h
#define ModuleId_h

#include <stdio.h>

#include "Obj.h"
#include "CString.h"
#include "InfrastructureManager.h"

class Wrapper;

class ModuleId : public Obj {
/*
 * A ModuleId identifies a module (= wrapper/fu) in the InfrastructureManager. 
 * The index corresponds to the location of the module in the list of
 * all modules in the system and also identifies it's node in the graph
 * display list of nodes.  As modules are added/deleted, the index for a 
 * particular module may change.  The identifier is unchanging throughout
 * the module's lifetime and is the "pointer" into the TagMappingDictionary
 * for output records created by the module.  Look at InfrastructureManager
 * for the code that manipulates the ModulesIds.
 *
 */

friend void InfrastructureManager::reset();

private:
	static int 	 uniqueIdentifier;	// Class-wide guaranteed unique

	Wrapper 	*wrapper;		// ptr to wrapper
	CString 	 name;			// name of module
	CString 	 fuClassName;		// class name; used by Help 
	int 		 index;			// index in IM::ModuleIdPtrList
	int	 	 identifier;		// id of Module - unchanging

	/* Method _resetUniqueId:		Resets the uniqueIdentifier to
	*					zero.                         */
	static void _resetUniqueId() {
		    uniqueIdentifier = 0;
		} ;		

public:
        /* Method ModuleId: 		The ModuleId constructor.             */
	ModuleId( Wrapper *w, const CString& modName, const CString& fuName );

	/* Method getFuClassName:	Return the name of the FU class       */
	const CString& getFuClassName() const;

	/* Method getIdentifier:	Return the unique identifier for this
	*				Module.                               */
	int getIdentifier() const;

	/* Method getIndex:		Return the index of this module in
	*				the ModuleIdPtrList kept by the IM.   */
	int getIndex() const;

	/* Method getName:		Return the name of the module.        */
	const CString& getName() const;

	/* Method getWrapper:		Return pointer to the wrapper for this
	*				module.                               */
	Wrapper * getWrapper() const;

	/* Method loadConfigurationFromDir:  Load configuration information for
	*				this module.                          */
	Boolean_ loadConfigurationFromDir( const CString& dir );

	/* Method saveConfigurationToDir:    Save configuration information for
	*				this module.                          */
	Boolean_ saveConfigurationToDir( const CString& dir ) const;

	/* Method setIndex:		Set the index for the module.         */
	void setIndex( int i ); 

	/* Method writeLayoutToFP:	Write the layout information to file  */
	void writeLayoutToFP( FILE *fp ) const;
};

inline const CString&
ModuleId::getFuClassName() const
{
	return fuClassName;
}

inline int
ModuleId::getIdentifier() const
{
	return identifier;
}

inline int
ModuleId::getIndex() const
{
	return index;
}

inline const CString&
ModuleId::getName() const
{
	return name;
}

inline Wrapper *
ModuleId::getWrapper() const
{
	return wrapper;
}

inline void
ModuleId::setIndex( int i )
{
	index = i;
}

#endif
