/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * MultivariateFunctionalUnit.h: Manages multi-dimensional data displays
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/MultivariateFunctionalUnit.h,v 1.4 1994/02/25 04:31:30 aydt Exp $
 */

#ifndef MultivariateFunctionalUnit_h
#define MultivariateFunctionalUnit_h

#include "Array.h"
#include "Callback.h"
#include "DisplayFunctionalUnit.h"
#include "MultivariateWidgetWrapper.h"
#include "DoubleList.h"
#include "VoidPtrList.h"

#include <Xm/Separator.h>

#define STRING_MAX_LEN   80

/* Preprocessing mask values */
#define PP_EXTRACT_MINMAX     1
#define PP_RESULTS_ONLY       2
#define PP_NORMALIZE          4


typedef struct {
      Widget dialog;
      int    numParams;
      Widget *scrolledLists, *editAreas;
} ConfigPerDimDataStruct;


typedef int PreprocessMask;
typedef struct {
       Boolean     isInitialized;
       DoubleList  ppMinValues, ppMaxValues;
       double      *mean, *variance, *stdDev;
       double      *sumOfX, *partialEX;
       int         partialCount;
} PreprocessData;


class MultivariateFunctionalUnit : public DisplayFunctionalUnit, 
				   public virtual Callback {
/* 
 * 
 * A MultivariateFunctionalUnit is a special subclass of the display functional
 * units.  This subclass is used to implement n-dimensional data displays
 * 
 */

private:
      static const char *const MY_CLASS;   // My class name
      
protected:
      int              dimension;
      int              pointCount;
      int              updateInterval;

      DoubleList       fuMinValues, fuMaxValues;
      VoidPtrList      fuCategoryLabels;
      double           *savedValues;
      PreprocessMask   preprocessMask;
      PreprocessData   ppData;
      MultivariateWidgetWrapper multivariateWrapper;


	/* Method _createCategoryListArea:	Creates a dialog to
						list categories		*/
      Widget _createCategoryListArea( Widget parentWidget,
				      CString listAreaPrefix,
				      ConfigPerDimDataStruct *data );

	/* Method _createMinValueListArea:	Creates a dialog to
						list minimum values	*/
      Widget _createMinValueListArea( Widget parentWidget,
				      CString listAreaPrefix,
				      ConfigPerDimDataStruct *data );

        /* Method _createMaxValueListArea:      Creates a dialog to
                                                list maximum values     */
      Widget _createMaxValueListArea( Widget parentWidget,
				      CString listAreaPrefix,
				      ConfigPerDimDataStruct *data );

      /* Method _setupPerCategoryDialog: Create the set of widgets associated
	                                  with a dim-by-dim config window */
      Widget _setupPerCategoryDialog( Widget parentWidget,
				      ConfigPerDimDataStruct *data,
				      CString dialogNamePrefix );

      // ------------- Data preprocessing routines -----------------------
      /* Method _initializePPData:  Initialize the pre-processing data
	                          structure upon first invocation of 'run' */
      double * _initializePPData( Array *a );

      /* Method _addPPData: Perform preprocessing for this firing of run() */
      double * _addPPData( Array *a, int nPoints );

      /* Method _completePP:  Finish computations given that run is
	                          complete */
      void _completePP();

public:
      /* Method MultivariateFunctionalUnit: The MultivariateFunctionalUnit
	   constructor */
      MultivariateFunctionalUnit();

      /* Method MultivariateFunctionalUnit: The MultivariateFunctionalUnit
	   destructor */
      ~MultivariateFunctionalUnit();

      /* Method callback2:            Add-change per-dim info callback */
      virtual void callback2(Widget, XtPointer, XtPointer );

      /* Method callback3:            Done-with-config-window callback */
      virtual void callback3(Widget, XtPointer, XtPointer );

      /* Method callback4:            Scrolled list item selection in
	                              per-dim-config window callback */
      virtual void callback4(Widget, XtPointer, XtPointer );
      
      /* Method fuSubclassProcessPerCategoryCallback: Method called to
	   allow subclasses to process the end-of-per-category config */
      virtual void fuSubclassProcessPerCategoryCallback();
};

#endif MultivariateFunctionalUnit_h
