
/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Contributing Author: Robert Olson (olson@csluiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * OutputPort.h: Keeps information about a Functional Unit output port.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/OutputPort.h,v 1.6 1994/02/25 04:28:22 aydt Exp $
 */

#ifndef OutputPort_h
#define OutputPort_h

#include "CString.h"
#include "DataTraits.h"
#include "Value.h"

class OutputPort : public Obj {
/*
* 	An OutputPort is the interface between the FU outputs and the Wrapper.
*	The FU will create the OutputPort, name it, and notify the Wrapper 
*	that it has another OutputPort.  It also sets the traits of the port
*	as soon as they are known.
*
*	During execution of the configured graph, the FU updates the value
*	of the port via the ::setValue() method.  When the FU calls
*	FU::_writeOutput(), the Wrapper in turn causes the value on the
* 	output Port to be written to the appropriate output record field(s).
*
*/	
private:
	static const char *const MY_CLASS;      // The Class name	      

	CString 	      name;		// Port Name; Set in ctor     
	DataTraits 	      currentTraits;	// Traits as fixed by FU

	Value 	      	      value;		// Port value; set by FU

public:
	/* Method OutputPort: 			The constructor 	      */
	OutputPort( const CString& pname );

	/* Method ~OutputPort: 			The destructor 	 	      */
	~OutputPort();

	/* Method getTraits:			Return the traits for port    */
	const DataTraits& getTraits() const;

	/* Method getName:			Returns the name 	      */
	const CString& getName() const;

	/* Method getValue: 			Return the Value.	      */
	const Value& getValue() const;

	/* Method setTraits: 			Set the traits of the port    */
	void setTraits( const DataTraits& traits );

	/* Method setValue: 			Set the value;  Traits of 
	*					newValue should match 
	*					currentTraits.                */
	void setValue( const Value& newValue );

	/* Method printOn: 			Stream output function        */
	void printOn( ostream& os ) const;
};

inline const DataTraits&
OutputPort::getTraits() const
{
	return currentTraits;
}

inline const CString& 
OutputPort::getName() const        
{ 
	return name; 
}

inline const Value&
OutputPort::getValue() const
{
	return value;
}

inline void
OutputPort::setTraits( const DataTraits& traits ) 
{
	currentTraits = traits;
}

inline ostream& operator<<( ostream& os, OutputPort& p )
{
	p.printOn( os );
	return os;
}

#endif OutputPort_h
