/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Pablo.h: Header file for purely static class used to provide global data
 *	    for the Pablo visualization system.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/Pablo.h,v 1.17 1994/02/25 04:29:12 aydt Exp $
 *	
 */

#ifndef Pablo_h
#define Pablo_h

#include "Defines.h"

class FunctionalUnitManager;
class GeneralDialogBox;
class InfrastructureManager;
class TagMappingDictionary;
class PabloHelpSystem;
class StructureDictionary;
class TranscriptWindow;
class TranscriptWindowBuf;
class PabloMainInterface;
class WidgetBase;

class Pablo {
/*
*
* Pablo is the class used to provide global data within the
* object-oriented framework.  main() calls the constructor and
* then calls the initialize mentod to set up the shared values.
*
*/

private:
	static Boolean_			initialized;

	static FunctionalUnitManager 	*globalFUM;
	static InfrastructureManager 	*globalIM;
	static PabloMainInterface 	*globalMainInterface;
	static StructureDictionary 	*globalStructureDict;
	static TagMappingDictionary 	*globalTagMappingDict;
	static WidgetBase		*globalTopLevel;
	static GeneralDialogBox		*globalGeneralDialog;
	static TranscriptWindow		*globalTranscriptWindow;
	static PabloHelpSystem          *globalHelpSystem;

public:
	/* Method Pablo:		Constructor		              */
	Pablo();

	/* Method ~Pablo:		Destructor			      */
	~Pablo();

	/* Method initialize:		Create global instances and initialize
	*				the pointers to them.                 */
	static void initialize( int *argc, char **argv );

	/* Method FUM:			Return pointer to Global Functional
	*				Unit Manager.			      */
	static FunctionalUnitManager * FUM();

	/* Method IM:			Return pointer to Global Infrastructure
	*				Manager.			      */
	static InfrastructureManager * IM();

	/* Method MainInterface:	Return pointer to Global Main 
	*				Interface.			      */
	static PabloMainInterface * MainInterface();

	/* Method StructureDict:	Return pointer to Global Structure
	*				Dictionary.			      */
	static StructureDictionary * StructureDict();

	/* Method TagMappingDict:	Return pointer to Global Tag Mapping
	*				Dictionary.			      */
	static TagMappingDictionary * TagMappingDict();

	/* Method TopLevel:		Return pointer to Global TopLevel - 
	*				Base class for all widgets.           */
	static WidgetBase * TopLevel();

	/* Method GeneralDialog:	Return pointer to Global General
	*				Dialog.				      */
	static GeneralDialogBox * GeneralDialog();

	/* Method Transcript:		Return pointer to Global Transcript
	*				Window.			              */
	static TranscriptWindow * Transcript();

	/* Method HelpSystem:	Return pointer to Global Transcript
	*				Window.			              */
	static PabloHelpSystem * HelpSystem();

};

inline FunctionalUnitManager *
Pablo::FUM() {
	return globalFUM;
}

inline InfrastructureManager *
Pablo::IM() {
	return globalIM;
}

inline PabloMainInterface *
Pablo::MainInterface() {
	return globalMainInterface;
}

inline StructureDictionary *
Pablo::StructureDict() {
	return globalStructureDict;
}

inline TagMappingDictionary *
Pablo::TagMappingDict() {
	return globalTagMappingDict;
}

inline WidgetBase *
Pablo::TopLevel() {
	return globalTopLevel;
}

inline GeneralDialogBox *
Pablo::GeneralDialog() {
	return globalGeneralDialog;
}

inline TranscriptWindow * 
Pablo::Transcript() {
	return globalTranscriptWindow;
}

inline PabloHelpSystem * 
Pablo::HelpSystem() {
	return globalHelpSystem;
}

#endif Pablo_h

