/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ParallelCoordsFU.h: Parallel coordinate graphical display
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ParallelCoordsFU.h,v 1.5 1994/03/15 16:25:50 aydt Exp $
 */

#ifndef ParallelCoordsFU_h
#define ParallelCoordsFU_h

#include "Callback.h"
#include "EventHandler.h"
#include "Value.h"
#include "MultivariateFunctionalUnit.h"

class ParallelCoordsFormWrapper;
class InputPort;
class WidgetBase;
class EventHandler;

typedef struct {
      Widget dialog;
      int    numParams;
      Widget *scrolledLists, *editAreas;
} PCConfigPerDimDataStruct;

typedef struct {
      Widget dialog;
      Widget totalDimension;
      Widget datasetName;
      Widget inputOptionRadioBox;
      Widget perCategoryToggle;
} PCConfigDataStruct;

typedef enum { PC_TAG_PREPROCESSING, PC_TAG_CLUSTERING, PC_TAG_PREFERENCES } 
   PCInteractionTags;

typedef struct {
      int    numberOptions;
      Widget *toggleOptions;
} PCPreprocessOptions;

typedef struct {
      Widget numberOfClustersWidget;
      int numberOfClusters;
      Widget writeClusterRepsWidget;
      Boolean writeClusterReps;
} PCClusteringOptions;

typedef struct {
      int numberOptions;
      Widget *toggleOptions;
} PCPreferenceOptions;

typedef struct {
      PCInteractionTags  tag;
      Widget             mainWindow;
      void               *specificData;
} PCInteractionOptions;



class ParallelCoordsFU : public MultivariateFunctionalUnit,
                         public virtual Callback,
			 public virtual EventHandler {
/*
 * A ParallelCoordinates FU is a functional unit that implements a 
 * parallel coordinate display
*/
enum PCportTypes {FULL_ARRAY, ARRAY_ELEMENT} ;

private:
       static const char *const MY_CLASS;       // My class name
       Boolean_          isConfigured;          // Has configure()
       
       int               widgetMinValue, widgetRange;

       ParallelCoordsFormWrapper *parallelCoordsForm;
       InputPort                 *inputPort;
       Value                     inputValue;    // Cells for incoming data

       int               portOption;

protected:
       /* Method _setupPCConfigWindow: Build the set of widgets associated
	                                with the PC config window */
       Widget _setupPCConfigWindow();
       
       /* Method _setupPCPerCategoryDialog: Build the set of widgets
	      associated with the PC config window */
       Widget _setupPCPerCategoryDialog( int dimension );

public:
       /* Method ParallelCoordsFU:   The ParallelCoordsFU constructor */
       ParallelCoordsFU();

       /* Method ~ParallelCoordsFU:  The ParallelCoordsFU destructor */
       ~ParallelCoordsFU();

       /* Method callback1:          Done-with-config-window callback */
       virtual void callback1(Widget, XtPointer, XtPointer );

       /* Method callback2:          End-of-run callback */
       virtual void callback2(Widget, XtPointer, XtPointer );

       /* Method configure:          Configure the functional unit */
       virtual void configure();

       /* Method copy:               Create a copy of the FU */
       virtual FunctionalUnit * copy();

       /* Method fuCallback2:       Register PC preprocessing options */
       virtual void fuCallback2( PCPreprocessOptions *data );

       /* Method init:               Initialize the display */
       virtual void init();

       /* Method loadConfigFromFile:  Load configuration from a file */
       virtual Boolean_ loadConfigFromFile( const CString & fileName );
       
       /* Method ready:              Returns TRUE_ if the display is
	                             currently executable */
       virtual Boolean_ ready();

       /* Method run:                Execute the display */
       virtual void run( Boolean_& errorFlag );

       /* Method saveConfigToFile:   Save configuration to a file */
       virtual Boolean_ saveConfigToFile( const CString& fileName ) const;
};

#endif ParallelCoordsFU_h
