/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Contributing Author: Keith A. Shields (shields@cs.uiuc.edu)
 *                      Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ProfileFU.h: A functional unit to compute simple profiles from
 *		a sequence of event records.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ProfileFU.h,v 1.7 1994/03/15 16:26:01 aydt Exp $
 */

#ifndef ProfileFU_h
#define ProfileFU_h

#include <X11/Intrinsic.h>

#include "DisplayFunctionalUnit.h"
#include "CStringObjList.h"

class InputPort;
class OutputPort;

class WidgetBase;
class FormWidget;
class FrameWidget;
class LabelWidget;
class PiechartFormWrapper;
class TextWidget;

class ProfileFU : public DisplayFunctionalUnit {
/*
* ProfileFU is a functional unit that computes a profile (both counts and
* time) from a sequence of inputs that include event elapsed times.
* Configuration options include output of profile data for all processoors
* or only for a specific subset.
*/

private:
	static const char *const MY_CLASS;	// My class name

	CStringObjList	 OutputOptionList;
	CStringObjList	 PEOptionList;

	int		 outputOption;
	int		 ProcessorOption;
	int		 displayFrequency;

	enum profileHistoryTypes { ALL_PEs 	= 0,
				   ONE_PE  	= 1,
				   SELECTED_PEs	= 2 };

	enum profileOutputOptions { DISPLAY	= 0,
				    OUTPUT	= 1 };

	struct profileStruct {
	   int 		count;
	   double	totalTime;
           double       countPercent;
           double       timePercent;
	   int		EID;
	} ;

	struct summaryStruct {
	   int		EIDCount;
	   int		count;
	   double	totalTime;
	} ;

	struct PEInfoStruct {
	   Boolean_      encounteredYet;
	   summaryStruct PESummaryInfo;
	   profileStruct *eventInfoList;
	} ;

	PEInfoStruct   *PEInfoList;
	int            PEInfoListSize;

	int		NumPEsToDisplay;
	int             *PEsToDisplay;

	int             MaxPESeenSoFar;

	Boolean_	isConfigured;

	int		outputCount;

	InputPort	*eventID;
	InputPort	*PENumber;
	InputPort	*elapsedTime;
	InputPort	*currentTime;

	OutputPort	*outEventIDs;
	OutputPort	*outPENumber;
	OutputPort	*outCurrentTime;
	OutputPort	*callCount;
	OutputPort	*percentCount;
	OutputPort	*totalTime;
	OutputPort	*percentTime;

	WidgetBase 	*dialog;
	WidgetBase	*scrollBox;
	WidgetBase	*rowColumn;

	LabelWidget*	*profileLabel;
	TextWidget*	*profileText;
	FormWidget*	*profileForm;
	FrameWidget*    *profileFrame;

	PiechartFormWrapper* *pieCountForm;
	PiechartFormWrapper* *pieTimeForm;

	int	textCnt;
	int	headerSize;
	char	headerString[1024];

	/* Method _createDialog:	make the main dialog used to hold all 
	                                other widgets                      */
	void _createDialog();

	/* Method _displayPE:		 Determine if this processor is a
	*				 member of the data output set and
	*			         if profile data should be output    */
	Boolean_ _displayPE( const int PE );

	/* Method _eventLookup: 	 Determine if the event has occurred
	*				 on this processor before.  If so
	*				 return the index of the location.   */
	int _eventLookup( const int PE, const int EID );

	/* Method _expandPEList:	 Grow the list of PEs to accomodate
	                                 the largest PE seen so far          */
	void _expandPEList( const int PE );

	/* Method _lookupDisplayIdx:	 find the index into the 
	                                 displayable PEs for the
					 given PE                          */
	int _lookupDisplayIdx( const int PE );

	/* Method _processEvent:	 update internal structures to be
	                                 consistent with the fact that this 
					 EID has been encountered on this PE */
	void _processEvent( const int PE, const int EID );

	/* Method _processPE:		 update internal structures to be 
	                                 consistent with the fact that this
					 PE has been encountered            */
	void _processPE( const int PE );

	/* Method _updateDisplay:	Update the contents of the profile
	*				display for the specified processor  */
	void _updateDisplay( const int PE );

public:
	/* Method ProfileFU:  The ProfileFU constructor   		     */
	ProfileFU();

	/* Method ~ProfileFU: The ProfileFU destructor    		     */
	~ProfileFU();

        /* Method configure:    	 Configure the functional unit 	     */
        virtual void configure();

	/* Method configureDisplay:	Configure the graphical display
	*				for the profile functional unit	     */
	void configureDisplay();

	/* Method configureOperation:	 Configure the operation and ports 
	*				 for the profile functional unit     */
	virtual void configureOperation();

	/* Method copy:			 Copy this functional unit	     */
	FunctionalUnit * copy();

        /* Method fuCallback:		Callback handler for the FU          */
        virtual void fuCallback( Widget callbackWidget,
				 int pieSelected, float piePercentage );

	/* Method init:			 Initialize the functional unit	     */
	void init();

	/* Method inputTraitsValid:      Sets traits of output port. Here
	*				 input bindings are always valid 
	*				 so we always return TRUE_.	     */
	Boolean_ inputTraitsValid();

        /* Method loadConfigFromFile:    Load configuration from a file      */
        virtual Boolean_ loadConfigFromFile( const CString & fileName );

	/* Method ready: 		 Returns TRUE_ if the functional unit
	*				 is currently executable	     */
	Boolean_ ready();

	/* Method run:			 Execute the functional unit to fill 
	*				 in a cell in the array.	     */
	void run( Boolean_& errorFlag );

       /* Method saveConfigToFile:       Save configuration to a file        */
        virtual Boolean_ saveConfigToFile( const CString & fileName ) const;
};

#endif ProfileFU_h

