/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * RunDialog.h: Implements a run panel control dialog for graph execution
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/RunDialog.h,v 1.8 1994/02/25 04:29:08 aydt Exp $
 */

#ifndef RunDialog_h
#define RunDialog_h

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>

#include "CString.h"
#include "Pablo.h"
#include "Obj.h"
#include "WidgetBase.h"
#include "SnapshotDialog.h"


class RunDialog : public Obj {
/*
 *	The RunDialog allows the user to interactively control the
 *	execution of a Pablo analysis graph in single step, continuous,
 *	or module-by-module modes.  Only one RunDialog instance should
 *      be created for a Pablo session.
 */

private:
	static const char *const MY_CLASS;		// Our class name

	static PabloMainInterface *pabloMainInterface;  // created by object

	Boolean_ isManaged;

	struct radio_cbInfo {
		RunDialog *dp;
		int	  button;
	} ;

   	radio_cbInfo cbinfo;            // Struct for callback info
	radio_cbInfo cbinfoModule;
	radio_cbInfo cbinfoGraph;
	radio_cbInfo cbinfoOnce;
	radio_cbInfo cbinfoTime;
	radio_cbInfo cbinfoEvents;

	Boolean_	runGraph;
	Boolean_	runModule;
	Boolean_	runOnce;
	Boolean_	displayEvents;
	Boolean_	displayTime;

        Widget  runDialog;
        Widget  dialogPane;
        Widget  actionArea;
        Widget  executeForm;
        Widget  updateForm;

        Widget  dismissButton;
        Widget  checkpointButton;
        Widget  snapshotButton;
	Widget  runButton;
        Widget  stopButton;
        Widget  helpButton;

        Widget  runBox;
        Widget  radioFrame;
        Widget  radioBox;
        Widget  runLabel;
        Widget  moduleButton;
        Widget  graphButton;
        Widget  onceButton;

        Widget  stepBox;
        Widget  stepLabel;
        Widget  stepText;

        Widget  displayBox;
        Widget  updateBox;
        Widget  updateLabel;
        Widget  updateRadioFrame;
        Widget  updateRadioBox;
        Widget  eventsButton;
        Widget  timeButton;

        Widget  eventBox;
        Widget  eventLabel;
        Widget  minEventLabel;
        Widget  maxEventLabel;
        Widget  eventFraction;

        Widget  timeLabel;
        Widget  timeBox;
        Widget  minTimeLabel;
        Widget  timeFraction;
        Widget  maxTimeLabel;

        CString  fileName;
	SnapshotDialog   snapshotDialog;


        /* Method _checkpointCallback:   callback for the Checkpoint button   */
        void _checkpointCallback();

        /* Method _dismissCallback:      Callback routine for the Dismiss 
	*				 button.  This unmanages the dialog
	*				 and calls reenables the pulldown Run 
	*				 Menu.                                */
        void _dismissCallback();

        /* Method _displayCallback:      callback for the display buttons     */
        void _displayCallback( Widget w, radio_cbInfo *cbi,
                            XmToggleButtonCallbackStruct *cbs );

        /* Method _executeCallback:      callback for the execute buttons     */
        void _executeCallback( Widget w, radio_cbInfo *cbi,
                            XmToggleButtonCallbackStruct *cbs );

        /* Method _helpCallback:         callback for the Help button         */
        void _helpCallback( char* topic );

        /* Method _runCallback:          callback for the Run button          */
        void _runCallback();

        /* Method _scaleCallback:        callback for  display update rate    */
        void _scaleCallback( Widget w, radio_cbInfo *cbi,
                                        XmAnyCallbackStruct *cbs );

	/* Method _snapshotCallback:    callback for snapshot activation    */
	void _snapshotCallback();

       /* Method _staticHelpCallback:          static invocation for the
        *                                       Help callback button          */
        static void _staticHelpCallback( Widget w,
                                 XtPointer clientData,
                                 XtPointer callData );

        /* Method _staticCheckpointCallback:    static invocation for the
        *                                       Checkpoint callback button    */
        static void _staticCheckpointCallback( Widget w,
                                       XtPointer clientData,
                                       XtPointer callData );

        /* Method _staticDismissCallback:       static invocation for the
        *                                       Dismiss callback button       */
        static void _staticDismissCallback( Widget w,
                                    XtPointer clientData,
                                    XtPointer callData );

        /* Method _staticDisplayCallback:  This is a static method that
        *                               handles all the callbacks for
        *                               the display panel radio buttons       */
        static void _staticDisplayCallback( Widget widget, radio_cbInfo *cbi,
                                         XmToggleButtonCallbackStruct *cbs );

        /* Method _staticExecuteCallback:  This is a static method that
        *                               handles all the callbacks for
        *                               the execute panel radio buttons       */
        static void _staticExecuteCallback( Widget widget, radio_cbInfo *cbi,
                                     XmToggleButtonCallbackStruct *cbs );

        /* Method _staticRunCallback:           static invocation for the
        *                                       Run callback button           */
        static void _staticRunCallback( Widget w,
                                XtPointer clientData,
                                XtPointer callData );

        /* Method _staticScaleCallback:      static display update callback   */
        static void _staticScaleCallback( Widget w, radio_cbInfo *cbi,
                                            XmAnyCallbackStruct *cbs );

	/* Method _staticSnapshotCallback: static snapshot activate callback */
	static void _staticSnapshotCallback( Widget w, 
		 		     XtPointer clientData, XtPointer callData);

	/* Method _staticStepTextCallback:	static run step size callback */ 
	static void _staticStepTextCallback( Widget w, radio_cbInfo *cbi,
                                            XmAnyCallbackStruct *cbs );

	/* Method _staticStopCallback:		static invocation for the
	*					Stop callback button	      */
	static void _staticStopCallback( Widget w,
				 XtPointer clientData,
				 XtPointer callData );

        /* Method _stepTextCallback:     callback for run step size           */
        void _stepTextCallback( Widget w, radio_cbInfo *cbi,
                                        XmAnyCallbackStruct *cbs );

        /* Method _stopCallback:         callback for the Stop button         */
        void _stopCallback();

protected:
        SnapshotMode snapshotMode;

public:
	/* Method RunDialog:		The constructor	      		     */
	RunDialog( PabloMainInterface *createdBy );

	/* Method ~RunDialog:		The destructor		      	     */
	~RunDialog();

	/* Method isCameraOn:           Returns true if the snapshot camera
	                                is 'on'                              */
	Boolean_ isCameraOn();

	/* Method raiseDialog:		Activates the dialog by managing it. */
	void raiseDialog();

	/* Method takeSnapshot:      takes a snapshot of a given widget   */
	void takeSnapshot( Widget subjectWidget, const char *fuClass,
			   const char *fuName );

	/* Method updateDefaults:	updates the dialog using the
	*				global default values		     */
        void updateDefaults();

	/* Method updateByEvents:	returns the number of events between
	*				allowed display updates		     */
	Boolean_ updateByEvents() const; 


};

inline Boolean_
RunDialog::updateByEvents() const
{
        return( displayEvents );
}

#endif RunDialog_h
