/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (olson@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Scatter3DFU.h: A dynamic 3D scatter plot functional unit
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/Scatter3DFU.h,v 1.13 1994/03/15 16:26:08 aydt Exp $
 */

#ifndef Scatter3DFU_h
#define Scatter3DFU_h

#include "DisplayFunctionalUnit.h"

class InputPort;
class Scatter3DWrapper;
class WidgetBase;

class Scatter3DFU : public DisplayFunctionalUnit {
/*
 * A Scatter3DFU is a functional unit that implements a dynamic 3D
 * scatter plot
 */

private:
	static const char *const MY_CLASS;

	Boolean_  isConfigured;	     // Indicates if configuration has been run

	int	  autoScale;	     // Automatically scale widget?
	int	  markerSize;	     // Widget marker size
	double	  minX;		     // Minimum X data value we expect
	double	  maxX;		     // Maximum X data value we expect
	double	  minY;		     // Minimum Y data value we expect
	double	  maxY;		     // Maximum Y data value we expect
	double	  minZ;		     // Minimum Z data value we expect
	double	  maxZ;		     // Maximum Z data value we expect
	int	  xRange;	     // Range of X values accepted by widget
	int	  yRange;	     // Range of Y values accepted by widget
	int	  zRange;	     // Range of Z values accepted by widget
	int	  xOffset;	     // Lowest X value accepted by widget
	int	  yOffset;	     // Lowest Y value accepted by widget
 	int       zOffset;           // Lowest Z value accepted by widget

	InputPort		*input;
	WidgetBase      	*dialog;
	Scatter3DWrapper  	*scatter3d;

public:
	/* Method Scatter3DFU: 		The Scatter3DFU constructor	      */
	Scatter3DFU();

	/* Method ~Scatter3DFU:		The Scatter3DFU destructor 	      */
	~Scatter3DFU();

	/* Method configure:    	Configure the functional unit	      */
	virtual void configure();

	/* Method copy:			Copy the functional unit  	      */
	virtual FunctionalUnit * copy();

	/* Method init:			Initialize the scatter plot display   */
	virtual void init();

	/* Method loadConfigFromFile:  	Load configuration from a file        */
	virtual Boolean_ loadConfigFromFile( const CString& fileName );

	/* Method ready: 		Returns TRUE_ if the scatter plot 
	*				display is currently executable	      */
	virtual Boolean_ ready();

	/* Method run:			Execute the scatter plot display      */
	virtual void run( Boolean_& errorFlag );

        /* Method saveConfigToFile:    	Save configuration to a file   	      */
        virtual Boolean_ saveConfigToFile( const CString& fileName ) const;
};

#endif Scatter3DFU_h
