/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613 DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ShapedLabel.h: Implements a shaped label for analysis graphs
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ShapedLabel.h,v 1.11 1994/02/25 04:29:13 aydt Exp $
 *	
 */


#ifndef ShapedLabel_h
#define ShapedLabel_h

#include "WidgetBase.h"

class ShapedLabel : public WidgetBase {
/*
* ShapedLabel displays a label in an ellipsoid or rectangle.  It is
* used to display the names of functional units on the analysis graph.
*/
protected:
	Boolean_ graphicsInitialized;

	/* Method initializeGraphics:	Initializes the graphics for
	*				a shaped label			*/
	virtual void initializeGraphics();
	
	Position offsetX, offsetY;

	Boolean_ highlightFlag;

	Pixmap mask;
	GC gc;
	XGCValues xgcv;

	/* Method getMask:		Returns the mask for the label	*/
	Pixmap getMask();

	/* Method getGC:		Returns the graphical context
	*				(GC) for the label		*/
	GC getGC();

	/* Method setShape:		Sets the label shape		*/
	void setShape();

	/* Method getWindow:		Returns the X window associated
	*				with this widget		*/
	Window getWindow() { return XtWindow(getWidget()); } ;

	/* Method setupShape:		Shape initialization		*/
	virtual void setupShape() = 0;

	/* Method highlightOn:		Enables lable highlighting	*/
	virtual void highlightOn() { highlightFlag = TRUE_; } ;

	/* Method highlightOff:		Disables label highlighting	*/
	virtual void highlightOff() { highlightFlag = FALSE_; } ;

public:
        /* Method ShapedLabel: The ShapedLabel constructor. */
        /* Method ~ShapedLabel: The ShapedLabel destructor. */
	ShapedLabel(WidgetBase *par);
	~ShapedLabel();

	/* Method isHighlighted:	Returns the current highlight
	*				stage				*/
	virtual Boolean_ isHighlighted() { return highlightFlag; } ;

	/* Method highlight:		Enables highlighting		*/
	void highlight(Boolean_ flag = TRUE_);

	/* Method unhighlight:		Disables hightlighting		*/
	void unhighlight() { highlight(FALSE_); } ;

	/* Method printOn: Stream output function */
	void printOn(ostream &os = cout) const ;
};

inline ostream &operator<<(ostream &os, ShapedLabel &obj)
{
	obj.printOn(os);
	return os;
}

#endif
