/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt.cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * TagMappingDictionary.h: Class used to keep track of the mappings from
 *			   (source Id, sourceTag) to systemTag.  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/TagMappingDictionary.h,v 1.15 1994/02/25 04:28:35 aydt Exp $
 */

#ifndef TagMappingDictionary_h
#define TagMappingDictionary_h

#include "CString.h"
#include "Defines.h"
#include "Obj.h"

class TagMappingDictionary : public Obj {
/*
*
* There is a single instance of the TagMappingDictionary class in the system. It
* is used to keep track of the mappings from (sourceId, sourceTag) to systemTag.
* Multiple (sourceId, sourceTag) pairs may map to the same systemTag.  The
* systemTag is the tag kept in the Structure Dictionary and the Record Dossier.
*
*/
	friend class TagMappingDictionaryInquirer;

	class TagMappingDictEntry {
	    friend class TagMappingDictionary;
	    friend class TagMappingDictionaryInquirer;

	private:
	    int			     sourceId;
	    int			     sourceTag;
	    int			     systemTag;
	    TagMappingDictEntry      *nextEntry;

	    TagMappingDictEntry() { nextEntry = NULL; }
	} ;

private:
	static const char *const     MY_CLASS;		// My class name
	TagMappingDictEntry	     *headEntry;
	TagMappingDictEntry	     *tailEntry;


public:
	/* Method TagMappingDictionary:  Constructor with no initialization.  */
	TagMappingDictionary();

	/* Method ~TagMappingDictionary: Destructor.		              */
	~TagMappingDictionary();

	/* Method clearAllEntries:	 Clear all entries in the dictionary. */
	void clearAllEntries();

	/* Method clearSrcEntries:	 Clear all entries for given source.  */
	void clearSrcEntries( int srcId );

	/* Method fetch:	         Lookup the (srcId/srcTag) pair
	*  				 and return the corresponding systemTag
	*				 or FAILURE_ if none exists           */
	int fetch( const int srcId, const int srcTag ) const;
	
	/* Method insert:		Insert an entry for the mapping from 
	 *				the (srcId/srcTag) pair to the 
	 *				systemTag.  Returns FAILURE if this
	 *				is a duplicate sourceid/sourcetag.    */
	Boolean_ insert( const int srcId, const int srcTag, const int sysTag );

	/* Method loadFromFile:		Load entries into the dictionary from
	*				the specified file.		      */
	Boolean_ loadFromFile( const CString& filename );

	/* Method saveToFile:		Save the entries in the dictionary in
	*				the specified file.		      */
	Boolean_ saveToFile( const CString& filename ) const;

	/* Method printOn: 		Helper function for TagMappingDictionary
	*				output. 			      */
	virtual void printOn( ostream& strm = cout ) const;

};

inline ostream& operator<<( ostream& os, TagMappingDictionary& tagMappingDict )
{
	tagMappingDict.printOn (os);

	return os;
}

#endif TagMappingDictionary_h
