/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Authors: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *                       Keith A. Shields (shields@cs.uiuc.edu)
 *                       Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * XYGraphFU.h: A dynamic line plot functional unit
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/XYGraphFU.h,v 1.21 1994/03/15 16:26:31 aydt Exp $
 */

#ifndef XYGraphFU_h
#define XYGraphFU_h

#include "CStringObjList.h"
#include "DisplayFunctionalUnit.h"
#include "Value.h"

class XYGraphFormWrapper;
class InputPort;
class WidgetBase;

class XYGraphFU : public DisplayFunctionalUnit {
/*
 * A XYGraphFU is a functional unit that implements a dynamic line plot
 */

private:
	static const char *const MY_CLASS;
	static CStringObjList	 ConnectOptionList;

	double	  minX;		     // Minimum X data value we expect
	double	  maxX;		     // Maximum X data value we expect
	double	  minY;		     // Minimum Y data value we expect
	double	  maxY;		     // Maximum Y data value we expect
	int	  markerSize;	     // Size of point markers
        int       xticks;            // Frequency of X axis tick marks
        int       yticks;            // Frequency of Y axis tick marks
	int	  xRange;	     // Range of X values accepted by widget
	int	  yRange;	     // Range of Y values accepted by widget
	int	  xOffset;	     // Lowest X value accepted by widget
	int	  yOffset;	     // Lowest Y value accepted by widget
	int       numPairs;          // Number of XY pairs widget has received
        int       *currentxptr;      // Current pointer to x values
        int       *currentyptr;      // Current pointer to y values
        Value     inputValue;        // Data vals for the entire current array
	Boolean_  connect;	     // connect data points?

	InputPort	    *input;
	WidgetBase          *dialog;
	XYGraphFormWrapper  *xygraphForm;

	Boolean_  isConfigured;	   
	int	  connectOption;

public:
        /* Method XYGraphFU:            The XYGraphFU constructor       */
        XYGraphFU();

        /* Method ~XYGraphFU:           The XYGraphFU destructor        */
        ~XYGraphFU();

        /* Method configure:            Configure the functional unit   */
        virtual void configure();

        /* Method copy:                 Copy the functional unit        */
        virtual FunctionalUnit * copy();

        /* Method fuCallback: 		Callback from the widget	     */
        virtual void fuCallback( int nearestXValue, int nearestYValue, 
				 int index);

        /* Method init:                 Initialize the xygraph display        */
        virtual void init();

        /* Method loadConfigFromFile:   Loads configuration from a file       */
        virtual Boolean_ loadConfigFromFile( const CString& fileName );

        /* Method ready:                Returns TRUE_ if the xygraph
        *                               display is currently executable */
        virtual Boolean_ ready();

        /* Method run:                  Execute the xygraph display   */
        virtual void run( Boolean_& errorFlag );

        /* Method saveConfigToFile:     Saves configuration to a file   */
        virtual Boolean_ saveConfigToFile( const CString& fileName ) const;

};

#endif XYGraphFU_h
