/* 
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ConfigBoardDetail.cc:   This module implements a detail-information window
 *            accessible frm the configuration binding interface "scoreboard"
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/ConfigBoardDetail.C,v 1.10 1994/03/01 00:14:30 aydt Exp $
 *	
 */

#include <Xm/Label.h>

#include "ConfigBoardDetail.h"

#include "Callback.h"
#include "CString.h"
#include "InterfaceClass.h"
#include "IntList.h"
#include "Pablo.h"
#include "PabloHelpSystem.h"
#include "VoidPtrList.h"



ConfigBoardDetail::ConfigBoardDetail( Widget boardMainWindow,
				      InterfaceClass *interfaceClassIn )
{
	numberInputPipes = 0;
	numberInputPorts = 0;
	numberOutputFields = 0;

        detailShell = XtVaCreatePopupShell("configBoardDetailShell",
					    topLevelShellWidgetClass,
					    boardMainWindow,
					       NULL );

	Widget detailMainWindow = XtVaCreateManagedWidget(
					    "configBoardDetailForm",
					     xmFormWidgetClass,
					     detailShell,
						NULL);
	Widget detailHeaderAttachment = _setupDetailHeader( detailMainWindow);

	Widget detailSeparator1 = XtVaCreateManagedWidget(
					 "configBoardDetailSeparator1",
					 xmSeparatorWidgetClass,
					 detailMainWindow,
					 XmNtopAttachment, XmATTACH_WIDGET,
					 XmNtopWidget, detailHeaderAttachment,
					    NULL );
	
	Widget detailLineInformationAttachment =
            _setupDetailLineInformation( detailMainWindow, detailSeparator1 );

	Widget detailSeparator2 = XtVaCreateManagedWidget(
				"configBoardDetailSeparator2",
				xmSeparatorWidgetClass,
				detailMainWindow,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, detailLineInformationAttachment,
				   NULL );

	Widget detailScrolledListAttachment =
              _setupDetailScrolledLists( detailMainWindow, detailSeparator2 );
	Widget detailSeparator3 = XtVaCreateManagedWidget(
            		        "configBoardDetailSeparator3",
				xmSeparatorWidgetClass,
				detailMainWindow,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNtopWidget, detailScrolledListAttachment,
				   NULL );
							
	_setupDetailControlArea( detailMainWindow, detailSeparator3 );

	boundRecordsForInputPort = new VoidPtrList( 1 );
	boundFieldsForInputPort = new VoidPtrList( 1 );
	boundRecordsForOutputField = new VoidPtrList( 1 );
	boundFieldsForOutputField = new VoidPtrList( 1 );

	recordBrowseState = FE_NOT;
	interfaceClass = interfaceClassIn;
}



ConfigBoardDetail::~ConfigBoardDetail()
{
        int i;
	for (i=0; i<boundRecordsForInputPort->count(); i++) {
            delete (VoidPtrList *)boundRecordsForInputPort->getElement(i);
	    delete (VoidPtrList *)boundFieldsForInputPort->getElement(i);
	}
	delete boundRecordsForInputPort;
	delete boundFieldsForInputPort;

	for (i=0; i<boundRecordsForOutputField->count(); i++) {
            delete (VoidPtrList *)boundRecordsForOutputField->getElement(i);
	    delete (VoidPtrList *)boundFieldsForOutputField->getElement(i);
	}
	delete boundRecordsForOutputField;
	delete boundFieldsForOutputField;

        XtUnrealizeWidget( detailShell );
	XtDestroyWidget( detailShell );
}



Widget ConfigBoardDetail::_createListArea( Widget scrolledListParent,
					   Widget scrolledListAttachment,
					   Widget& scrolledList,
					   CString widgetNamePrefix )
{
        Arg arglist[3];
	int i = 0;
	if (scrolledListAttachment != NULL) {
           XtSetArg( arglist[i], XmNleftAttachment, XmATTACH_WIDGET ); i++;
	   XtSetArg( arglist[i], XmNleftWidget, scrolledListAttachment ); i++;
	}
        CString currentWidgetName;
        currentWidgetName = widgetNamePrefix + "Container";
        Widget scrolledListContainer = XtCreateManagedWidget(
					       currentWidgetName,
					       xmFormWidgetClass,
					       scrolledListParent,
					       arglist, i );

	currentWidgetName = widgetNamePrefix + "Label";
	Widget scrolledListLabel = XtVaCreateManagedWidget(
					       currentWidgetName,
					       xmLabelWidgetClass,
		     			       scrolledListContainer,
				 	          NULL );

	currentWidgetName = widgetNamePrefix + "List"; 
	XtSetArg( arglist[0], XmNtopAttachment, XmATTACH_WIDGET );
        XtSetArg( arglist[1], XmNtopWidget, scrolledListLabel );
	scrolledList = XmCreateScrolledList( scrolledListContainer,
				           (char *)currentWidgetName.getValue(),
					   arglist, 2 );
	addCallback( scrolledList, XmNbrowseSelectionCallback,
		     &Callback::callback1, this, NULL );
	XtManageChild( scrolledList );
	return( scrolledListContainer );
}


void ConfigBoardDetail::_fillFieldScrollBasedOnPipeOnly( int recordIndex )
{
        CString currentFieldName;
        int i;
        for (i=0; i<interfaceClass->getNumberFieldsInInputPipeRecord(
		       currentlySelectedPipe, recordIndex-1 ); i++) {
               
	    currentFieldName =
                        interfaceClass->getNameOfFieldInInputPipeRecord(
                           currentlySelectedPipe, recordIndex-1, i);
	    XmString fieldNameString = XmStringCreateSimple( 
					 (char *)currentFieldName.getValue() );
            XmListAddItemUnselected( detailScrolledList2, 
			                    fieldNameString, i+1 );
	    XmStringFree( fieldNameString );
	}
}



void ConfigBoardDetail::_fillRecordScrollBasedOnPipeOnly( int pipeNumber )
{
	char *currentRecordName;
	int j;
        for (j=0; j<interfaceClass->getNumberRecordsOnInputPipe(pipeNumber);
	     j++) {
	     if ( ((pipeNumber+1) != numberInputPipes) && (pipeNumber >= 0) ){
                currentRecordName = (char *)
                  interfaceClass->getNameOfRecordOnInputPipe(pipeNumber, j);
	        XmString currentRecordNameString = XmStringCreateSimple(
							 currentRecordName);
	        XmListAddItemUnselected( detailScrolledList1, 
			                 currentRecordNameString,
			                 j+1 );
	        XmStringFree(currentRecordNameString);
	     }
	}
	currentlySelectedPipe = pipeNumber;
}             


void ConfigBoardDetail::_fillScrolledListWithEntry( Widget scrolledList,
						    char *string,
						    int index )
{
	XmString currentRecordString = XmStringCreateSimple( string );
	XmListAddItemUnselected( scrolledList, currentRecordString, index );
        XmStringFree( currentRecordString );
}


void ConfigBoardDetail::_fillScrolledListWithEntryList( Widget scrolledList,
						   VoidPtrList *stringList )
{
        int i;
	for (i=0; i<stringList->count(); i++) {
	    char *currentString = (char *)stringList->getElement(i);
            _fillScrolledListWithEntry( scrolledList, currentString, i+1 );
	}
}


int 
ConfigBoardDetail::_isADuplicatePipePortRecordExtract( int portNumber,
				                       const char *recordName )
{
       VoidPtrList *boundRecordsForThisPort =
          (VoidPtrList *)boundRecordsForInputPort->getElement( portNumber );    
       int i;
       for (i=0; i<boundRecordsForThisPort->count(); i++) {
           if (strcmp( (const char *)boundRecordsForThisPort->getElement(i),
		       recordName )==0) {
              return(i);
	   }
       }
       return(0);
}



void ConfigBoardDetail::_setupDetailControlArea( Widget detailMainWindow,
						 Widget topAttachmentWidget )
{
	Widget controlForm = XtVaCreateManagedWidget(
					 "configBoardDetailControlArea",
					  xmFormWidgetClass,
					  detailMainWindow,
					  XmNtopAttachment, XmATTACH_WIDGET,
					  XmNtopWidget, topAttachmentWidget,
					     NULL );
	Widget controlDismissButton = XtVaCreateManagedWidget(
					 "configBoardDetailDismissButton",
					 xmPushButtonWidgetClass,
					 controlForm,
					    NULL );
	addCallback( controlDismissButton, XmNactivateCallback,
		     &Callback::callback2, this, NULL );
 
	Widget controlHelpButton = XtVaCreateManagedWidget(
					 "configBoardDetailHelpButton",
					 xmPushButtonWidgetClass,
					 controlForm,
					    NULL );
	addCallback( controlHelpButton, XmNactivateCallback,
		     &Callback::helpCallback, this, NULL );
}



Widget ConfigBoardDetail::_setupDetailHeader( Widget detailMainWindow )
					     
{
	detailDescriptor = XtVaCreateManagedWidget(
					       "configBoardDetailDescriptor",
					       xmLabelWidgetClass,
					       detailMainWindow,
						  NULL);
	return( detailDescriptor );
}



Widget ConfigBoardDetail::_setupDetailLineInformation(Widget detailMainWindow,
					          Widget topAttachmentWidget )
{
        Widget detailNameForm = XtVaCreateManagedWidget(
					    "configBoardDetailNameForm",
					    xmFormWidgetClass,
					    detailMainWindow,
					    XmNtopAttachment, XmATTACH_WIDGET,
					    XmNtopWidget, topAttachmentWidget,
						NULL );

	Widget detailNameLabel = XtVaCreateManagedWidget(
					    "configBoardDetailNameLabel",
					    xmLabelWidgetClass,
					    detailNameForm,
					    	NULL );
	detailNameText = XtVaCreateManagedWidget(
					    "configBoardDetailNameText",
					    xmLabelWidgetClass,
					    detailNameForm,
					    XmNleftAttachment, XmATTACH_WIDGET,
				            XmNleftWidget, detailNameLabel,
						NULL );

	Widget detailTypeForm = XtVaCreateManagedWidget(
				       "configBoardDetailTypeForm",
				       xmFormWidgetClass,
				       detailMainWindow,
				       XmNtopAttachment, XmATTACH_WIDGET,
				       XmNtopWidget, detailNameForm,
					   NULL );

	Widget detailTypeLabel = XtVaCreateManagedWidget(
				       "configBoardDetailTypeLabel",
				       xmLabelWidgetClass,
				       detailTypeForm,
				           NULL );

	Widget detailScrolledWindow = XtVaCreateManagedWidget(
					    "configBoardDetailScrolledWindow",
					    xmScrolledWindowWidgetClass,
					    detailTypeForm,
					    XmNleftAttachment, XmATTACH_WIDGET,
					    XmNleftWidget, detailTypeLabel,
						 NULL );
	detailTypeText = XtVaCreateManagedWidget(
					    "configBoardDetailTypeText",
					    xmLabelWidgetClass,
					    detailScrolledWindow,
					      NULL );

	return( detailTypeForm );
}


Widget ConfigBoardDetail::_setupDetailScrolledLists( Widget detailMainWindow,
						   Widget topAttachmentWidget )
{

	Widget detailScrolledListContainer = XtVaCreateManagedWidget(
				    "configBoardDetailScrolledListContainer",
				     xmFormWidgetClass,
				     detailMainWindow,
				     XmNtopAttachment, XmATTACH_WIDGET,
			             XmNtopWidget, topAttachmentWidget,
					 NULL );
	Widget nextListAttachment = _createListArea(
                                  detailScrolledListContainer, (Widget)NULL,
	                          detailScrolledList1, "configBoardDetailSL1");
	nextListAttachment = _createListArea( 
                               detailScrolledListContainer, nextListAttachment,
			       detailScrolledList2, "configBoardDetailSL2");
	return( detailScrolledListContainer );
}



void ConfigBoardDetail::callback1( Widget scrolledList,
				   XtPointer /* ptr1 */, 
				   XtPointer ptr2 )
{
	int recordIndex = XmListItemPos( scrolledList,
				       ((XmListCallbackStruct *)ptr2)->item );

        if (scrolledList == detailScrolledList1) {
            XmListDeleteAllItems( detailScrolledList2 );

	    if ( recordBrowseState == FE_NOT ) {
               _fillFieldScrollBasedOnPipeOnly( recordIndex );

            } else { 
	       CString currentFieldName;
               VoidPtrList *fieldsForThisRecord;
	       if (recordBrowseState == FE_INPUT_PORT) {
                  fieldsForThisRecord = (VoidPtrList *)
		     boundFieldsForInputPort->getElement(currentlySelectedPort);
		  
	       } else if (recordBrowseState == FE_OUTPUT_FIELD) {
                  fieldsForThisRecord = (VoidPtrList *)
                  boundFieldsForOutputField->getElement(currentlySelectedField);
	       }
	       _fillScrolledListWithEntry( detailScrolledList2,
		    (char *)fieldsForThisRecord->getElement(recordIndex-1), 0 );
	    }
	}
}



void ConfigBoardDetail::callback2( Widget /* callbackWidget */,
				   XtPointer /* ptr1 */, 
				   XtPointer /* ptr2 */ )
{
        XtPopdown( detailShell );
}



void ConfigBoardDetail::helpCallback( Widget /* callbackWidget */,
				      XtPointer /* ptr1 */, 
				      XtPointer /* ptr2 */ )
{
        Pablo::HelpSystem()->giveHelpOn( "ConfigBoardDetail" );
}



void ConfigBoardDetail::clearAllPipePortExtract( int portNumber )
{
        VoidPtrList *boundRecordsForThisPort =
            (VoidPtrList *)boundRecordsForInputPort->getElement( portNumber );
	VoidPtrList *boundFieldsForThisPort =
            (VoidPtrList *)boundFieldsForInputPort->getElement( portNumber );
	int i;
	for (i=0; i<boundRecordsForThisPort->count(); i++) {
             boundRecordsForThisPort->deleteElementAt(i);
	     boundFieldsForThisPort->deleteElementAt(i);
	}
}


void ConfigBoardDetail::clearAllPipeOutputExtract( int fieldNumber )
{
        VoidPtrList *boundRecordsForThisField =
           (VoidPtrList *)boundRecordsForOutputField->getElement( fieldNumber );
	VoidPtrList *boundFieldsForThisField =
           (VoidPtrList *)boundFieldsForOutputField->getElement( fieldNumber );
	int i;
	for (i=0; i<boundRecordsForThisField->count(); i++) {
               boundRecordsForThisField->deleteElementAt(i);
	       boundFieldsForThisField->deleteElementAt(i);
	}
}


void ConfigBoardDetail::clearRecordScrollArea()
{
        XmListDeleteAllItems( detailScrolledList1 );
	XmListDeleteAllItems( detailScrolledList2 );
}


void 
ConfigBoardDetail::clearSinglePipePortExtract( int portNumber,
					       const char *recordName )
{ 
        VoidPtrList *boundRecordsForThisPort =
             (VoidPtrList *)boundRecordsForInputPort->getElement( portNumber );
	VoidPtrList *boundFieldsForThisPort =
             (VoidPtrList *)boundFieldsForInputPort->getElement( portNumber );
	int i;

	for (i=0; boundRecordsForThisPort->count(); i++) {
	    if ( strcmp( (const char *)boundRecordsForThisPort->getElement(i),
			 recordName ) == 0 ) {
               boundRecordsForThisPort->deleteElementAt(i);
	       boundFieldsForThisPort->deleteElementAt(i);
	       break;
	    }
	}
}


void 
ConfigBoardDetail::clearSinglePipeOutputExtract( int fieldNumber,
					         const char *recordName )
{ 
        VoidPtrList *boundRecordsForThisField =
           (VoidPtrList *)boundRecordsForOutputField->getElement( fieldNumber );
	VoidPtrList *boundFieldsForThisField =
           (VoidPtrList *)boundFieldsForOutputField->getElement( fieldNumber );
	int i;
	for (i=0; boundRecordsForThisField->count(); i++) {
	    if ( strcmp( (const char *)boundRecordsForThisField->getElement(i),
			 recordName ) == 0 ) {
               boundRecordsForThisField->deleteElementAt(i);
	       boundFieldsForThisField->deleteElementAt(i);
	       break;
	    }
	}
}


void 
ConfigBoardDetail::fieldExtractPipePort( int portNumber,
			                 const char *recordName, 
					 const char *fieldName )
{
        Assert( portNumber >= 0 )
        VoidPtrList *boundRecordsForThisPort = 
	    (VoidPtrList *) boundRecordsForInputPort->getElement( portNumber );
        VoidPtrList *boundFieldsForThisPort =
	    (VoidPtrList *) boundFieldsForInputPort->getElement( portNumber );

	int existingIndex = _isADuplicatePipePortRecordExtract( portNumber, 
						                recordName );
					
        if ( existingIndex == 0 ) {
           boundRecordsForThisPort->addElement( (void *)recordName );
	   boundFieldsForThisPort->addElement( (void *)fieldName );
	} else {
           boundFieldsForThisPort->setElement( existingIndex, 
					       (void *)fieldName );
        } 
}



void 
ConfigBoardDetail::fieldExtractPipeField( int fieldNumber,
				          const char *recordName, 
				          const char *fieldName )
{
        VoidPtrList *boundRecordsForThisField = 
	  (VoidPtrList *) boundRecordsForOutputField->getElement( fieldNumber );
        VoidPtrList *boundFieldsForThisField =
	  (VoidPtrList *) boundFieldsForOutputField->getElement( fieldNumber );
        boundRecordsForThisField->addElement( (void *)recordName );
	boundFieldsForThisField->addElement( (void *)fieldName );
}



void ConfigBoardDetail::fillRecordScrollAreaFromPipe( int pipeNumber )
{
	clearRecordScrollArea();
	if ( ((pipeNumber+1) != numberInputPipes) && (pipeNumber >= 0) ) {
	   _fillRecordScrollBasedOnPipeOnly( pipeNumber );
	}
	recordBrowseState = FE_NOT;
}


void ConfigBoardDetail::fillRecordScrollAreaFromOutputField( int fieldNumber,
				  int inputPipeNumber, Boolean isExtracted )
{
        clearRecordScrollArea();

	if ( ! isExtracted ) {
           if ( ((inputPipeNumber+1) != numberInputPipes) &&
                 (inputPipeNumber >= 0) ) {
              _fillRecordScrollBasedOnPipeOnly( inputPipeNumber );
	   }
	   recordBrowseState = FE_NOT;

        } else {
	   VoidPtrList *boundRecordsForThisField =
             (VoidPtrList *)boundRecordsForOutputField->getElement(fieldNumber);
	   _fillScrolledListWithEntryList( detailScrolledList1,
					   boundRecordsForThisField );
	   recordBrowseState = FE_OUTPUT_FIELD;
	   currentlySelectedField = fieldNumber;
	}
}             



void ConfigBoardDetail::fillRecordScrollAreaFromPort( int portNumber,
				  int inputPipeNumber, Boolean isExtracted )
{
    	clearRecordScrollArea();

	if ( ! isExtracted ) {
	   if ( ((inputPipeNumber+1) != numberInputPipes) &&
                 (inputPipeNumber >= 0) ) {
	      _fillRecordScrollBasedOnPipeOnly( inputPipeNumber );
	   }
	   recordBrowseState = FE_NOT;

        } else {
	   VoidPtrList *boundRecordsForThisPort =
             (VoidPtrList *)boundRecordsForInputPort->getElement( portNumber );
	   _fillScrolledListWithEntryList( detailScrolledList1,
					   boundRecordsForThisPort );
           recordBrowseState = FE_INPUT_PORT;
	   currentlySelectedPort = portNumber;
	}
}             


void ConfigBoardDetail::realize()
{
        XtPopup( detailShell, XtGrabNone );
}



void ConfigBoardDetail::registerNumberInputPipes( int numberInputPipesIn )
{
        numberInputPipes = numberInputPipesIn;
}


void ConfigBoardDetail::registerOutputFieldAddition()
{
	boundRecordsForOutputField->addElement( new VoidPtrList( 1 ) );
        boundFieldsForOutputField->addElement( new VoidPtrList( 1 ) );
        numberOutputFields++;
}


void ConfigBoardDetail::registerOutputFieldDeletion( int fieldNumber )
{
        VoidPtrList *boundRecordsForThisField = (VoidPtrList *)
                boundRecordsForOutputField->getElement( fieldNumber );
        delete boundRecordsForThisField;
        boundRecordsForOutputField->deleteElementAt( fieldNumber );
	
	VoidPtrList *boundFieldsForThisField = (VoidPtrList *)
                boundFieldsForOutputField->getElement( fieldNumber );
	delete boundFieldsForThisField;
        boundFieldsForOutputField->deleteElementAt( fieldNumber );
	numberOutputFields--;
}


void ConfigBoardDetail::registerPort( int /* portNumber */ )
{
        VoidPtrList *newRecordList = new VoidPtrList( 1 );
        boundRecordsForInputPort->addElement( (void *)newRecordList );
	VoidPtrList *newFieldList = new VoidPtrList( 1 );
	boundFieldsForInputPort->addElement( (void *)newFieldList );
	numberInputPorts++;
}



void ConfigBoardDetail::resetDetails()
{
        if ( XtIsRealized(detailShell) ) {
           setDescriptor( "No Selection Active",
		           WhitePixel( XtDisplay(detailShell),
				   DefaultScreen( XtDisplay(detailShell) ) ) );
	   setName( "    " );
	   setType( "    " );
	   clearRecordScrollArea();
	}
}


		
void ConfigBoardDetail::setDescriptor( char *label, Pixel background  )
{
        XmString labelString = XmStringCreateSimple( label );
        XtVaSetValues( detailDescriptor,
		       XmNlabelString, labelString,
		       XmNbackground, background,
		          NULL );
	XmStringFree( labelString );
}


void ConfigBoardDetail::setName( const char *label )
{
        XmString labelString = XmStringCreateSimple( (char *)label ); 
        XtVaSetValues( detailNameText,
		       XmNlabelString, labelString,
		          NULL );
	XmStringFree( labelString );
}



void ConfigBoardDetail::setType( const char *label )
{
        XmString labelString = XmStringCreateLtoR( (char *)label,
						   XmSTRING_DEFAULT_CHARSET); 
        XtVaSetValues( detailTypeText,
		       XmNlabelString, labelString,
		          NULL );
	XmStringFree( labelString );
}



void ConfigBoardDetail::unrealize()
{
        XtPopdown( detailShell );
}

