/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * DefaultsDialog.C: Provides a dialog for modifying various Pablo defaults
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/DefaultsDialog.C,v 1.16 1994/03/28 20:29:47 aydt Exp $
 *	
 */
#include <dirent.h>
#include <stdlib.h>
#include <Xm/Label.h>

#include "DefaultsDialog.h"
#include "PabloHelpSystem.h"
#include "PabloMainInterface.h"
#include "SystemErrors.h"
#include "WidgetBase.h" 

DefaultsDialog::DefaultsDialog( PabloMainInterface *createdBy )
{
	_setClassName( MY_CLASS );

        if ( pabloMainInterface != NULL ) {
            abort( "Can't have more than one Run Panel instance.\n" );
        } else {
            pabloMainInterface = createdBy;
        }

	isManaged = FALSE_;

	XmString defaultMessage;
	Widget a_widget;

	defaultsDialog = XtCreatePopupShell( "defaultsDialog",
                 		topLevelShellWidgetClass,
				Pablo::TopLevel()->getWidget(),
				NULL, 0);

	XtVaSetValues( defaultsDialog,
		       XtNtitle, "Pablo Defaults Specification",
                       NULL );

	dialogPane = XtVaCreateWidget( "dialogPane",
			xmPanedWindowWidgetClass, defaultsDialog,
               	        XmNsashWidth, 1, XmNsashHeight, 1,
			NULL );

	controlArea = XtVaCreateWidget( "defaultsControlArea",
			xmFormWidgetClass, dialogPane,
			NULL );

     	actionArea = XtVaCreateWidget( "defaultsActionArea",
                        xmFormWidgetClass, dialogPane,
                        NULL );

	//  The action area contains three buttons, "Cancel", "OK",
	//  and "Help."  

        cancelButton = XtVaCreateManagedWidget( "Cancel",
                     xmPushButtonGadgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

   	okButton = XtVaCreateManagedWidget( "Ok", 
                     xmPushButtonGadgetClass, actionArea,
		     XmNdefaultButtonShadowThickness, 1,
                     NULL );

   	helpButton = XtVaCreateManagedWidget( "Help", 
                     xmPushButtonGadgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

	//  Create a RowColumn widget that contains a sequence of
	//  default values.  The default values for resources associated
	//  with graph execution are managed through the run panel dialog.
	//  Coordinating the changes is just too difficult to allow updates
	//  to all resources in multiple  places.

	defaultBox = XtVaCreateManagedWidget( "defaultBox",
			xmRowColumnWidgetClass, controlArea,
			XmNpacking, XmPACK_COLUMN,
			XmNorientation, XmHORIZONTAL,
			XmNnumColumns, 5,	// note!  change IF ADDING
						// OTHER DEFAULTS
			XmNisAligned,	TRUE_,
			XmNentryAlignment, XmALIGNMENT_END,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			NULL );

	// Graph configuration directory
        defaultMessage =  XmStringCreateLtoR( "Graph configuration directory:",
                        XmSTRING_DEFAULT_CHARSET );
        a_widget = XtVaCreateManagedWidget( "configLabel",
                        xmLabelWidgetClass, defaultBox,
        	        XmNlabelString, (XtArgVal) defaultMessage, 
                        NULL );
        configText = XtVaCreateManagedWidget( "configText",
                        xmTextFieldWidgetClass, defaultBox,
                        NULL );
        XmStringFree( defaultMessage );

	// Trace file directory
        defaultMessage =  XmStringCreateLtoR( "Trace file directory:",
                        XmSTRING_DEFAULT_CHARSET );
        a_widget = XtVaCreateManagedWidget( "dataLabel",
                        xmLabelWidgetClass, defaultBox,
        	        XmNlabelString, (XtArgVal) defaultMessage,
                        NULL );
        dataText = XtVaCreateManagedWidget( "dataText",
                        xmTextFieldWidgetClass, defaultBox,
                        NULL );
        XmStringFree( defaultMessage );

	// Execution Log file
        defaultMessage =  XmStringCreateLtoR( "Execution log file:",
                                XmSTRING_DEFAULT_CHARSET );
        a_widget = XtVaCreateManagedWidget( "logLabel",
                        xmLabelWidgetClass, defaultBox,
        		XmNlabelString, (XtArgVal) defaultMessage,
                        NULL );
        logText = XtVaCreateManagedWidget( "logText",
                        	xmTextFieldWidgetClass, defaultBox, NULL );
        XmStringFree( defaultMessage );

	// Show Bytes Procsses (toggle)
	a_widget = XtVaCreateManagedWidget( 
				"Show Bytes Processed for File Input Modules:",
				xmLabelWidgetClass, defaultBox, NULL );
        bytesProcessedButton = XtVaCreateManagedWidget( "",
                        	xmToggleButtonGadgetClass, defaultBox, NULL );

	// Verify before Delete Graph (toggle)
	a_widget = XtVaCreateManagedWidget( 
				"Verify Before Deleting Graph:",
				xmLabelWidgetClass, defaultBox, NULL );

        verifyDeleteGraphButton = XtVaCreateManagedWidget( "",
                        	xmToggleButtonGadgetClass, defaultBox, NULL );


	/************ NOT YET IMPLEMENTED FULLY - change 5 to 9 above too

	a_widget = XtVaCreateManagedWidget( 
				"Reuse Input File(s) on Execution Restart:",
				xmLabelWidgetClass, defaultBox, NULL );
        infileButton = XtVaCreateManagedWidget( "",
                        	xmToggleButtonGadgetClass, defaultBox, NULL );

	a_widget = XtVaCreateManagedWidget( 
				"Reuse Output File(s) on Execution Restart:",
				xmLabelWidgetClass, defaultBox, NULL );
        outfileButton = XtVaCreateManagedWidget( "",
                        	xmToggleButtonGadgetClass, defaultBox, NULL );

	a_widget = XtVaCreateManagedWidget( 
				"Clear Modules on Execution Restart:",
				xmLabelWidgetClass, defaultBox, NULL );
        moduleClearButton = XtVaCreateManagedWidget( "",
                        	xmToggleButtonGadgetClass, defaultBox, NULL );

	a_widget = XtVaCreateManagedWidget( 
				"Animate Graph Execution:",
				xmLabelWidgetClass, defaultBox, NULL );
        animateButton = XtVaCreateManagedWidget( "",
                              	xmToggleButtonGadgetClass, defaultBox, NULL );

	************/ 

	//  Motif action areas are never supposed to change size.
	//  We fix the size of the pane containing the buttons.

   	Dimension h; 
   	XtVaGetValues( cancelButton, XmNheight, &h, NULL );

   	XtVaSetValues( actionArea,
		       XmNpaneMaximum, h,
		       XmNpaneMinimum, h,
		       NULL );

	XtManageChild( dialogPane );
	XtManageChild( controlArea );
	XtManageChild( actionArea );

        XtAddCallback( cancelButton, XmNactivateCallback,
		      (XtCallbackProc)DefaultsDialog::_staticCancelCallback,
		      (XtPointer) this );
        XtAddCallback( okButton, XmNactivateCallback,
		      (XtCallbackProc)DefaultsDialog::_staticOkCallback,
		      (XtPointer) this );
        XtAddCallback( helpButton, XmNactivateCallback,
		      (XtCallbackProc)DefaultsDialog::_staticHelpCallback,
		      (XtPointer) this );
}

DefaultsDialog::~DefaultsDialog()
{
	XtDestroyWidget( dialogPane );
	XtDestroyWidget( controlArea );
	XtDestroyWidget( actionArea );
	XtDestroyWidget( defaultsDialog );
	pabloMainInterface = NULL;
}

void
DefaultsDialog::_cancelCallback()
{
        XtUnmanageChild( defaultsDialog );
	isManaged = FALSE_;
}

void
DefaultsDialog::_helpCallback( char* topic )
{
        Pablo::HelpSystem()->giveHelpOn( topic );
}

void
DefaultsDialog::_okCallback()
{
	/* 
	 * Unmanage the dialog.
	 * Update the global resources, and then call the Main Interface 
	 * method to do other things as needed.  
	 */

        XtUnmanageChild( defaultsDialog );
	isManaged = FALSE_;

	String dirStr;
	DIR *dirPtr;

	dirStr = XmTextGetString( configText );
	dirPtr = opendir( dirStr );
	if ( dirPtr == NULL ) {
	    error( "Cannot open graph configuration directory %s:  %s. \n\
		    Reusing previous value  ( %s )", 
		    dirStr, errorString(),
		    pabloData.defaultConfigFileDir );
	} else {
	    closedir( dirPtr );
	    pabloData.defaultConfigFileDir = XmTextGetString( configText );
	}
	XtFree( dirStr );

	dirStr = XmTextGetString( dataText );
	dirPtr = opendir( dirStr );
	if ( dirPtr == NULL ) {
	    error( "Cannot open trace file directory %s:  %s. \n\
		    Reusing previous value  ( %s )", 
		    dirStr, errorString(),
		    pabloData.defaultConfigFileDir );
	} else {
	    closedir( dirPtr );
	    pabloData.defaultDataFileDir = XmTextGetString( dataText );
	}
	XtFree( dirStr );

	pabloData.consoleLog = 
			XmTextGetString( logText );
	pabloData.displayBytesProcessed = 
			XmToggleButtonGadgetGetState( bytesProcessedButton );
	pabloData.verifyDeleteGraph = 
			XmToggleButtonGadgetGetState( verifyDeleteGraphButton );
	/**** NOT YET IMPLEMENTED FULLY 
	pabloData.restartReuseInfile = 
			XmToggleButtonGadgetGetState( infileButton );
	pabloData.restartReuseOutfile = 
			XmToggleButtonGadgetGetState( outfileButton );
	pabloData.restartClearModules = 
			XmToggleButtonGadgetGetState( moduleClearButton );
	pabloData.animateGraph = 
			XmToggleButtonGadgetGetState( animateButton );
	*********/

	pabloMainInterface->defaultsConfigureOK();

}

void
DefaultsDialog::_staticCancelCallback( Widget /* w */,
                                       XtPointer clientData,
                                       XtPointer /* callData */ )
{
        DefaultsDialog *obj = (DefaultsDialog *) clientData;

        obj->_cancelCallback();
}

void
DefaultsDialog::_staticHelpCallback( Widget /* w */,
                                     XtPointer clientData,
                                     XtPointer /* callData */ )
{
        DefaultsDialog *obj = (DefaultsDialog *) clientData;

        obj->_helpCallback( "DefaultsPanel" );
}

void
DefaultsDialog::_staticOkCallback( Widget /* w */,
                                   XtPointer clientData,
                                   XtPointer /* callData */ )
{
        DefaultsDialog *obj = (DefaultsDialog *) clientData;

        obj->_okCallback();
}

void
DefaultsDialog::raiseDialog()
{
	if ( isManaged ) {
            XRaiseWindow( XtDisplay(defaultsDialog), XtWindow(defaultsDialog) );
	} else {
	    /* 
	     * Set the initial values from the global resources and then
	     * manage the dialog.
	     */

            XmTextSetString( configText, pabloData.defaultConfigFileDir );
            XmTextSetString( dataText, pabloData.defaultDataFileDir );
            XmTextSetString( logText, pabloData.consoleLog );
            XmToggleButtonGadgetSetState( bytesProcessedButton, 
				pabloData.displayBytesProcessed, FALSE_ );
            XmToggleButtonGadgetSetState( verifyDeleteGraphButton, 
				pabloData.verifyDeleteGraph, FALSE_ );
	    /************* NOT YET FULLY IMPLEMENTED
            XmToggleButtonGadgetSetState( infileButton, 
				pabloData.restartReuseInfile, FALSE_ );
            XmToggleButtonGadgetSetState( outfileButton, 
				pabloData.restartReuseOutfile, FALSE_ );
            XmToggleButtonGadgetSetState( moduleClearButton, 
				pabloData.restartClearModules, FALSE_ );
            XmToggleButtonGadgetSetState( animateButton, 
				pabloData.animateGraph, FALSE_ );
	    ***********/

            XtManageChild( defaultsDialog );
	    isManaged = TRUE_;
	}
}



void
DefaultsDialog::printOn(ostream &os) const 
{
	os << "DefaultsDialog\n";
}

/*
 * Initialize the static data
 */
const char *const DefaultsDialog::MY_CLASS = "DefaultsDialog";
PabloMainInterface *DefaultsDialog::pabloMainInterface = NULL;
