/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * GraphEdge.cc: Implements GraphEdge.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/GraphEdge.C,v 1.11 1994/02/25 04:33:26 aydt Exp $
 */
#include <Xm/Label.h>

#include "GraphEdge.h"
#include "GraphNode.h"

#include "util.h"

GraphEdge::GraphEdge( WidgetBase *par, const XArgs& args, const CString& name,
		      GraphNode *fromNode, GraphNode *toNode ) 
	  : ShapedLabel( par ), sourceNode( fromNode )

{
	_setType("GraphEdge");

	XmString xmlabel;
	xmlabel = XmStringCreateLtoR( "", XmSTRING_DEFAULT_CHARSET );
	
	XArgs myargs( args );
	myargs.addArg( XmNlabelString, (XtArgVal) xmlabel );
	myargs.addArg( XmNx, (XtArgVal) 1000 );
	myargs.addArg( XmNy, (XtArgVal) 1000 );

	widget = XmCreateLabel( par->getWidget(), (char *)name.getValue(),
			        myargs.getArgs(), myargs.getNArgs() );

	XmStringFree( xmlabel );

	Position sx, sy, ex, ey;
	sx = sy = ex = ey = 0;

	fromNode->getBottomCenter( &sx, &sy );
	toNode->getTopCenter( &ex, &ey );

	setupShape();
	_setEndpoints( sx, sy, ex, ey );

	XLowerWindow( XtDisplay(widget), XtWindow(widget) );
}

GraphEdge::~GraphEdge()
{

}

void 
GraphEdge::_setEndpoints( Position sX, Position sY, Position eX, Position eY )
{
	startX = sX;
	startY = sY;
	endX = eX;
	endY = eY;

	Pixmap mask = getMask();
	XFillRectangle( getDisplay(), mask, blankGC, 0, 0, 
			maskWidth, maskHeight );

	Position posX, posY;
	Position lsX, lsY, leX, leY;

	int signX = ( sX < eX ) ? 1 : -1;
	int signY = ( sY < eY ) ? 1 : -1;

	Dimension width = ( eX - sX ) * signX;
	Dimension height = ( eY - sY ) * signY;

	if ( sX < eX ) {
	    if ( sY < eY ) {
		// Case 1
		posX = sX;
		posY = sY;

		lsX = 0;
		lsY = 0;
		leX = width;
		leY = height;
	    } else {
		// Case 2
		posX = sX;
		posY = eY;

		lsX = 0;
		lsY = height;
		leX = width;
		leY = 0;
	    }
	} else {
  	    if (sY < eY) {
		// Case 3
		posX = eX;
		posY = sY;

		lsX = width;
		lsY = 0;
		leX = 0;
		leY = height;
	    } else {
		// Case 4
		posX = eX;
		posY = eY;

		lsX = width;
		lsY = height;
		leX = 0;
		leY = 0;
	    }
	}
			
	setPosition( posX, posY );
	setSize( width, height );

	XDrawLine( getDisplay(), mask, lineGC, lsX, lsY, leX, leY );

	setShape();
}

void 
GraphEdge::setStart( Position x, Position y )
{
	_setEndpoints( x, y, endX, endY );
}

void  
GraphEdge::setEnd( Position x, Position y )
{
	_setEndpoints( startX, startY, x, y );
}

void 
GraphEdge::initializeGraphics()
{
	/* overloads Shaped label method */

	Pixel bg, fg;
	XArgs xargs;

	xargs.addArg( XmNbackground, (XtArgVal) &bg );
	xargs.addArg( XmNforeground, (XtArgVal) &fg );
	getArgs( xargs );

	manage();

	Display *display = getDisplay();

	Dimension width, height;
	getParent()->getSize( &width, &height );

	mask = XCreatePixmap( display, getWindow(), width, height, 1 );
	gc = XCreateGC( display, mask, 0, &xgcv );

	XGCValues xgcv1, xgcv2;

	blankGC = XCreateGC( display, mask, 0, &xgcv1 );
	lineGC = XCreateGC( display, mask, 0, &xgcv2 );

	XSetForeground( display, blankGC, 0 );
	XSetBackground( display, blankGC, 0 );

	XSetForeground( display, lineGC, 1 );
	XSetBackground( display, lineGC, 0 );
	XSetLineAttributes( display, lineGC, 4, 0, CapButt, JoinRound );

	graphicsInitialized = TRUE_;
}

void 
GraphEdge::setupShape()
{
	/* overloads ShapedLabel method */

	GC gc = getGC();
	Pixmap mask = getMask();
	Display *dpy = getDisplay();

	getParent()->getSize( &maskWidth, &maskHeight );

	XSetForeground( dpy, gc, 0 );
	XFillRectangle( dpy, mask, gc, 0, 0, maskWidth, maskHeight );

	setShape();
}
