/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Pablo.cc - main() -- we start here!
 *
 *      $Header: /mnt/Pablo-guitar/aydt.1-92/Src/System/Base/RCS/Obj.cc,v 1.2 19
92/02/14 23:28:41 aydt Exp $
 */

#include "Pablo.h"

#include "FunctionalUnitManager.h"
#include "GeneralDialogBox.h"
#include "InfrastructureManager.h"
#include "TagMappingDictionary.h"
#include "PabloHelpSystem.h"
#include "PabloMainInterface.h"
#include "StructureDictionary.h"
#include "TranscriptWindow.h"
#include "TranscriptWindowBuf.h"
#include "WidgetBase.h"

TranscriptWindowBuf PabloTranscriptBuf;
TranscriptWindowBuf PabloTranscriptErrorBuf;

ostream Transcript( &PabloTranscriptBuf );
ostream ErrorTranscript( &PabloTranscriptErrorBuf );

main( int argc, char **argv )
{
	cout = Transcript;
	cerr = ErrorTranscript;

	cout << "Pablo Visualization Environment - Release 3.0\n";
	cout << "Copyright (c) 1987-1994\n";
 	cout << "The University of Illinois Board of Trustees.\n";
	cout << "All Rights Reserved.\n\n";
	cout << "Pablo is a registered trademark of\n";
 	cout << "the University of Illinois Board of Trustees\n";
	cout << "with the U.S. Patent and Trademark Office.\n\n";

	Pablo *pabloInstance = new Pablo();
	pabloInstance->initialize( &argc, argv );

	PabloTranscriptBuf.setWindowAndType( Pablo::Transcript(), TW_Normal );
	PabloTranscriptErrorBuf.setWindowAndType( Pablo::Transcript(), 
						  TW_Error );

	Pablo::MainInterface()->run();

	// Eventually we need to delete pabloInstance, but now it
	// takes forever, so we don't.
	//
	//	delete pabloInstance;
}

Pablo::Pablo()
{
}

Pablo::~Pablo()
{
	// Eventually clean up things here!
}

void
Pablo::initialize( int *argc, char **argv )
{
	if ( initialized == FALSE_ ) {
	    initialized = TRUE_;

	    globalStructureDict = new StructureDictionary;
	    globalTagMappingDict = new TagMappingDictionary;
	    globalFUM = new FunctionalUnitManager;
	    globalIM = new InfrastructureManager;
	    globalMainInterface = new PabloMainInterface( argc, argv );
	    globalTopLevel = globalMainInterface->getTopLevel();
	    globalGeneralDialog = new GeneralDialogBox;
	    globalTranscriptWindow = new TranscriptWindow;
	    globalHelpSystem = new PabloHelpSystem( 
						globalTopLevel->getWidget() );
	}
}


/*
 * Initialize static data, first things in the Pablo class, and then
 * from other classes that must be done in a specific order.
 */

Boolean_ 	          Pablo::initialized = FALSE_;
FunctionalUnitManager    *Pablo::globalFUM = NULL;
InfrastructureManager    *Pablo::globalIM = NULL;
PabloMainInterface       *Pablo::globalMainInterface = NULL;
StructureDictionary      *Pablo::globalStructureDict = NULL;
TagMappingDictionary     *Pablo::globalTagMappingDict = NULL;
WidgetBase               *Pablo::globalTopLevel = NULL;
GeneralDialogBox         *Pablo::globalGeneralDialog = NULL;
TranscriptWindow         *Pablo::globalTranscriptWindow = NULL;
PabloHelpSystem          *Pablo::globalHelpSystem = NULL;

#ifndef CONSTRUCT_NONLOCAL_STATICS

#include "Array.h"
#include "CString.h"
#include "RecordDossier.h"
#include "RecordDictionary.h"
#include "StructureDescriptor.h"
#include "StructureDictionary.h"
#include "Value.h"

Obj Array::MSG_OBJ( "Array" );
Obj Value::MSG_OBJ( "Value" );
CString CString::NOMATCH( "_NO_MTCH" );
RecordDossier RecordDictionary::noDossier( CString::NOMATCH );
RecordDossier RecordDossier::NODOSSIER( CString::NOMATCH );
FieldDescriptor StructureDescriptor::noField( CString::NOMATCH );
StructureDescriptor StructureDictionary::noStructure( CString::NOMATCH );

#endif 
