# Perl script "processFUdefs.perl"

die "Usage: $0 file outputfile\n" if (@ARGV != 2);

$input_file = $ARGV[0];
$output_file = $ARGV[1];
@classnames = ();
@names = ();
@iconnames = ();

$output_cc = "$output_file.C";
$output_h = "$output_file.h";

open(INPUT, $input_file) || die "Cannot open input file $input_file: $!\n";

if (-f "$output_cc")
{
	print "Moving $output_cc to $output_cc.bak\n";
	system("/bin/mv -f $output_cc $output_cc.bak");
	die "Couldn't rename output file, exiting\n" if ( -f $output_cc );
}

if (-f "$output_h")
{
	print "Moving $output_h to $output_h.bak\n";
	system("/bin/mv -f $output_h $output_h.bak");
	die "Couldn't rename output file, exiting\n" if ( -f $output_h );
}

open(CC_OUTPUT, ">$output_cc") || die "Couldn't open output $output_cc: $!\n";
open(H_OUTPUT, ">$output_h") || die "Couldn't open output $output_h: $!\n";

$baseclass = "";

while (<INPUT>)
{
	chop;
        @fields = split;
	next if ($fields[0] =~ /^#/);

	if ($baseclass eq "")
	{
		$baseclass = $_;
		next;
	}
	if (@fields < 1 || @fields > 2)
	{
		print "Invalid line \"$_\"\n" if (@fields > 2);
		next;
	}
	$classname = $fields[0];
	if (@fields > 1)
	{
		$name = $fields[1];
	}
	else
	{
		$name = $classname;
	}
	if (@fields > 2)
	{
		$iconname = $fields[2];
	}
	else
	{
		$iconname = "DefaultIcon";
	}

	push(@classnames, $classname);
	push(@names, $name);
	push(@iconnames, $iconname);
}
close(INPUT);

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

print H_OUTPUT <<EOF;
/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * $output_h
 *
 * Definition file created by $0 at $hour:$min on $mon/$mday/$year by $ENV{"USER"}
 * for input $input_file.
 */
EOF

print CC_OUTPUT <<EOF;
/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * $output_cc
 *
 * Definition file created by $0 at $hour:$min on $mon/$mday/$year by $ENV{"USER"}
 * for input $input_file.
 */
EOF

print H_OUTPUT "\n";
print CC_OUTPUT "\n";

# Print the include file lines
for $cname (@classnames)
{
	print CC_OUTPUT "#include \"$cname.h\"\n";
}

print CC_OUTPUT "\n";

# Print the instance list
for $cname (@classnames)
{
	print CC_OUTPUT "$cname ${cname}Instance;\n";
}

print CC_OUTPUT "\n";

# Print out the array decl

print CC_OUTPUT "$baseclass *${baseclass}InstanceList[] = {\n";

for $cname (@classnames)
{
	print CC_OUTPUT "\t&${cname}Instance,\n";
}
print CC_OUTPUT "};\n\n";

# Print out the name list

print CC_OUTPUT "char *${baseclass}NameList[] = {\n";
for $name (@names)
{
	print CC_OUTPUT "\t\"$name\",\n";
}
print CC_OUTPUT "};\n\n";

print CC_OUTPUT "int N${baseclass}Instances = " . @names . ";\n";

# Print the include file lines
for $cname (@classnames)
{
	print H_OUTPUT "#include \"$cname.h\"\n";
}

print H_OUTPUT "\n";

print H_OUTPUT "extern $baseclass *${baseclass}InstanceList[];\n";
print H_OUTPUT "extern char *${baseclass}NameList[];\n";
print H_OUTPUT "extern int N${baseclass}Instances;\n";


close(CC_OUTPUT);
close(H_OUTPUT);
