/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * DoubleList.cc:
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/UsefulClasses/RCS/DoubleList.C,v 1.4 1994/02/25 04:34:41 aydt Exp $
 */



#include "DoubleList.h"

static double NullObj = 0;

DoubleList::DoubleList(int initialSize)
{
	list = new double [initialSize];
	nItems = 0;
	nItemsAllocated = initialSize;
}

DoubleList::~DoubleList()
{
	delete list;
}

DoubleList::DoubleList(DoubleList &objlist)
{
	int i;
	
	list = new double [objlist.nItemsAllocated];
	nItems = objlist.nItems;
	nItemsAllocated = objlist.nItemsAllocated;

	for (i = 0; i < nItems; i++)
		list[i] = objlist.list[i];
}

DoubleList &DoubleList::operator=(DoubleList &objlist)
{
//cout << "In DoubleList needing " <<  objlist.nItemsAllocated << NL;
	int i;

	if (list != NULL)
		delete list;
	
	list = new double [objlist.nItemsAllocated];
	nItems = objlist.nItems;
	nItemsAllocated = objlist.nItemsAllocated;

	for (i = 0; i < nItems; i++) {
		list[i] = objlist.list[i];
		//cout.form ("i is %d, list[i] is %d\n", i, list[i] );
	}

	return *this;
}

int DoubleList::addElement(double &elt)
{
	int idx;
	
	if (nItems == nItemsAllocated)
	{
		growList(nItems);
	}

	idx = nItems++;

	list[idx] = elt;	

	return idx;
}

void DoubleList::reset()
{
	nItems = 0;
	delete list;
	list = new double [nItemsAllocated];
}

int DoubleList::computeNewSize(int requestedIndex)
{
	if (requestedIndex < nItemsAllocated)
		return nItemsAllocated * 2;
	else
		return requestedIndex * 2;
}

void DoubleList::growList(int n)
{
	resizeListTo(computeNewSize(n));
}

Boolean_ DoubleList::resizeListTo(int n)
{
	double *oldList;
	
	if (nItemsAllocated > n)
		return TRUE_;

	oldList = list;
	list = new double [n];

	for (int i = 0; i < nItemsAllocated; i++)
		list[i] = oldList[i];
	
	nItemsAllocated = n;
	return TRUE_;
}

int DoubleList::setElement(int n, const double &elt)
{
	if (n < 0)
	{
		cerr << "Ack! index " << n;
		cerr << " out of bounds in DoubleList::setElement(int)\n";
		return n;
	}

	if (n >= nItemsAllocated)
		growList(n);

	if (n >= nItems)
		nItems = n + 1;
	
	list[n] = elt;
	return n;
}

const double &DoubleList::getElement(int n) const
{
	if (n < 0 || n >= nItems)
	{
		cerr << "Ack! index " << n;
		cerr << " out of bounds in DoubleList::getElement(int)\n";
		return NullObj;
	}

	return list[n];
}

double &DoubleList::operator[](int n) 
{
	if (n < 0)
	{
		cerr << "Ack! index " << n;
		cerr << " out of bounds in DoubleList::[](int)\n";
		return NullObj;
	}

	if (n >= nItemsAllocated)
		growList(n);
	if (n >= nItems)		
		nItems = n + 1;

	return list[n];
}

int DoubleList::lookup(double &elt) const
{
	int i;

	for (i = 0; i < nItems; i++)
	{
		if (list[i] == elt)
			return i;
	}
	return -1;
}

int DoubleList::insertElementAt(int n, double &elt)
{
	int i;

	if (n >= nItemsAllocated)
		growList(n);
	if (nItems == nItemsAllocated)
		growList(nItems);

	if (n >=  nItems)
		nItems = n;

	for (i = nItems; i > n; i--)
		list[i] = list[i - 1];
	list[n] = elt;
	nItems++;
	return n;
}


void DoubleList::deleteElementAt(int n)
{
	int i;

	if (n >= nItemsAllocated)
		growList(n);

	if (n >=  nItems)
		nItems = n + 1;

	for (i = n; i < nItems - 1; i++)
		list[i] = list[i + 1];
	nItems--;
	list[nItems] = NullObj;
}

int DoubleList::count() const
{
	return nItems;
}

int DoubleList::allocatedSize() const
{
	return nItemsAllocated;
}

int DoubleList::isEmpty() const
{
	return nItems == 0;
}

void DoubleList::printOn(ostream & os) const
{
	os << "DoubleList: " << count() << " items\n";
}
