/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinios 61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *  
 * Author: Bradley W. Schwartz  (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include <stdlib.h>

#include "LabelUtilities.h"


/* CONSTRUCTOR */
LabelUtilities::LabelUtilities()
{
}


/* DESTRUCTOR */
LabelUtilities::~LabelUtilities()
{
}


Pixmap LabelUtilities::rotateVerticalLabel( Widget widget,
					    XFontStruct *labelFont,
					    const char *label )
{
        // Determine dimensions of the label to be rotated
        int notUsed1, notUsed2, notUsed3;
        XCharStruct overallExtents;
        XTextExtents( labelFont,
       		      (char *)label, strlen( label ),
		       &notUsed1, &notUsed2, &notUsed3,
		       &overallExtents );
	int labelWidth = overallExtents.width;
        int labelHeight = overallExtents.ascent + overallExtents.descent;

	// Build a GC for rendering the label
	Display *display = XtDisplay(widget);
	Drawable drawable = XtWindow(widget);
	int screenNumber = DefaultScreen(display);
	int depth = DefaultDepth(display, screenNumber );
	    
	Pixel background, foreground;
	XtVaGetValues( widget,
		       XmNbackground, &background,
	               XmNforeground, &foreground,
		           NULL );
	unsigned long gcMask = GCForeground | GCBackground | GCFont;
        XGCValues gcValues;
        gcValues.foreground = foreground;
        gcValues.background = background;
        gcValues.font = labelFont->fid;
        GC gc = XCreateGC( display, drawable, gcMask, &gcValues );

	// Render the (unrotated) label in a pixmap
        Pixmap labelPixmap = XCreatePixmap( display, drawable,
			                    labelWidth, labelHeight, depth );
	XDrawImageString( display, labelPixmap, gc,
			  0, overallExtents.ascent,
		          label, strlen(label) );

	 // Convert the label pixmap to an XImage
	 XImage *labelImage = XGetImage( display, labelPixmap,
					 0,0,
				         labelWidth, labelHeight,
				         AllPlanes,
				         ZPixmap );

	 // Create a new XImage for the rotated label
	 XImage *rotatedLabelImage = XCreateImage( display,
	                            DefaultVisual( display, screenNumber ),
				                   depth, ZPixmap, 0, 0,
				                   labelHeight, labelWidth,
				                   BitmapPad(display), 0 );
	 rotatedLabelImage->data = XtMalloc(
					rotatedLabelImage->bytes_per_line *
				        rotatedLabelImage->height );

         // Perform the image-image rotation conversion
         // NOTE:  It is possible to use direct array addressing rather
         //   than XGet/PutPixel, but its not as "portable".  Also --      
         //   it didn"t work like I expected it to (like I programmed
         //   it on a VaxStation once.  Careful if you try this... .
	 int i, j;
	 for (i=0; i<labelImage->height; i++) {
              for (j=0; j<labelImage->width; j++) {
		  XPutPixel( rotatedLabelImage,
		             i,
			     (rotatedLabelImage->height-j-1),
		              XGetPixel( labelImage, j, i ) );
	      }
	 }

	 // Create a new pixmap for the rotated label
         Pixmap rotatedLabelPixmap = XCreatePixmap( display, drawable,
	                                        rotatedLabelImage->width,
				                rotatedLabelImage->height,
						     depth );
	 // Copy the rotated image to the result pixmap
	 XPutImage( display, rotatedLabelPixmap, gc,
		    rotatedLabelImage,
		    0,0, 0,0, 
                    rotatedLabelImage->width, rotatedLabelImage->height );

	 // Deallocate memory
	 XFreePixmap( display, labelPixmap );
	 XDestroyImage( labelImage );
         XDestroyImage( rotatedLabelImage );
	 return( rotatedLabelPixmap );
}


XmString LabelUtilities::verticalizeLabel( const char *label )
{
        char *verticalizedLabel = new char[2 * strlen(label)];

        for (int j=0;  label[j] != '\0'; j++) {
            verticalizedLabel[2*j] = label[j];
            verticalizedLabel[2*j+1] = '\n';
        }
        verticalizedLabel[2*j] = '\0';

        XmString verticalString = XmStringCreateLtoR( verticalizedLabel,
						   XmSTRING_DEFAULT_CHARSET );
        free( verticalizedLabel );
        return( verticalString );
}

    

