/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ActionTable.cc: Methods for the ActionTable class.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Wrapper/RCS/ActionTable.C,v 1.7 1994/02/25 04:35:53 aydt Exp $
 */

#include "Assert.h" 
#include "ActionTable.h"

ActionTable::ActionTable( int initialSize )
{
	_setClassName( MY_CLASS );

	Assert( initialSize > 0 );

	list = new ActionRecord* [ initialSize ];
	nItems = initialSize;

	for ( int i = 0; i < nItems; i++ ) {
	    list[i] = new ActionRecord();
	}
}

ActionTable::~ActionTable()
{
	for ( int i = 0; i < nItems; i++ ) {
	    delete list[i];
	}

	delete [] list;
}

void 
ActionTable::_growList( int n )
{
        // We should not be here if element n exists in current list.
	Assert( n >= nItems );

	ActionRecord* *oldList = list;
	int newSize = n + 1;
	list = new ActionRecord* [ newSize ];

	// Move original entries and initialize new entries
	for ( int i = 0; i < nItems; i++ ) {	
	    list[i] = oldList[i];
	}
	while ( i < newSize ) {			
	    list[i] = new ActionRecord();
	    i++;
	}

	delete [] oldList;
	nItems = newSize;
}

void
ActionTable::loadConfiguration( FILE *fp )
{
	int number;
	static char buf[512];

 	fscanf( fp, "%[^\n]\n", buf );          // Comment line
	fscanf( fp, "%d\n", &number );          // Number of entries
	if ( number > nItems ) {
	    _growList( number - 1 );
	}

	for ( int i = 0; i < number; i++ ) {
 	    fscanf( fp, "%[^\n]\n", buf );     // Comment line w/ record tag
	    list[i]->_loadConfiguration( fp );
	}
}
	
void
ActionTable::resetAllInvalid()
{
	for ( int i = 0; i < nItems; i++ ) {
	    list[i]->_reset( ActionInvalid );
	}
}

void
ActionTable::saveConfiguration( FILE *fp ) const
{
	fprintf( fp, "# ActionTable configuration - Number of entries:\n" );
	fprintf( fp, "%d\n", nItems );

	for ( int i = 0; i < nItems; i++ ) {
	    fprintf( fp, "# Entry for Record Tag = %d\n", i );
	    list[i]->_saveConfiguration( fp );
	}
}

ActionRecord&
ActionTable::operator[]( int index ) 
{
	Assert( index >= 0 );

	if ( index >= nItems ) {
	    _growList( index );
	}

	return *list[ index ];
}

void 			/* virtual */
ActionTable::printOn( ostream& strm ) const
{
	strm << form( "ActionTable(%x): %d entries.", this, nItems );
	int i;
	for ( i = 0; i < nItems; i++ ) {
	    strm << form( "\nCell %d:  \n", i );
	    list[i]->printOn( strm );
	}
}

/*
 * 	Initialize the static data.  Only executed once.
 */
const char *const ActionTable::MY_CLASS = "ActionTable";
