/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Wrapper.cc: Implements Base Wrapper.
 *
 *	 $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Wrapper/RCS/Wrapper.C,v 1.16 1994/02/25 04:41:25 aydt Exp $
 */

#include <string.h>

#include "Wrapper.h"

#include "Pablo.h"
#include "RecordDictionaryPIterator.h"
#include "StructureDictionary.h"

Wrapper::Wrapper( ) 
{
	_objectName = NULL;
	binaryOutput = NULL;
	outputDictionary = NULL;
	needsConfiguration = TRUE_;
}

Wrapper::~Wrapper()
{
	if ( _objectName != NULL ) {
	    delete[] _objectName;
	}

	if ( binaryOutput != NULL ) {
	    delete binaryOutput;
	}

	if ( outputDictionary != NULL ) {
	    delete outputDictionary;
	}
}

/* 
 * Protected methods 
 */

void
Wrapper::_setObjectName( const char *detailName )
{
        if ( _objectName != NULL ) {
	    delete[] _objectName;
        }

        char buf[512];
        sprintf( buf, "%s(%s)", getClassName(), detailName );
        _objectName = new char[ strlen(buf) + 1 ];
        strcpy( _objectName, buf );
}

/*
 * Public methods
 */

Boolean_ 		
Wrapper::addOutputPipe( StreamPipe *pipe )	/* virtual */
{
	if ( binaryOutput == NULL ) {
	    binaryOutput = new BinaryPipeWriter( pipe );
	    return SUCCESS_;
	} else {
	    return ( binaryOutput->addPipe( pipe ) );
	}
}

void
Wrapper::deleteOutputPipe( StreamPipe *pipe )
{
	if ( binaryOutput != NULL ) {
	    binaryOutput->deletePipe( pipe ) ;
	}
}

void
Wrapper::flushOutputDictionary()		/* virtual */
{
	if ( binaryOutput == NULL ) {
	    return;
	}

	RecordDossier *dossier;
	RecordDictionaryPIterator iter( *outputDictionary );
	int tag;

	for ( dossier = iter.first(); dossier != NULL; dossier = iter.next() ) {
	    tag = dossier->getTag();
	    const StructureDescriptor &descr = 
			Pablo::StructureDict()->fetch( tag );
	    writeDescriptor( descr, tag );
	}
}

FunctionalUnit *
Wrapper::getFunctionalUnit() const		/* virtual */
{
	return NULL;
}

const char*
Wrapper::getObjectName() const         		/* virtual */
{
        if ( _objectName == NULL ) {
                return getClassName();
        } else {
                return _objectName;
        }
}

void 
Wrapper::init()					/* virtual */
{
	needsConfiguration = TRUE_;

	if ( _objectName != NULL ) {
	    delete[] _objectName;
	    _objectName = NULL;
	}

	if ( outputDictionary != NULL ) {
	    delete outputDictionary;
	    outputDictionary = NULL;
	}
}

Boolean_ 					/* virtual */
Wrapper::saveConfigurationToDir( const CString& /* dir */,
				 int /* moduleIndex */ ) const  
{
	return TRUE_;
}

void 			/* virtual */
Wrapper::printOn( ostream& os ) const 
{
	os << "Wrapper\n";
}

