/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Keith Shields (shields@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * PabloHelpSystem.C: Implements PabloHelpSystem. 
 *
 */
#include <stdio.h>
#include <stdlib.h>

#include "PabloHelpSystem.h"

PabloHelpSystem::PabloHelpSystem( Widget top )
{
	_setClassName( MY_CLASS );

  	topLevelWidget = top;

	helpMapDir = NULL;
	helpFileName = NULL;
}

PabloHelpSystem::~PabloHelpSystem()
{
	int i;
	for ( i = 0; i < topicPtrs.count(); i++ ) {
	    if ( topicPtrs[i] != NULL ) {
		Help *helpInstance = (Help*)topicPtrs.getElement( i );
		delete helpInstance;
	    }
	}

	if ( helpMapDir != NULL ) {
	    delete[] helpMapDir;
	}

	if ( helpFileName != NULL ) {
	    delete[] helpFileName;
	}
}


void 
PabloHelpSystem::giveHelpOn( const char *topic )
{
   	/* 
	 * Open our master HelpDirs file (that was read once) - we'll
	 * use it to look for a match.
	 * Since a help window can be dismissed at any time, we have to 
      	 * have some way of systematically cleaning up the pointer list so 
      	 * we can determine whether or not it is ok to instantiate another 
      	 * instance of help on a topic. For any help window that we have a 
	 * pointer to, we check to see if it is popped up.  If so, we leave 
	 * it alone, otherwise, we can free up its space and reset the pointer 
	 * to it to NULL, allowing another help window on that same topic 
	 * to be created in the future. 
	 * After we check for cleanup, we check for a match and create
	 * a new Help instance if a match is found and no currently active
	 * window for that type.
   	 */

	char buffer[1024];
	sprintf( buffer, "%s/%s", helpMapDir, "HelpDirs" );

   	FILE *fp;
   	if ( ( fp = fopen( buffer, "r") ) == NULL) {
            warning( "Can't find file %s", buffer ); 
      	    return;
        }

	int i;
   	int topicIndex = -1;
	char dirBuffer[1024];

   	for ( i = 0; i < topicPtrs.count(); i++ ) {

	    /* cleanup first */
      	    if ( topicPtrs[i] != NULL ) {
        	Help *helpInstance = (Help*)topicPtrs.getElement( i );
		if ( ! ( helpInstance->dialogExists() ) ) {
	  	    delete helpInstance;
          	    topicPtrs.setElement( i, NULL );
		}
      	    }

	    /* check for match here; if topicIndex != -1, match already found */
	    if ( topicIndex == -1 ) {
		if ( fscanf( fp, "%s%s\n", buffer, dirBuffer ) == 2 ) {
     	    	    if ( strcmp( buffer, topic ) == 0 ) {
        		topicIndex = i;
		         
			if ( topicPtrs[i] == NULL ) {
			    int sl = strlen(helpMapDir) + strlen(dirBuffer) + 2;
        		    char *dirToUse = new char[ sl ];
			    sprintf( dirToUse, "%s/%s", helpMapDir, dirBuffer );
	    	            Help *helpInstance = new Help( topLevelWidget, 
							   dirToUse, 
							   helpFileName );
      	    	            topicPtrs.setElement( topicIndex, 
						  (void*) helpInstance );
			    delete[] dirToUse;
			}
		    }
		}
            }
   	}
	fclose( fp );
  
   	if ( topicIndex == -1 ) {
      	    error( "No Help Available for %s.", topic );
      	    return;
   	}
}

void 
PabloHelpSystem::setRootHelpDir( const char *directory )
{
    	/*
	 * Use environment variables if set since they take precedence.
	 */
	const char *string = getenv( "PABLO_HELP_DIR" );
   	if ( string == NULL ) { 
	    string = directory;
	}
	helpMapDir = new char[ strlen(string) + 1 ];
	if ( helpMapDir == NULL ) {
	    abort( "Can't allocate space for helpMapDir" );
	}
      	strcpy( helpMapDir, string );

	string = getenv( "PABLO_HELP_FILE" );
   	if ( string == NULL ) { 
	    string = DEFAULT_HELP_FILE;
	}
	helpFileName = new char[ strlen(string) + 1 ];
	if ( helpFileName == NULL ) {
	    abort( "Can't allocate space for helpFileName" );
	}
      	strcpy( helpFileName, string );

	char buffer[1024];
	sprintf( buffer, "%s/%s", helpMapDir, "HelpDirs" );

   	FILE *fp;
   	if ( ( fp = fopen( buffer, "r") ) == NULL) {
            warning( "Can't find file %s", buffer ); 
      	    return;
        }
   
	/* 
	 * Make sure we have a topicPtrs "slot" for each topic in
	 * our HelpDirs file.
	 */
	char dirBuffer[1024];
	int i = 0;
   	while ( fscanf( fp, "%s%s\n", buffer, dirBuffer ) == 2 ) {
       	    topicPtrs.addElement( NULL );
	}

   	fclose( fp );
}

/*
 *      Initialize the static data.  
 */
const char *const PabloHelpSystem::MY_CLASS = "PabloHelpSystem";


