/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801 
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef _BoxAndWhisker_h
#define _BoxAndWhisker_h


/* BoxAndWhisker resources */

/*    XtNorientation    XtOrientation     horizontal or vertical        */
/*    XtNminValue       int               minimum value                 */
/*    XtNmaxValue       int               maximum value                 */

/*    XtNsmallestValue  int               smallest data value           */
/*    XtNlargestValue   int               largest data value            */
/*    XtNmedianValue    int               median data value             */
/*    XtNQ1Value        int               25th percentile data value    */
/*    XtNQ3Value        int               75th percentile data value    */

/*    XtNsmallestIndex  int               smallest data index           */
/*    XtNlargestIndex   int               largest data index            */
/*    XtNmedianIndex    int               median data index             */
/*    XtNQ1Index        int               25th percentile data index    */
/*    XtNQ3Index        int               75th percentile data index    */

/*    XtNdata           int**             linked list data value set    */
/*    XtNdataValues     int*              data value set                */
/*    XtNdataCnt        int               number of data points         */
/*    XtNpadding        int               padding (in pixels) for sides */

/*    XtNbaseColors     Pixel*            base color set                */
/*    XtNboxColor       Pixel             color of the box              */
/*    XtNwhiskerColor   Pixel             color of the whiskers         */

#define XtNminValue             "minValue"
#define XtNmaxValue             "maxValue"
#define XtNminValues            "minValues"
#define XtNmaxValues            "maxValues"
#define XtNsmallestValue        "smallestValue"
#define XtNlargestValue         "largestValue"
#define XtNmedianValue          "medianValue"
#define XtNQ1Value              "Q1Value"
#define XtNQ3Value              "Q3Value"
#define XtNsmallestIndex        "smallestIndex"
#define XtNlargestIndex         "largestIndex"
#define XtNmedianIndex          "medianIndex"
#define XtNQ1Index              "Q1Index"
#define XtNQ3Index              "Q3Index"
#define XtNdata                 "data"
#define XtNdataValues           "dataValues"
#define XtNdataCnt              "dataCnt"
#define XtNpadding              "padding"
#define XtNbaseColors           "baseColors"
#define XtNboxColor             "boxColor"
#define XtNwhiskerColor         "whiskerColor"
#define XtNselect               "select"

#define XtCMinValue             "MinValue"
#define XtCMaxValue             "MaxValue"
#define XtCMinValues            "MinValues"
#define XtCMaxValues            "MaxValues"
#define XtCSmallestValue        "SmallestValue"
#define XtCLargestValue         "LargestValue"
#define XtCMedianValue          "MedianValue"
#define XtCQ1Value              "Q1Value"
#define XtCQ3Value              "Q3Value"
#define XtCSmallestIndex        "SmallestIndex"
#define XtCLargestIndex         "LargestIndex"
#define XtCMedianIndex          "MedianIndex"
#define XtCQ1Index              "Q1Index"
#define XtCQ3Index              "Q3Index"
#define XtCData                 "Data"
#define XtCDataValues           "DataValues"
#define XtCDataCnt              "DataCnt"
#define XtCPadding              "Padding"
#define XtCBaseColors           "BaseColors"
#define XtCBoxColor             "BoxColor"
#define XtCWhiskerColor         "WhiskerColor"


/* Include the Xmu stuff to use type converter extentions for "orientation" */
#ifndef _XtOrientation_e
#define _XtOrientation_e

#include <X11/Xmu/Xmu.h>
#endif _XtOrientation_e

typedef struct _BoxAndWhiskerRec       *BoxAndWhiskerWidget;
typedef struct _BoxAndWhiskerClassRec  *BoxAndWhiskerWidgetClass;

extern WidgetClass boxAndWhiskerWidgetClass;


/* Public Functions */

#if __STDC__ || defined(__cplusplus)

extern void BoxAndWhiskerSetValues( BoxAndWhiskerWidget w,
				    int *values, int valuecnt );
extern void BoxAndWhiskerSetValue( BoxAndWhiskerWidget w, int value );

#else

extern void BoxAndWhiskerSetValue(), BoxAndWhiskerSetValues();

#endif


#endif _BoxAndWhisker_h





