/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801 
 *          USA *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef _BoxAndWhiskerP_h
#define _BoxAndWhiskerP_h

#include <X11/CoreP.h>
#include "BoxAndWhisker.h"


typedef struct {
   /* public */
   int       minValue;                   /* minimum data value restriction  */
   int       maxValue;                   /* maximum data value restriction  */
   int       *minValues;                 /* generic min value set           */
   int       *maxValues;                 /* generic max value set           */
   int       **data;                     /* linked list data value set      */
   int       *dataValues;                /* data value set                  */
   int       *dataIndices;               /* original ordering of input data */
   int       dataValueCnt;               /* number of data values in set    */

   int	     smallestValue;              /* smallest data value seen        */
   int	     largestValue;               /* largest data value seen         */
   int       median;                     /* value of 50th percentile        */
   int       Q1value;                    /* value of 25th percentile        */
   int	     Q3value;                    /* value of 75th percentile        */

   int       smallestIndex;              /* locations of given values       */
   int       largestIndex;
   int       medianIndex;
   int       Q1index;
   int       Q3index;
   int       currentIndex;               /* index of last-found value       */

   int       padding;                    /* padding (in pixels) for box     */
   int       backing_store;              /* backing store type              */
   XtOrientation     orientation;        /* horizontal or vertical          */
   XtCallbackList    select;             /* callback for select             */

   Pixel*    baseColors;                 /* generic color set               */
   Pixel     boxColor;                   /* color of the data box           */
   Pixel     whiskerColor;               /* color of the whiskers           */
   GC        boxGC;                      /* gc for drawing the box          */
   GC        whiskerGC;                  /* gc for drawing the whiskers     */
   GC        pixmapGC;                   /* gc for manipulating the pixmap  */
} BoxAndWhiskerPart;


typedef struct _BoxAndWhiskerRec {
   CorePart core;
   BoxAndWhiskerPart boxAndWhisker;
} BoxAndWhiskerRec;

typedef struct _BoxAndWhiskerClass {
   int make_compiler_happy;
} BoxAndWhiskerClassPart;

typedef struct _BoxAndWhiskerClassRec {
   CoreClassPart core_class;
   BoxAndWhiskerClassPart boxAndWhisker_class;
} BoxAndWhiskerClassRec;

extern BoxAndWhiskerClassRec boxAndWhiskerClassRec;

#endif _BoxAndWhiskerP_h


