/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Bubble.h,v 1.8 1994/02/25 04:47:30 aydt Exp $
 */

#ifndef _XtBubble_h
#define _XtBubble_h

#include <X11/Xmu/Xmu.h>

/************************************************************************/
/* bubble resources							*/
/************************************************************************/
/* XtNcolors		Pixel*		value colors			*/
/* XtNcolumns		int		bubble columns			*/
/* XtNgridColor		Pixel		grid color			*/
/* XtNmaxValue		int		maximum value			*/
/* XtNminValue		int		minimum value			*/
/* XtNnumColors		int		number of value colors		*/
/* XtNnumPixmaps	int		number of value pixmaps		*/
/* XtNpixmaps		Pixmap*		pixmaps				*/
/* XtNshowGrid		Boolean		circle bubbles?			*/
/* XtNrows		int		bubble rows			*/
/* XtNselect		XtCallbackList	callback pointer		*/
/* XtNvalues		int*		bubble values			*/
/************************************************************************/

#define XtNcolors		"colors"
#define XtNcolumns		"columns"
#define XtNgridColor		"gridColor"
#define XtNnumColors		"numColors"
#define XtNnumPixmaps		"numPixmaps"
#define XtNshowGrid		"showGrid"
#define XtNpixmaps		"pixmaps"
#define XtNrows			"rows"
#define XtNselect		"select"
#define XtNvalues		"values"
#define XtNminValue		"minValue"
#define XtNmaxValue		"maxValue"

/* new resource classes */
#define XtCColors		"Colors"
#define XtCColumns		"Columns"
#define XtCShowGrid		"ShowGrid"
#define XtCGridColor		"GridColor"
#define XtCNumColors		"NumColors"
#define XtCNumPixmaps		"NumPixmaps"
#define XtCPixmaps		"Pixmaps"
#define XtCRows			"Rows"
#define XtCValues		"Values"
#define XtCMinValue		"MinValue"
#define XtCMaxValue		"MaxValue"

typedef struct _BubbleRec *BubbleWidget;
typedef struct _BubbleClassRec *BubbleWidgetClass;

extern WidgetClass bubbleWidgetClass;

/******************/
/* bubble methods */
/******************/
 
#if __STDC__ || defined(__cplusplus)

extern void BubbleGetRowCol( BubbleWidget w, int *row, int *col );
extern void BubbleSetValues( BubbleWidget w, int row, int col, int *values );
extern void BubbleSetValue( BubbleWidget w, int row, int col, int value );
extern void BubbleSetColors( BubbleWidget w, int numcolors, Pixel *colors );
extern void BubbleSetPixmaps( BubbleWidget w, int numpixmaps, Pixmap *pixmaps );

#else

extern void BubbleGetRowCol();
extern void BubbleSetValues();
extern void BubbleSetValue();
extern void BubbleSetColors();
extern void BubbleSetPixmaps();

#endif  /* __STDC__ || defined(__cplusplus) */

#endif _XtBubble_h
