/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Brian K. Totty (totty@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Chart.h,v 1.11 1994/02/25 04:47:57 aydt Exp $
 */

/************************************************************************/
/* chart resources							*/
/************************************************************************/
/* XtNautoscale		Boolean		do autoscaling?			*/
/* XtNdata		Pixel		color of data			*/
/* XtNinfoline		Boolean		show information line?		*/
/* XtNmarker		Pixel		color of data marker		*/
/* XtNscale		int		maximum data value		*/
/* XtNmaxValue		int		maximum value			*/
/* XtNpassive		Boolean		timeout driven?			*/
/* XtNtext		Pixel		color of text labels		*/
/* XtNselect		XtCallbackList	callback pointer		*/
/************************************************************************/

#ifndef _XtChart_h
#define _XtChart_h

#include <X11/Xmu/Xmu.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

	/* Resource Names */

#define XtNtext		"text"
#define XtNdata		"data"
#define XtNmarker	"marker"
#define XtNscale	"scale"	
#define XtNmaxValue     "maxValue"
#define XtNautoscale	"autoscale"
#define XtNpassive	"passive"
#define XtNinfoline	"infoline"
#define XtNselect	"select"

	/* Data Structures */

typedef struct _ChartRec *ChartWidget;			/* In ChartP.h */
typedef struct _ChartClassRec *ChartWidgetClass;	/* In ChartP.h */

extern WidgetClass chartWidgetClass;

 
#if __STDC__ || defined(__cplusplus)

extern void ChartAddValue( ChartWidget wid, unsigned int value );

#else

extern void ChartAddValue();

#endif  /* __STDC__ || defined(__cplusplus) */

#endif _XtChart_h

