/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Graph.h,v 1.8 1994/02/25 04:47:41 aydt Exp $
 */

#ifndef _Graph_h
#define _Graph_h

#include <X11/Xmu/Xmu.h>
#include "graphfmt.h"

/************************************************************************/
/* graph resources							*/
/************************************************************************/
/* XtNattachType	AttachType	node attachment type		*/
/* XtNfillNodes		Boolean		fill nodes ?			*/
/* XtNfont		Font		font				*/
/* XtNlinkColors	Pixel*		link colors			*/
/* XtNmaxLinkValue	int		maximum link value		*/
/* XtNmaxNodeValue	int		maximum node value		*/
/* XtNminLinkValue	int		minimum link value		*/
/* XtNminNodeValue	int		minimum node value		*/
/* XtNnodeBorderColor	Pixel		node border color		*/
/* XtNnodeColors	Pixel*		node colors			*/
/* XtNnodePixmaps	Pixmap*		node pixmaps			*/
/* XtNnodeShape		int		node shape			*/
/* XtNnumLinkColors	int		number of link colors		*/
/* XtNnumNodeColors	int		number of node colors		*/
/* XtNnumNodePixmaps	int		number of node pixmaps		*/
/* XtNselect		XtCallbackList	callback pointer		*/
/* XtNshowNodeName	Boolean		show node name			*/
/* XtNtextColor		Pixel		text color			*/
/************************************************************************/

#define XtNfillNodes		"fillNodes"
#define XtNshowNodeName		"showNodeName"
#define XtNattachType		"attachType"
#define XtNtextColor		"textColor"
#define XtNnodeBorderColor	"nodeBorderColor"
#define XtNnumNodeColors	"numNodeColors"
#define XtNnodeColors		"nodeColors"
#define XtNnodeShape		"nodeShape"
#define XtNnumNodePixmaps	"numNodePixmaps"
#define XtNnodePixmaps		"nodePixmaps"
#define XtNnumLinkColors	"numLinkColors"
#define XtNlinkColors		"linkColors"
#define XtNminNodeValue		"minNodeValue"
#define XtNmaxNodeValue		"maxNodeValue"
#define XtNminLinkValue		"minLinkValue"
#define XtNmaxLinkValue		"maxLinkValue"
#define XtNselect		"select"

#define XtCFillNodes		"FillNodes"
#define XtCShowNodeName		"ShowNodeName"
#define XtCAttachType		"AttachType"
#define XtCTextColor		"TextColor"
#define XtCNodeBorderColor	"NodeBorderColor"
#define XtCNumNodeColors	"NumNodeColors"
#define XtCNodeColors		"NodeColors"
#define XtCNodeShape		"NodeShape"
#define XtCNumNodePixmaps	"NumNodePixmaps"
#define XtCNodePixmaps		"NodePixmaps"
#define XtCNumLinkColors	"NumLinkColors"
#define XtCLinkColors		"LinkColors"
#define XtCMinNodeValue		"MinNodeValue"
#define XtCMaxNodeValue		"MaxNodeValue"
#define XtCMinLinkValue		"MinLinkValue"
#define XtCMaxLinkValue		"MaxLinkValue"

#define XtRAttachType		"AttachType"

typedef struct _GraphRec	*GraphWidget;
typedef struct _GraphClassRec	*GraphWidgetClass;

typedef enum{AttachCenter,AttachNorthSouth,AttachEastWest}	AttachType;

extern WidgetClass graphWidgetClass;

/*****************/
/* graph methods */
/*****************/

#if __STDC__ || defined(__cplusplus)

extern void GraphSetGraph( GraphWidget w, I_GraphPtr igraph );
extern void GraphSetNodeColors( GraphWidget w, int numcolors, Pixel *colors ); 
extern void GraphSetLinkColors( GraphWidget w, int numcolors, Pixel *colors ); 
extern void GraphSetNodePixmaps( GraphWidget w, int numpmaps, Pixmap *pixmaps );
extern void GraphSetLinkPixmaps( GraphWidget w, int numpmaps, Pixmap *pixmaps );
extern void GraphSetNodeValue( GraphWidget w, NodeID id, int val );
extern void GraphSetLinkValue( GraphWidget w, NodeID from, NodeID to, int val );

#else

extern void GraphSetGraph();
extern void GraphSetNodeColors(); 
extern void GraphSetLinkColors(); 
extern void GraphSetNodePixmaps();
extern void GraphSetLinkPixmaps();
extern void GraphSetNodeValue();
extern void GraphSetLinkValue();

#endif  /* __STDC__ || defined(__cplusplus) */

#endif  _Graph_h
