/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/GraphP.h,v 1.7 1994/02/25 04:47:42 aydt Exp $
 */

#ifndef _GraphP_h
#define _GraphP_h

#include "Graph.h"
#include <X11/CoreP.h>

#define DEFAULT_SIZE		750
#define PADDING			2
#define NODE_RADIUS_FRACTION	0.04
#define MIN_NODE_RADIUS		4
#define MAX_NODE_RADIUS		40
#define MAX_NODE_COLORS		32
#define MAX_NODE_PIXMAPS	32
#define MAX_LINK_COLORS		32
#define FONTPAD	   		2

typedef struct {
  /* public */
  Boolean	fill_nodes;		/* fill nodes ?			*/
  Boolean	show_node_name;		/* show node names		*/
  XFontStruct	*font;			/* font for text		*/
  int		node_shape;		/* 0-circle, 1-square		*/
  int		min_node_value;		/* minimum node value		*/
  int		max_node_value;		/* maximum node value		*/
  int		min_link_value;		/* minimum link value		*/
  int		max_link_value;		/* maximum link value		*/
  Pixel		text_color;		/* text color			*/
  Pixel		node_border_color;	/* node border color		*/
  int		num_node_colors;	/* number of node colors	*/
  Pixel		*node_colors;		/* node colors			*/
  int		num_node_pixmaps;	/* number of node pixmaps	*/
  Pixmap	*node_pixmaps;		/* node pixmaps			*/
  int		num_link_colors;	/* number of link colors	*/
  Pixel		*link_colors;		/* link colors			*/
  AttachType	attach_type;		/* node attachment type		*/
  XtCallbackList select;		/* callback for select		*/
  /* private */
  int		backing_store;		/* backing store type		*/
  int		offsetX;		/* graph X offset		*/
  int		offsetY;		/* graph Y offset		*/
  int		node_radius;		/* node radius			*/
  NodePtr	node_select;		/* selected node		*/
  GC		textGC;			/* GC for text			*/
  GC		node_borderGC;		/* GC for node border		*/
  GC		linkGC;			/* GC for simple link		*/
  GC		node_colorGCs[MAX_NODE_COLORS]; /* node colors GCs	*/
  GC		node_pixmapGCs[MAX_NODE_PIXMAPS]; /* node pixmap GCs	*/
  GC		link_colorGCs[MAX_LINK_COLORS]; /* GCs for link colors	*/
  GC		eraseGC;		/* GC for erasing		*/
  Graph		graph;			/* the graph			*/
} GraphPart;

typedef struct _GraphRec {
  CorePart	core;
  GraphPart	graph;
} GraphRec;

typedef struct _GraphClass{
  int	blah;
} GraphClassPart;

typedef struct _GraphClassRec {
  CoreClassPart		core_class;
  GraphClassPart	graph_class;
} GraphClassRec;

extern GraphClassRec graphClassRec;

#endif  _GraphP_h
