/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Contributing Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Kiviat.h,v 1.10 1994/02/25 04:47:46 aydt Exp $
 */
#ifndef _XtKiviat_h
#define _XtKiviat_h

#include <X11/Xmu/Xmu.h>

/************************************************************************/
/* kiviat resources							*/
/************************************************************************/
/* XtNaxisColor			Pixel		axis color		*/
/* XtNfaceBorderColor		Pixel		face border color	*/
/* XtNfill			Boolean		fill kiviat		*/
/* XtNfillColor			Pixel		fill color		*/
/* XtNhistory			Boolean		show history		*/
/* XtNmaxHistory		Boolean		show history of maxima  */
/* XtNhistoryColor		Pixel		history color		*/
/* XtNmaxValue			int		maximum value		*/
/* XtNminValue			int		minimum value		*/
/* XtNnumaxes			int		number of axes		*/
/* XtNselect			XtCallbackList	callback pointer	*/
/************************************************************************/

#define XtNfill			"fill"
#define XtNfaceBorderColor	"faceBorderColor"
#define XtNfillColor		"fillColor"
#define XtNhistory		"history"
#define XtNmaxHistory		"maxHistory"
#define XtNhistoryColor		"historyColor"
#define XtNaxisColor		"axisColor"
#define XtNnumaxes		"numaxes"
#define XtNminValue		"minValue"
#define XtNmaxValue		"maxValue"
#define XtNselect		"select"

#define XtCFill			"Fill"
#define XtCFaceBorderColor	"FaceBorderColor"
#define XtCFillColor		"FillColor"
#define XtCHistory		"History"
#define XtCMaxHistory		"MaxHistory"
#define XtCHistoryColor		"HistoryColor"
#define	XtCFillColor		"FillColor"
#define XtCAxisColor		"AxisColor"
#define XtCNumaxes		"Numaxes"
#define XtCMinValue		"MinValue"
#define XtCMaxValue		"MaxValue"

typedef struct _KiviatRec *KiviatWidget;
typedef struct _KiviatClassRec *KiviatWidgetClass;

extern WidgetClass kiviatWidgetClass;

/******************/
/* kiviat methods */
/******************/
 
#if __STDC__ || defined(__cplusplus)

extern void	KiviatGetSelectedAxis( KiviatWidget w, int *axis );
extern void	KiviatSetValues( KiviatWidget w, int numvals, int *values );

#else

extern void	KiviatGetSelectedAxis();
extern void	KiviatSetValues();

#endif  /* __STDC__ || defined(__cplusplus) */

#endif _XtKiviat_h
