/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu) 
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/PiechartP.h,v 1.8 1994/02/25 04:47:28 aydt Exp $
 */

#ifndef _XtPiechartP_h
#define _XtPiechartP_h

#include "Piechart.h"
#include <X11/CoreP.h>

#define MINELEDIM	3
#define MINSIZE		164
#define MAXENTRIES	64
#define MAXCOLORS	64
#define MAXPIXMAPS	64
#define PADDING		5
#define FONTPAD		3

#define PI		3.14159265358979
#define TWOPI		(2. * PI)
#define NINETY		(PI / 2.0)

typedef struct {
  /* public */
  Boolean		show_grid;	/* show grid			*/
  int			entries;	/* number of entries		*/
  int			numcolors;	/* number of colors		*/
  int			numpixmaps;	/* number of pixmaps		*/
  int			min_value;	/* minimum value		*/
  int			max_value;	/* maximum value		*/
  int			values[MAXENTRIES]; /* supplied values		*/
  Pixel			grid_color;	/* piechart grid color		*/
  Pixel			face_border_color; /* border color of pie face	*/
  Pixel			*colors;	/* value colors			*/
  Pixmap		*pixmaps;	/* value pixmaps		*/
  XtCallbackList	select;		/* callback for select		*/
  /* private */
  int			value_select;	/* selected value for callback	*/
  int			pie_select;	/* selected pie region		*/
  float			pie_select_pct; /* size of pie slice in %	*/
  int			backing_store;	/* backing store type		*/
  int			pie_offsetY;	/* y offset for face		*/
  Dimension		radius;		/* face radius factor		*/
  Position		centerX;	/* X center of face		*/
  Position		centerY;	/* Y center of face		*/
  GC			eraseGC;	/* piechart erase GC		*/
  GC			gridGC;		/* piechart grid GC		*/
  GC			face_borderGC;	/* piechart border GC		*/
  GC			colorGCs[MAXCOLORS]; /* color GCs		*/
  GC			pixmapGCs[MAXPIXMAPS]; /* pixmap GCs		*/
} PiechartPart;

typedef struct _PiechartRec {
   CorePart core;
   PiechartPart piechart;
   } PiechartRec;

typedef struct {int dummy;} PiechartClassPart;

typedef struct _PiechartClassRec {
   CoreClassPart core_class;
   PiechartClassPart piechart_class;
   } PiechartClassRec;

extern PiechartClassRec piechartClassRec;

#endif _XtPiechartP_h
