/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Scatter3D.h,v 1.10 1994/02/25 04:48:00 aydt Exp $
 */

#ifndef _Scatter3D_h
#define _Scatter3D_h

#include <X11/Xmu/Xmu.h>

/************************************************************************/
/* scatter3d resources							*/
/************************************************************************/
/* XtNautoScale			Boolean		autoscale axes		*/
/* XtNaxisXColor		Pixel		X axis color		*/
/* XtNaxisYColor		Pixel		Y axis color		*/
/* XtNaxisZColor		Pixel		Z axis color		*/
/* XtNaxisOColor		Pixel		O axis color		*/
/* XtNminXValue			int		minimum X data value	*/
/* XtNmaxXValue			int		maximum X data value	*/
/* XtNminYValue                 int             minimum Y data value    */
/* XtNmaxYValue                 int             maximum Y data value    */
/* XtNminZValue                 int             minimum Z data value    */
/* XtNmaxZValue                 int             maximum Z data value    */
/* XtNmarkerSize		int		data point marker size	*/
/* XtNcloseLabelColor		Pixel		"close" label color	*/
/* XtNapplyLabelColor           Pixel           "apply" label color     */
/* XtNresetLabelColor           Pixel           "reset" label color     */
/* XtNselect			XtCallbackList	callback pointer	*/
/************************************************************************/

#define XtNautoScale		"autoScale"
#define XtNpointColor		"pointColor"
#define XtNaxisXColor		"axisXColor"
#define XtNaxisYColor		"axisYColor"
#define XtNaxisZColor		"axisZColor"
#define XtNaxisOColor		"axisOColor"

#define XtNminXValue		"minXValue"
#define XtNmaxXValue		"maxXValue"
#define XtNminYValue            "minYValue"
#define XtNmaxYValue            "maxYValue"
#define XtNminZValue            "minZValue"
#define XtNmaxZValue            "maxZValue"

#define XtNmarkerSize		"markerSize"
#define XtNcloseLabelColor	"closeLabelColor"
#define XtNapplyLabelColor	"applyLabelColor"
#define XtNresetLabelColor	"resetLabelColor"
#define XtNselect		"select"

#define XtCAutoScale		"AutoScale"

#define XtCAxisXColor		"AxisXColor"
#define XtCAxisYColor		"AxisYColor"
#define XtCAxisZColor		"AxisZColor"
#define XtCAxisOColor		"AxisOColor"

#define XtCMinXValue		"MinXValue"
#define XtCMaxXValue		"MaxXValue"
#define XtCMinYValue            "MinYValue"
#define XtCMaxYValue            "MaxYValue"
#define XtCMinZValue            "MinZValue"
#define XtCMaxZValue            "MaxZValue"

#define XtCMarkerSize		"MarkerSize"
#define XtCCloseLabelColor	"CloseLabelColor"
#define XtCResetLabelColor	"ResetLabelColor"
#define XtCApplyLabelColor	"ApplyLabelColor"
#define XtCSelect		"Select"

typedef struct _Scatter3DRec *Scatter3DWidget;
typedef struct _Scatter3DClassRec *Scatter3DWidgetClass;

extern WidgetClass scatter3DWidgetClass;

/*********************/
/* scatter3d methods */
/*********************/
#if __STDC__ || defined(__cplusplus)

extern void Scatter3DSetValues( Scatter3DWidget w, int ptcnt, int dataset,
				int *Xvalues, int *Yvalues, int *Zvalues );

extern void Scatter3DSetColors( Scatter3DWidget w, int numcolors, 
				Pixel *colors );

#else

extern void Scatter3DSetValues();
extern void Scatter3DSetColors();

#endif  /* __STDC__ || defined(__cplusplus) */




#endif _Scatter3D_h
