/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef _XtXYGraph_h
#define _XtXYGraph_h

/*****************/
/* XYGraph Widget */
/*****************/

#include <X11/Xmu/Xmu.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/************************************************************************/
/* XYGraph resources							*/
/************************************************************************/
/* XtNconnect		Boolean		connect graph points		*/
/* XtNautoscale		Boolean		autoscale the graph		*/
/* XtNdensityPlot       Boolean         plot density for data points    */
/* XtNcolors		Pixel*		graph colors			*/  
/* XtNpointColors       int             point colors                    */
/* XtNxticks		int		xygraph x ticks			*/
/* XtNnumColors		int		number of value colors		*/
/* XtNnumPointColors    int             number of point colors          */
/* XtNxygraphCnt	int		number of xygraphs		*/
/* XtNfont		XFontStruct*	font				*/
/* XtNgridColor		Pixel		grid color			*/
/* XtNlogx		Boolean		log x axis			*/
/* XtNlogy		Boolean		log y axis			*/
/* XtNmarkerSize		int		data point marker size	*/
/* XtNtitle		char*		title				*/
/* XtNtextColor		Pixel		text color			*/
/* XtNshowRange		Boolean		show xygraph range		*/
/* XtNyticks		int		xygraph y ticks			*/
/* XtNshowTicks		Boolean		show xygraph ticks		*/
/* XtNxvalues		int*		xygraph xvalues			*/
/* XtNyvalues		int*		xygraph yvalues			*/
/* XtNvaluecnt		int*		number of points/line		*/
/* XtNminx		int		minimum x value			*/
/* XtNmaxx		int		maximum x value			*/
/* XtNminy		int		minimum y value			*/
/* XtNmaxy		int		maximum y value			*/
/* XtNselect		XtCallbackList	callback pointer		*/
/************************************************************************/

#define XtNconnect		"connect"
#define XtNcolors		"dataColors"
#define XtNbaseColors           "baseColors"
#define XtNpointColors          "pointColors"
#define XtNxticks		"xticks"
#define XtNlogx			"logx"
#define XtNlogy			"logy"
#define XtNmarkerSize		"markerSize"
#define XtNnumColors		"numDataColors"
#define XtNnumPointColors       "numPointColors"
#define XtNxygraphCnt		"xygraphCnt"
#define XtNgridColor		"gridColor"
#define XtNtextColor		"textColor"
#define XtNshowRange		"showRange"
#define XtNyticks		"yticks"
#define XtNshowTicks		"showTicks"
#define XtNxvalues		"xvalues"
#define XtNyvalues		"yvalues"
#define XtNdata                 "data"
#define XtNdataCnt              "dataCnt"
#define XtNdataSize             "dataSize"
#define XtNvalueCnt		"valueCnt"
#define XtNselect		"select"
#define XtNautoscale		"autoscale"
#define XtNdensityPlot          "densityPlot"
#define XtNminValues            "minValues"
#define XtNmaxValues            "maxValues"
#define XtNminx			"minx"
#define XtNminy			"miny"
#define	XtNmaxx			"maxx"
#define XtNmaxy			"maxy"

/* new resource classes */
#define XtCConnect		"Connect"
#define XtCColors		"DataColors"
#define XtCBaseColors           "BaseColors"
#define XtCPointColors          "PointColors"
#define XtCNumColors		"NumDataColors"
#define XtCNumPointColors       "NumPointColors"
#define XtCXticks		"Xticks"
#define	XtCLogx			"Logx"
#define	XtCLogy			"Logy"
#define XtCXYGraphCnt		"XYGraphCnt"
#define XtCGridColor		"GridColor"
#define XtCXYGraphColor		"XYGraphColor"
#define XtCMarkerSize		"MarkerSize"
#define XtCTextColor		"TextColor"
#define XtCShowRange		"ShowRange"
#define XtCShowTicks		"ShowTicks"
#define XtCYticks		"Yticks"
#define XtCXvalues		"Xvalues"
#define XtCYvalues		"Yvalues"
#define XtCData                 "Data"
#define XtCDataCnt              "DataCnt"
#define XtCDataSize             "DataSize"
#define XtCValueCnt		"ValueCnt"
#define XtCAutoscale		"Autoscale"
#define XtCDensityPlot          "DensityPlot"
#define XtCMinValues            "MinValues"
#define XtCMaxValues            "MaxValues"
#define	XtCMinx			"Minx"
#define	XtCMiny			"Miny"
#define	XtCMaxx			"Maxx"
#define	XtCMaxy			"Maxy"

typedef struct _XYGraphRec *XYGraphWidget;
typedef struct _XYGraphClassRec *XYGraphWidgetClass;

extern WidgetClass xygraphWidgetClass;


/* XYGraph Functions */

#if __STDC__ || defined(__cplusplus)

extern void XYGraphSetValues( XYGraphWidget w, 
			      int *xvalues, int *yvalues,
			      int *pointCounts, int numlines );
extern void XYGraphSetValue( XYGraphWidget w, int xvalue, int yvalue );
extern void XYGraphSetColors( XYGraphWidget w, int numcolors, Pixel *colors );
extern void XYGraphSetDensityColors( XYGraphWidget w, 
				     int numcolors, Pixel *colors );
extern void XYGraphSetBrushColors( XYGraphWidget w,
				   int numcolors, Pixel *colors );
extern void XYGraphPlotValues( XYGraphWidget w );
extern void XYGraphRemovePoint( XYGraphWidget w, int whichPoint );
extern void XYGraphSetPointColors( XYGraphWidget w, int *whichColors );
extern void XYGraphSetPointColor( XYGraphWidget w, 
				  int whichPoint, int whichColor );
extern void XYGraphGetNearestPoint( XYGraphWidget w,
				    int *xNearest, int *yNearest, int *index );
extern void XYGraphDrawPointMarker( XYGraphWidget w, int index );


#else

extern void XYGraphSetValues();
extern void XYGraphSetValue();
extern void XYGraphSetColors();
extern void XYGraphSetDensityColors();
extern void XYGraphSetBrushColors();

extern void XYGraphPlotValues();
extern void XYGraphRemovePoint();
extern void XYGraphSetPointColors(), XYGraphSetPointColor();

extern void XYGraphGetNearestPoint();
extern void XYGraphDrawPointMarker();

#endif


typedef struct Coordinate {		/* callback information		*/
	int	x;
	int	y;
} CoordinateLoc;

#endif _XtXYGraph_h
