/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ChartFormWrapper.cc:  Class wrapper for the Chart performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/ChartFormWrapper.C,v 1.10 1994/02/25 04:44:45 aydt Exp $
 */

#include <Xm/Form.h>         // Form widget class name definition

extern "C" {
#include "Chart.h"
}

#include "ChartFormWrapper.h"
#include "XArgs.h"           // Defines the X widget argument structure type
#include "util.h"            // Motif wrapper utility functions (getUniqueName)

#define ADJ_CHT_WIDTH_ARY 0.5
#define ADJ_CHT_HEIGHT_ARY 0.5
#define max(a,b)	 ( (a) > (b) ? (a):(b) )


ChartFormWrapper::ChartFormWrapper( WidgetBase *par,
			   	    const XArgs& args,
			   	    const CString& name) 
		 :PerfWidget( par )
{
    CString cUniqueWidgetName;	  // Name needed for widget creation
    Arg arglist[8];		  // Widget attribute settings	
    int i = 0;			  // Number of widget settings


    // Build a unique widget name (for use in widget creation)
    if ( name.length() == 0 ) {
	    cUniqueWidgetName = getUniqueName("Chart");
    } else {
	    cUniqueWidgetName = name;
    }

    // Build a unique widget name (for use in widget creation)
    _setType("ChartFormWrapper");

    // Create the FORM
    widget = XtCreateManagedWidget(cUniqueWidgetName.getValue(),
				   xmFormWidgetClass, par->getWidget(),
				   args.getArgs(), args.getNArgs());

    // Create a single Chart to be the initial child of the ChartForm
    cUniqueWidgetName = "ChartFormChild";


   // Set position within the Form for RESIZING
   XtSetArg( arglist[i], XmNleftAttachment, (XtArgVal) XmATTACH_POSITION);
   i++;
   XtSetArg( arglist[i], XmNrightAttachment,(XtArgVal)XmATTACH_POSITION );
   i++;
   XtSetArg( arglist[i], XmNtopAttachment, (XtArgVal) XmATTACH_POSITION );
   i++; 
   XtSetArg( arglist[i], XmNbottomAttachment,(XtArgVal)XmATTACH_POSITION);
   i++;
   XtSetArg( arglist[i], XmNleftPosition, (XtArgVal) 0); i++;
   XtSetArg( arglist[i], XmNrightPosition, (XtArgVal) 100 ); i++;
   XtSetArg( arglist[i], XmNtopPosition, (XtArgVal) 0 ); i++; 
   XtSetArg( arglist[i], XmNbottomPosition, (XtArgVal) 100 ); i++;

    // Create a single HistoryDial to be the initial child
    childList = new Widget[1];
    childList[0] = XtCreateManagedWidget( cUniqueWidgetName.getValue(),
                                          chartWidgetClass, widget,
                                          arglist, i );
    chartChildren.addElement( (void *)childList[0] );

    // Initialize dimensions of the FORM
    formCols = 1;  
    formRows = 1;
}


ChartFormWrapper::~ChartFormWrapper()
{
}

// Add-Chart-widget-to-FORM method
Widget 
ChartFormWrapper::createChild( int iDim0, int iDim1, int iWidthPct, 
			       int iHeightPct )
{
   int i = 0;
   Arg arglist[12];
   CString cUniqueWidgetName = getUniqueName("ChartFormChild");

   // Set the widget attribute position and dimensions
   XtSetArg( arglist[i], XtNx, (XtArgVal) iBaseWidth*iDim0 ); i++;
   XtSetArg( arglist[i], XtNy, (XtArgVal) iBaseHeight*iDim1 ); i++;
   XtSetArg( arglist[i], XtNwidth, (XtArgVal) iBaseWidth ); i++; 
   XtSetArg( arglist[i], XtNheight, (XtArgVal) iBaseHeight ); i++;

   // Attach the widget to the Form for RESIZING
   XtSetArg( arglist[i], XmNleftAttachment, (XtArgVal) XmATTACH_POSITION);
   i++;
   XtSetArg( arglist[i], XmNrightAttachment, (XtArgVal) XmATTACH_POSITION );
   i++;
   XtSetArg( arglist[i], XmNtopAttachment, (XtArgVal) XmATTACH_POSITION );
   i++; 
   XtSetArg( arglist[i], XmNbottomAttachment, (XtArgVal) XmATTACH_POSITION );
   i++;
   XtSetArg( arglist[i], XmNleftPosition, (XtArgVal) iDim0*iWidthPct); i++;
   XtSetArg( arglist[i], XmNrightPosition, (XtArgVal)(iDim0+1)*iWidthPct); i++;
   XtSetArg( arglist[i], XmNtopPosition, (XtArgVal) iDim1*iHeightPct); i++;
   XtSetArg( arglist[i], XmNbottomPosition,(XtArgVal)(iDim1+1)*iHeightPct);i++;

   Widget newChart = XtCreateWidget( cUniqueWidgetName.getValue(),
                                           chartWidgetClass, widget,
                                           arglist, i );
   return(newChart);
}

void
ChartFormWrapper::killChild( VoidPtrList charts, int ele )
{      
   // Eliminate the widget if it is not in the range of the new area  
   XtDestroyWidget( (Widget) charts.getElement( ele ) );
}


void
ChartFormWrapper::copyChildren( VoidPtrList *chartDest, VoidPtrList chartSrc,
			        int howMany )
{
  int iEle;

  for (iEle=0; iEle < howMany; iEle++) {
      chartDest->setElement( iEle, (void *)chartSrc.getElement(iEle) );
  }
}

// Chart resize method for Vector/Array use
void
ChartFormWrapper::resize( int iDim0, int iDim1 )
{
   Arg arglist[2];

   // Ummanage all the child widgets before resize!
   XtUnmanageChildren( childList, formRows*formCols );

   if ( (formCols == 1)  && (formRows == 1) &&
        ( (iDim0 != formCols) || (iDim1 != formRows))) {

       getChartValue( XtNwidth, (XtArgVal) &iBaseWidth ); 
       getChartValue( XtNheight, (XtArgVal) &iBaseHeight ); 

       iBaseWidth = (Dimension)( (float)iBaseWidth * ADJ_CHT_WIDTH_ARY );
       iBaseHeight = (Dimension)( (float)iBaseHeight * ADJ_CHT_HEIGHT_ARY );

       Widget origChart = (Widget) chartChildren.getElement(0);
 
       XtSetArg( arglist[0], XtNwidth, iBaseWidth );
       XtSetArg( arglist[1], XtNheight, iBaseHeight );
       XtSetValues( origChart, arglist, 2 );
   }
}


// Chart scalar value-setting method 
void
ChartFormWrapper::setChildValues( int value )
{
   ChartAddValue( (ChartWidget) chartChildren.getElement(0),  value );

}

// Chart VECTOR value-setting method 
void
ChartFormWrapper::setChildValues( int nVectorSize, int *values )
{
   int i;

   for ( i=0; i < nVectorSize; i++ ) {
      ChartAddValue( (ChartWidget)chartChildren.getElement(i), 
      		     (unsigned)values[i] );
   }
}

// Chart ARRAY value-setting method
void
ChartFormWrapper::setChildValues( int dimension, const int *aDimSizes,
	            	          int *values )
{
   int iRow, iCol;

   if (dimension == 2) {

      for (iRow=0; iRow < aDimSizes[1]; iRow++) {
 
         for (iCol=0; iCol < aDimSizes[0]; iCol++) {
             ChartAddValue(  (ChartWidget) 
                  chartChildren.getElement(iRow*aDimSizes[0]+iCol), 
                  values[ iRow*aDimSizes[0]+iCol] );
         }
      }
   }
}

// Obtains a chart attribute from a Chart within the Form 
void 
ChartFormWrapper::getChartValue( String name, XtArgVal value )
{
   Arg arg[1];

   XtSetArg( arg[0], name, value );
   XtGetValues( (Widget) chartChildren.getElement(0), arg, 1 );
}


// Sets an attribute of a Chart within the Form 
void 
ChartFormWrapper::setChartValue( String name, XtArgVal value )
{
   Arg arg[1];

   XtSetArg( arg[0], name, value );
   XtSetValues( (Widget) chartChildren.getElement(0), arg, 1 );
}

// Determines if any of the dimension sizes of the incoming data have changed
Boolean_ 
ChartFormWrapper::sizeChanged( int nVectorElements, int nRows )
{
   if ( (nRows != formRows) || (nVectorElements != formCols) ) {
      return TRUE_;
   } else {
      return FALSE_;
   }    
}

// RESIZES the Chart Form to handle a new vector size
void
ChartFormWrapper::setNumberChildren( int nNewElements, int nNewRows )
{
  Arg arglist[4];
  int i;

  // Insure enough space is allocated for the new size
  int newSize = nNewRows * nNewElements;

  // Unmanage the form during this operation for speedup
  XtUnmanageChild( widget );
  int iFractionBase = 100 * max(nNewElements, nNewRows);
  XtSetArg( arglist[0], XmNfractionBase, iFractionBase );
  XtSetValues( widget, arglist, 1 );

  int iRow, iCol;
  int iEleNew, iEleOld;
  int iWidthPct = iFractionBase/nNewElements;
  int iHeightPct = iFractionBase/nNewRows;

  for (iRow = 0; iRow < max(formRows, nNewRows); iRow++ ) {
     for (iCol=0; iCol< max(formCols, nNewElements); iCol++) {
        i = 0;
        iEleNew = iRow * nNewElements + iCol;
        iEleOld = iRow * formCols + iCol;

        if ( (iRow < nNewRows) && (iCol < nNewElements) ) {

// If the widget is in a cell that overlaps the old area, we can reuse it
           if ( (iCol < formCols) && (iRow < formRows)){
               Widget iOldWidget = (Widget) chartChildren.getElement(iEleOld );
               // MUST reset its relative position
               XtSetArg( arglist[i], XmNleftPosition, (XtArgVal) 
                                                         iCol*iWidthPct); i++;
               XtSetArg( arglist[i], XmNrightPosition, (XtArgVal) 
                                                     (iCol+1)*iWidthPct); i++;
               XtSetArg( arglist[i], XmNtopPosition, (XtArgVal) 
                                                        iRow*iHeightPct); i++;
               XtSetArg( arglist[i], XmNbottomPosition, (XtArgVal)
                                                    (iRow+1)*iHeightPct); i++;
               XtSetValues( iOldWidget, arglist, i );
               chartChildrenResize.setElement( iEleNew, (void *) iOldWidget );

           } else {
// In range of the new area, but not in old range
               chartChildrenResize.setElement( iEleNew,
                    (void *)createChild( iCol, iRow, iWidthPct, iHeightPct) );
           }
        } else {
               killChild( chartChildren, iEleOld );
       }
    }
  }

  // The readjusted list is now complete; copy it
  delete childList;
  childList = new Widget [newSize];

  // The readjusted list is now complete; copy it
  for (iEleNew = 0; iEleNew < newSize; iEleNew++) {
      childList[iEleNew] = (Widget) chartChildrenResize.getElement( iEleNew );
      chartChildren.setElement( iEleNew, (void *) childList[iEleNew] );
  }

  // Make visible all the new repositioned stuff
  XtManageChild( widget );
  XtManageChildren( childList, newSize );
  formRows = nNewRows;
  formCols = nNewElements;
}

