/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ChartFormWrapper.h: class wrapper for the Motif Chart widget
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/ChartFormWrapper.h,v 1.9 1994/02/25 04:44:40 aydt Exp $
 */


#ifndef ChartFormWrapper_h
#define ChartFormWrapper_h

#include "PerfWidget.h" 
#include "VoidPtrList.h"
                        
class ChartFormWrapper : public PerfWidget {
/*
*
* A ChartWrapper is the C++ wrapper for the Chart
* Motif widget.
*
*/

private: 

        VoidPtrList chartChildren;
	VoidPtrList chartChildrenResize;
	int	    formCols;
	int	    formRows;
        Dimension   iBaseWidth;
	Dimension   iBaseHeight;
        WidgetList  childList;

        void copyChildren( VoidPtrList *chartDest, VoidPtrList chartSrc,
                          int howMany );

        Widget createChild( int iDim0, int iDim1,
                                 int iWidthPct, int iHeightPct );

        void killChild( VoidPtrList charts, int ele ); 

public:

	/* Method ChartFormWrapper: the ChartFormWrapper constructor */
	ChartFormWrapper( WidgetBase *par, const XArgs& args,
		          const CString& name );

	/* Method ~ChartFormWrapper: the ChartFormWrapper destructor */
	~ChartFormWrapper();


	/* Method resize():  Configuration-time Chart widget resize for 
	   array suport */
        void resize( int iDim0, int iDim1);
	
	/* Method setChildValues:   sets the current values for all chart
	   children of the Form widget */ 
        void setChildValues(int value );
        void setChildValues(int nVectorSize, int *values );
        void setChildValues(int dimension, const int *aDimSizes, int *values );

	/* Method getChartValue:  retrives the value of a Chart attribute for
                           one of the children of the ChartForm */ 
        void getChartValue( String name, XtArgVal value );
        void setChartValue( String name, XtArgVal value );

	/* Method sizeChanged: determines if the size of incoming data has 
	   changed (which would require potential changes in the number of 
	   widget children, their layout and/or the widget width and height) */
        Boolean_ sizeChanged( int nVectorElements, int nRows );

	/* Method setNumberChildren:  maintains the exact number of Chart 
	   widgets specified */
        void setNumberChildren( int nNewElements, int nNewRows );

};

#endif
