/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * HistoryDialWrapper.h: A class wrapper for the HistoryDial
 * 			 performance widget
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/HistoryDialFormWrapper.h,v 1.10 1994/02/25 04:44:36 aydt Exp $
 */


#ifndef HistoryDialWrapper_h
#define HistoryDialWrapper_h

#include "HistoryDialFU.h"
#include "DisplayLabels.h"
#include "DisplayColorTables.h"  /* Maintains widget color table information */
#include "PerfWidget.h"   /* Defines parent class information for  wrapper */


class HistoryDialFormWrapper : public PerfWidget {
/*
*
* A HistoryDialWrapper is the C++ wrapper for the HistoryDial display widget.
*
*/
private:
        static const char *const MY_CLASS;
	
        DisplayLabels    labels;
	DisplayColorTables colorTable;
	WidgetList       childList;
	HistoryDialFU    *historyDialFUthisPtr;
	int              formCols, formRows;

	/* Method _adjustLayout:        Called if the number of rows or cols
	*			        has changed.  Adjusts the set of dial
	*			        displays (sizes and positions) 
	*				accordingly. This is called 
	*				automatically by setDisplayValues() 
	*				when needed.  Also see the public 
	*				method updateDisplayLayout().         */
	void _adjustLayout( int nCols, int nRows );

	/* Method _createChild:	        Creates a new dial widget for the 
	                                given row and column in the form.     */
	Widget _createChild( char *newWidgetName, int iCol, int iRow,
			    int dialLayoutXOrg, int dialLayoutYOrg,
			    int dialWidthProportion, int dialHeightProportion);

	/* Method _findDialsFormPosition:  Layout elements within Form */
	void _findDialsFormPosition( int nColElements, int nRowElements,
			 int *dialLayoutXOrg, int *dialLayoutYOrg,
			 int *dialWidthProportion, int *dialHeightProportion );

	/* Method _genChildLayout:	Maintains the Dial widget layout on
	*				data dimension changes during
	*				runtime.                              */
	void _genChildLayout( int nNewCols, int nNewRows );

	/* Method _setADialFormPosition:  Sets the layout attributes for a
	                                particular dial in the display */
	void _setADialFormPosition( int iCol, int iRow,
			   int dialLayoutXOrg, int dialLayoutYOrg,
			   int dialWidthProportion, int dialHeightProportion );

public:

	/* Method HistoryDialFormWrapper: CONSTRUCTOR */ 
	HistoryDialFormWrapper(WidgetBase *par, HistoryDialFU *historyDialFUPtr,
		               const XArgs& args, const CString& name );

	/* Method ~HistoryDialFormWrapper: DESTRUCTOR */
	~HistoryDialFormWrapper();

	/* Method callback1:            Overloads Callback::callback1 to 
	                                handle display callback */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method getHistoryDialLabel:  Set aLabel to point to text string for
	                                label specified.  If label is not set,
	                                then aLabel points to a null string */
	void getHistoryDialLabel( int whichLabel, const char **aLabel ) const;

	/* Method getHistoryDialAttr:  Get attribute of individual dial.     */
        void getHistoryDialAttr( String name, XtArgVal value ) const;

	/* Method getHistoryDialFormAttr: Get attribute of Form widget.      */
	void getHistoryDialFormAttr( String name, XtArgVal value ) const;

	/* Method setHistoryDialAttr:  Set attributes of dials in form.      */
	void setHistoryDialAttr( String name, XtArgVal value );

	/* Method setHistoryDialFormAttr:  Set attribute of Form widget.     */
	void setHistoryDialFormAttr( String name, XtArgVal value ) ;

	/* Method setHistoryDialLabel:  Set the min and max labels on Form.   */
	void setHistoryDialLabel( double fuMin, double fuMax );

	/* Method setHistoryDialLabel:  Set the Horizontal or Vertical label
	                                on Form. */
	void setHistoryDialLabel( int whichLabel, const char *stringLabel );

	/* Method setDisplayValue:      Set dial value for a scalar amount.   */
	void setDisplayValues( int value );

	/* Method setDisplayValues:     Set dial values for a vector amount.  */
	void setDisplayValues( int nCols, int *values );

	/* Method setDisplayValues:     Set dial values for a 2-d array.      */
        void setDisplayValues( int nCols, int nRows, int *values );

	/* Method setPerfWidgetColors:  Handle color allocation for the
	                                initial dial */
	void setPerfWidgetColors();

	/* Method setPerfWidgetColors:  Handle color assignment for all dials
	                                other than the initial                */
	void setPerfWidgetColors( Widget dial );

	/* Method setSingleValue:       Set a single dial value.              */
 	void setSingleValue( int iCol, int iRow, int value );

	/* Method updateDisplayLayout:	Checks for changes in the number of
	*			        columns and rows in the data and 
	*				calls _adjustLayout to redo display 
	*				if needed.                            */
	void updateDisplayLayout( int nCols, int nRows );
};

#endif
