/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *		         Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * KiviatFormWrapper.cc:  Class wrapper for the Kiviat performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/KiviatFormWrapper.C,v 1.14 1994/02/25 04:44:39 aydt Exp $
 */

#include "KiviatFormWrapper.h"

extern "C" {
#include "Kiviat.h"
}

#include <Xm/Form.h>       // Form widget class name definition
#include "XArgs.h"         // defines the X widget argument structure type

KiviatFormWrapper::KiviatFormWrapper( WidgetBase *par, KiviatFU *kiviatFUPtr,
				      const XArgs& args,
				      const CString& name ) 
	          : PerfWidget( par )
{
	_setClassName( MY_CLASS );
        kiviatFUthisPtr = kiviatFUPtr;
	_setType( "KiviatFormWrapper" );

        // Create the Motif Form widget
    	widget = XtCreateManagedWidget( name.getValue(), xmFormWidgetClass, 
					par->getWidget(), args.getArgs(), 
					args.getNArgs() );
	setKiviatFormAttr( XmNfractionBase, (XtArgVal)10000 );

        // Create a single Kiviat widget to be the initial child of the Form
	Arg arg;
        kiviatChild = XtCreateManagedWidget( "KiviatChild", kiviatWidgetClass, 
					     widget, &arg, 0 );
	// Create the labels
        labels.createMinMaxLabel( widget, "KiviatMinMaxLabel" );
	setKiviatLabel( L_LEFT_VERT, NULLCHARSTRING );
	setKiviatLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

        addCallback( kiviatChild, XtNselect, &Callback::callback1, this, NULL );

}

KiviatFormWrapper::~KiviatFormWrapper()
{
	XtDestroyWidget( widget );
}

void 
KiviatFormWrapper::_findKiviatFormPosition( int *kiviatLayoutXOrg, 
	      		    		    int *kiviatLayoutYOrg, 
					    int *kiviatWidthProportion, 
	      	            		    int *kiviatHeightProportion )
{
  	int iFractionBase, widthP, heightP, lBottom, lTop, lLeft;

        getKiviatFormAttr( XmNfractionBase, (XtArgVal) &iFractionBase );
 
  	if ( labels.isALabel( L_LEFT_VERT) ) {
	    lLeft = labels.getLabelHeight( L_LEFT_VERT ); 
	    widthP = (int)( ( iFractionBase - (2 * lLeft) ) );
  	} else {
	    lLeft = 0;
	    widthP = iFractionBase;
  	}

	*kiviatLayoutXOrg = lLeft;
	*kiviatWidthProportion = widthP;

  	if ( labels.isALabel( L_BOTTOM_HORIZ ) ) {
	    lBottom = labels.getLabelHeight( L_BOTTOM_HORIZ );
	    lTop = labels.getLabelHeight( L_TOP_HORIZ );
	    heightP = (int)( iFractionBase - lBottom - lTop ); 
  	} else {
	    lTop = labels.getLabelHeight( L_TOP_HORIZ );
	    heightP = (int)( iFractionBase - lTop ); 
  	}
  	*kiviatLayoutYOrg = lTop;
	*kiviatHeightProportion = heightP;
}

void 
KiviatFormWrapper::_setKiviatFormPosition( int kiviatLayoutXOrg, 
				           int kiviatLayoutYOrg, 
				           int kiviatWidthProportion, 
					   int kiviatHeightProportion )
{
     	Arg arglist[4];

     	XtSetArg( arglist[0], XmNleftPosition, (XtArgVal)kiviatLayoutXOrg ); 
     	XtSetArg( arglist[1], XmNrightPosition, 
                    (XtArgVal)( kiviatLayoutXOrg+kiviatWidthProportion ) ); 
     	XtSetArg( arglist[2], XmNtopPosition, (XtArgVal)kiviatLayoutYOrg );
     	XtSetArg( arglist[3], XmNbottomPosition,
                    (XtArgVal)( kiviatLayoutYOrg+kiviatHeightProportion ) );

     	XtSetValues( kiviatChild, arglist, 4 );
}


void 			/* virtual */
KiviatFormWrapper::callback1( Widget /* callbackWidget */, XtPointer /* ptr1 */,
			      XtPointer /* ptr2 */ )
{
	int axisSelected;

	KiviatGetSelectedAxis( (KiviatWidget)kiviatChild, &axisSelected );
	kiviatFUthisPtr->fuCallback( axisSelected );
}

void 
KiviatFormWrapper::getKiviatAttr( String name, XtArgVal value ) const
{
     	Arg arg;
 
     	XtSetArg( arg, name, value );
     	XtGetValues( kiviatChild, &arg, 1 );
}

void 
KiviatFormWrapper::getKiviatFormAttr( String name, XtArgVal value ) const
{
	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtGetValues( widget, &arg, 1 );
}

void 
KiviatFormWrapper::getKiviatLabel( int whichLabel, const char **aLabel ) const
{
     	labels.getLabel( whichLabel, aLabel );
} 

void 
KiviatFormWrapper::setDisplayValues( int numAxes, int *values )
{
	KiviatSetValues( (KiviatWidget)kiviatChild, numAxes, values );
}

void 
KiviatFormWrapper::setKiviatAttr( String name, XtArgVal value )
{
  	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtSetValues( kiviatChild, &arg, 1 );
}

void 
KiviatFormWrapper::setKiviatFormAttr( String name, XtArgVal value )
{
  	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtSetValues( widget, &arg, 1 );
}

void 
KiviatFormWrapper::setKiviatLabel( double fuMin, double fuMax )
{
     labels.setLabel( fuMin, fuMax );
}

void 
KiviatFormWrapper::setKiviatLabel( int whichLabel, const char *stringLabel )
{
     Boolean_ layoutChange;

     if ( whichLabel == L_LEFT_VERT ) {
         layoutChange = labels.setLabel( widget, "KiviatLabelVert", 
					 whichLabel, stringLabel );
     } else if ( whichLabel == L_BOTTOM_HORIZ ) {
         layoutChange = labels.setLabel( widget, "KiviatLabelHoriz", 
					 whichLabel, stringLabel );
     }

     if ( layoutChange ) {
         int kiviatLayoutXOrg, kiviatLayoutYOrg;
         int kiviatWidthProportion, kiviatHeightProportion;
         _findKiviatFormPosition( &kiviatLayoutXOrg, &kiviatLayoutYOrg,
			          &kiviatWidthProportion, 
				  &kiviatHeightProportion );
         _setKiviatFormPosition( kiviatLayoutXOrg, kiviatLayoutYOrg,
				 kiviatWidthProportion, 
				 kiviatHeightProportion );
     }
}

/*
 *      Initialize the static data.   Only executed once.
 */
const char *const KiviatFormWrapper::MY_CLASS = "KiviatFormWrapper";

