/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Contirbuting Author:  Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * MatrixFormWrapper.cc:  Class wrapper for the Matrix performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/MatrixFormWrapper.C,v 1.12 1994/02/25 04:44:50 aydt Exp $
 */

#include "MatrixFormWrapper.h"

extern "C" {
#include "Matrix.h"
}

#include <Xm/Xm.h>
#include <Xm/Form.h>	// Form widget class name definition
#include <Xm/Label.h>   // For Matrix widget labelling

#include "XArgs.h"
#include "util.h"


MatrixFormWrapper::MatrixFormWrapper( WidgetBase *par, MatrixFU *matrixFUPtr,
				 const XArgs & args,
				 const CString & name ) : PerfWidget( par )
{
        Arg arglist[1];
        int i = 0;

    	_setType("MatrixFormWrapper");
        // Create the Motif FORM
    	widget = XtCreateManagedWidget( name.getValue(),
				 xmFormWidgetClass, par->getWidget(),
				 args.getArgs(), args.getNArgs() );
        XtSetArg(arglist[0], XmNfractionBase, (XtArgVal)10000 );
        XtSetValues(widget, arglist, 1 );

        // Create a single Matrix to be the initial child
	matrixChild = XtCreateManagedWidget( "MatrixChild",
				       matrixWidgetClass, widget,
			               arglist, i );
        labels.createMinMaxLabel(widget, "MatrixMinMaxLabel" );
	setMatrixLabel( L_LEFT_VERT, NULLCHARSTRING );
        setMatrixLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

        addCallback(matrixChild, XtNselect,  &Callback::callback1, this, NULL);
        matrixFUthisPtr = matrixFUPtr;

}       


MatrixFormWrapper::~MatrixFormWrapper()
{
}


void 			/* virtual  - overloaded from Callback:: */
MatrixFormWrapper::callback1( Widget /* callbackWidget */, XtPointer /* ptr1 */,
			      XtPointer /* ptr2 */ )
{
   int iRow, iCol;
   MatrixGetRowCol( (MatrixWidget)matrixChild, &iRow, &iCol );
   matrixFUthisPtr->fuCallback( iRow, iCol );
}

 
  
// Generates the appropriate label for the current display instance
void MatrixFormWrapper::setMatrixLabel(int whichLabel, const char *stringLabel)
{
     Boolean_ layoutChange;
     if (whichLabel == L_LEFT_VERT) {
         layoutChange = 
         labels.setLabel( widget, "MatrixLabelVert", whichLabel, stringLabel );
     } else if (whichLabel == L_BOTTOM_HORIZ) {
         layoutChange = 
         labels.setLabel( widget,"MatrixLabelHoriz", whichLabel, stringLabel );
     }
     if (layoutChange) {
         int matrixLayoutXOrg, matrixLayoutYOrg,
             matrixWidthProportion, matrixHeightProportion;
         findMatrixFormPosition(&matrixLayoutXOrg, &matrixLayoutYOrg,
			      &matrixWidthProportion, &matrixHeightProportion);
         setMatrixFormPosition( matrixLayoutXOrg, matrixLayoutYOrg,
				matrixWidthProportion, matrixHeightProportion);
     }
}



// Sets values in the Matrix"s min/max label
void 
MatrixFormWrapper::setMatrixLabel( double fuMin, double fuMax )
{
     labels.setLabel( fuMin, fuMax );
}


// Retrieves the text string for the given label
void 
MatrixFormWrapper::getMatrixLabel( int whichLabel, const char **aLabel ) const
{
     labels.getLabel(whichLabel, aLabel);
} 

// Retrieves a Matrix (not MatrixForm) attribute
void 
MatrixFormWrapper::getMatrixAttr( String name, XtArgVal value )
{
     Arg arg[1];
 
     XtSetArg( arg[0], name, value );
     XtGetValues( matrixChild, arg, 1 );
}

// SETS a Matrix attribute for the Matrix within the Form 
void 
MatrixFormWrapper::setMatrixAttr( String name, XtArgVal value )
{
   Arg arg[1];

   XtSetArg( arg[0], name, value );
   XtSetValues( matrixChild, arg, 1 );
}

void 
MatrixFormWrapper::getMatrixFormAttr( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtGetValues( widget, arglist, 1 );
}


void 
MatrixFormWrapper::setMatrixFormAttr( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtSetValues( widget, arglist, 1 );
}

void 
MatrixFormWrapper::findMatrixFormPosition(
              int *matrixLayoutXOrg, int *matrixLayoutYOrg,
	      int *matrixWidthProportion, int *matrixHeightProportion )
{
  int iFractionBase;
  getMatrixFormAttr( XmNfractionBase, (XtArgVal) &iFractionBase );
  *matrixLayoutYOrg = labels.getLabelHeight(L_TOP_HORIZ);
 
  if (labels.isALabel(L_LEFT_VERT)) {
      *matrixWidthProportion = (int)(iFractionBase -
                                  2*labels.getLabelHeight(L_LEFT_VERT));
      *matrixLayoutXOrg = labels.getLabelHeight(L_LEFT_VERT);
  } else {
      *matrixWidthProportion = iFractionBase;
      *matrixLayoutXOrg = 0;
  }
  if (labels.isALabel(L_BOTTOM_HORIZ)) {
      *matrixHeightProportion = (int)(iFractionBase -
                               labels.getLabelHeight(L_BOTTOM_HORIZ) -
                               labels.getLabelHeight(L_TOP_HORIZ) );
  } else {
      *matrixHeightProportion = 
                   (int)(iFractionBase-labels.getLabelHeight(L_TOP_HORIZ));
  }
}


void 
MatrixFormWrapper::setMatrixFormPosition( 
                      int matrixLayoutXOrg, int matrixLayoutYOrg,	
                      int matrixWidthProportion, int matrixHeightProportion )
{
     Arg arglist[4];
     int i = 0;

     XtSetArg( arglist[i], XmNleftPosition, (XtArgVal)matrixLayoutXOrg); i++;
     XtSetArg( arglist[i], XmNrightPosition, 
                    (XtArgVal)(matrixLayoutXOrg+matrixWidthProportion)); i++;
     XtSetArg( arglist[i], XmNtopPosition, (XtArgVal)matrixLayoutYOrg); i++;
     XtSetArg( arglist[i], XmNbottomPosition,
                   (XtArgVal)matrixLayoutYOrg+matrixHeightProportion); i++;
     XtSetValues( matrixChild, arglist, i );
}

void 
MatrixFormWrapper::setDisplayValue( int row, int column, int value )
{
	MatrixSetValue( (MatrixWidget)matrixChild, row, column, (int) value );
}

void 
MatrixFormWrapper::setDisplayValues( int /* valueCount */, int *values )
{
	MatrixSetValues( (MatrixWidget)matrixChild, values );
}

void 
MatrixFormWrapper::setPerfWidgetColors()
{
        colorTable.gencolor( getDisplay(), getScreen() );
	MatrixSetColors( (MatrixWidget)matrixChild, 
			 colorTable.getNumColors(),
			 colorTable.getColormapEntries() );
}

void 
MatrixFormWrapper::setPerfWidgetPixmaps(int pixmapCount, Pixmap* pixmaps)
{
	MatrixSetPixmaps( (MatrixWidget)matrixChild, pixmapCount, pixmaps );
}

