/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef MultivariateWidgetWrapper_h
#define MultivariateWidgetWrapper_h

#include "Obj.h"
#include "Callback.h"

#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>

#include "CString.h"
#define STRING_MAX_LEN    80



class MultivariateWidgetWrapper : public Obj,
                                  public virtual Callback
{
/*
 *
 * A MultivariateWidgetWrapper is a superclass for the multivariate functional
 * unit wrappers 
 *
 */

private:
protected:

public:
      /* Method MultivariateWidgetWrapper : The MultivariateWidgetWrapper
             constructor */
      MultivariateWidgetWrapper();

      /* Method ~MultivariateWidgetWrapper : The MultivariateWidgetWrapper
             destructor */
      ~MultivariateWidgetWrapper();

      /* Method addRadioToggleListToDialog : Add a radioed series of toggle
	                   buttons to an existing dialog */
      Widget addRadioToggleListToDialog( Widget parentWidget,
					 Widget topWidget,
					 CString namePrefix,
					 int numberOfToggles,
					 int whichToggleOn,
					 Widget *radioBox );

      /* Method addTextFieldToDialog : Add a single text field to an
	                               existing dialog */
      Widget addTextFieldToDialog( Widget parentWidget,
			           Widget topWidget,
			           CString namePrefix,
			           Widget *textField );

      /* Method addToggleToDialog :  Add a single labelled toggle to an
	                             existing dialog */
      Widget addToggleToDialog( Widget parentWidget,
			        Widget topWidget,
			        CString namePrefix,
			        Widget *toggleButton );

      /* Method addToggleListToDialog : Add a series of labelled toggle fields
	                                to an existing dialog */
      Widget addToggleListToDialog( Widget parentWidget,
				    CString namePrefix,
				    int numberOfToggles,
				    Widget *toggleButton1 ... );
};


#endif MultivariateWidgetWrapper_h

