/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * PiechartFormWrapper.h: A class wrapper for the pie chart performance widget
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/PiechartFormWrapper.h,v 1.8 1994/02/25 04:45:03 aydt Exp $
 */


#ifndef PiechartFormWrapper_h
#define PiechartFormWrapper_h

#include "PerfWidget.h"
#include "DisplayColorTables.h"
#include "DisplayLabels.h"

#include "PiechartFU.h"


class PiechartFormWrapper : public PerfWidget {
/*
*
* A PiechartFormWrapper is the C++ wrapper for the Piechart display widget.
*
*/
private:
	static const char *const MY_CLASS;

	DisplayColorTables colorTable;
	Boolean_           colorsSet;
	DisplayLabels      labels;
	Widget             piechartChild;
	PiechartFU        *piechartFUthisPtr;

	/* Method _filePiechartFormPosition:	Layout elements within form   */
	void _findPiechartFormPosition( int *piechartLayoutXOrg, 
					int *piechartLayoutYOrg,
	          			int *piechartWidthProportion, 
					int *piechartHeightProportion );

	/* Method _setPiechartFormPosition:	Sets the layout attributes for
	*					the piechart within the form  */
	void _setPiechartFormPosition( int piechartLayoutXOrg,
				      int piechartLayoutYOrg,
	          		      int piechartWidthProportion, 
				      int piechartHeightProportion ); 
public:
	/* Method PiechartFormWrapper: 		The constructor 	      */
	PiechartFormWrapper( WidgetBase *par, PiechartFU *piechartFUPtr,
			     const XArgs& args, const CString& name );

	/* Method ~PiechartFormWrapper: 	The destructor                */
	~PiechartFormWrapper();

	/* Method callback1:			Overloads Callback::callback1 
	*				        to handle callback in the
	*					display                       */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method getPiechartAttr:		Get attribute of individual
	*					Piechart widget.              */
        void getPiechartAttr( String name, XtArgVal value ) const;

	/* Method getPiechartFormAttr:		Get attribute of the form     */
        void getPiechartFormAttr( String name, XtArgVal value ) const;

	/* Method getPiechartLabel:		Set aLabel to point to text
	*					string for label specified. If
	*					label is not set, then aLabel
	*					points to a NULL string.      */
	void getPiechartLabel( int whichLabel, const char **aLabel ) const;

	/* Method setDisplayValues:		Sets the current values of
	*					the piechart display widget   */
	void setDisplayValues( int valueCount, int *values );

	/* Method setPiechartAttr:		Sets attribute of individual
	*					Piechart widget.              */
        void setPiechartAttr( String name, XtArgVal value );

	/* Method setPiechartFormAttr:		Sets attribute of the Form    */
	void setPiechartFormAttr( String name, XtArgVal value );

	/* Method setPiechartLabel:		Sets min and max labels on the
	*					Form                          */
        void setPiechartLabel( double fuMin, double fuMax );

	/* Method setPiechartLabel:		Set the Horizontal or Vertical
	*					Label                         */
        void setPiechartLabel( int whichLabel, const char *stringLabel );

	/* Method setPerfWidgetColors:		Sets the colors for the widget
	*					if colorsSet is FALSE_.  
	*					Changes colorsSet to TRUE_.   */
	void setPerfWidgetColors();

};

#endif
