/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * PolarWrapper.cc:  Class wrapper for the polar plot performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/PolarWrapper.C,v 1.11 1994/02/25 04:45:04 aydt Exp $
 */

#include "PolarWrapper.h"

extern "C" {
#include "Polar.h"
}

#include <Xm/Xm.h>
#include <Xm/Form.h>    // For widget class name definition
#include <Xm/Label.h>   // For Polar widget labelling

#include "XArgs.h"
#include "util.h"

PolarWrapper::PolarWrapper( WidgetBase *par,
			         PolarPlotFU *polarFUPtr,
				 const XArgs & args,
				 const CString & name ) : PerfWidget( par )
{
    	_setType("PolarWrapper");

	// Create the Motif FORM 
    	widget = XtCreateManagedWidget( name.getValue(), xmFormWidgetClass,
			         par->getWidget(),
			         args.getArgs(), args.getNArgs() );
	Arg arg;
	XtSetArg( arg, XmNfractionBase, (XtArgVal)10000 );
	XtSetValues( widget, &arg, 1 );

	// Create a single Polar widget to be the child
	childList = new Widget[1];
	childList[0] = XtCreateManagedWidget( "PolarChild",
                                               polarWidgetClass,
                                               widget, NULL, 0 );
        
        // Create Min/Max Label & other labels
	labels.createMinMaxLabel( widget, "PolarMinMaxLabel" );
	setPolarLabel( L_LEFT_VERT, NULLCHARSTRING );
	setPolarLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

	addCallback( childList[0], XtNselect, &Callback::callback1,
		     this, NULL );
	polarFUthisPtr = polarFUPtr;
}


PolarWrapper::~PolarWrapper()
{
}


void 
PolarWrapper::callback1( Widget /* callbackWidget */, XtPointer /* ptr1 */,
			 XtPointer /* ptr2 */ )
{   
  int nearestXValue, nearestYValue;
  int index;

  PolarGetNearestPoint( (PolarWidget) childList[0], &nearestXValue, 
			&nearestYValue, &index );
  if (index >= 0) {
     polarFUthisPtr->fuCallback( nearestXValue, nearestYValue );
  }
}



void 
PolarWrapper::findPolarFormPosition(
              int *polarLayoutXOrg, int *polarLayoutYOrg,
	      int *polarWidthProportion, int *polarHeightProportion )
{
  int iFractionBase;
  getPolarFormAttr( XmNfractionBase, (XtArgVal) &iFractionBase );
  *polarLayoutYOrg = labels.getLabelHeight(L_TOP_HORIZ);
 
  if (labels.isALabel(L_LEFT_VERT)) {
      *polarWidthProportion = (int)(iFractionBase -
                                  2*labels.getLabelHeight(L_LEFT_VERT));
      *polarLayoutXOrg = labels.getLabelHeight(L_LEFT_VERT);
  } else {
      *polarWidthProportion = iFractionBase;
      *polarLayoutXOrg = 0;
  }
  if (labels.isALabel(L_BOTTOM_HORIZ)) {
      *polarHeightProportion = (int)(iFractionBase -
                               labels.getLabelHeight(L_BOTTOM_HORIZ) -
                               labels.getLabelHeight(L_TOP_HORIZ) );
  } else {
      *polarHeightProportion = 
                   (int)(iFractionBase-labels.getLabelHeight(L_TOP_HORIZ));
  }
}


void PolarWrapper::getPolarAttr( String name, XtArgVal value )
{
     Arg arg[1];
 
     XtSetArg( arg[0], name, value );
     XtGetValues( childList[0], arg, 1 );
}

void PolarWrapper::getPolarFormAttr( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtGetValues( widget, arglist, 1 );
}

      
void PolarWrapper::getPolarLabel( int whichLabel,
				  const char **aLabel ) const
{   
       labels.getLabel( whichLabel, aLabel );
}



void PolarWrapper::setPolarAttr(  String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtGetValues( widget, arglist, 1 );
}


void PolarWrapper::setPolarLabel( double fuMin, double fuMax )
{
       labels.setLabel( fuMin, fuMax );
}



void PolarWrapper::setPolarLabel( int whichLabel, const char *stringLabel )
{
        Boolean_ layoutChange;
        if ( whichLabel == L_LEFT_VERT ) {   
            layoutChange = labels.setLabel( widget, "PolarLabelVert",
					    whichLabel, stringLabel );
     	} else if ( whichLabel == L_BOTTOM_HORIZ ) {
            layoutChange = labels.setLabel( widget, "PolarLabelHoriz",
					    whichLabel, stringLabel );
     	}
        if (layoutChange) {
            int polarLayoutXOrg, polarLayoutYOrg,
                polarWidthProportion, polarHeightProportion;
            findPolarFormPosition(&polarLayoutXOrg, &polarLayoutYOrg,
			      &polarWidthProportion, &polarHeightProportion);
            setPolarFormPosition( polarLayoutXOrg, polarLayoutYOrg,
				polarWidthProportion, polarHeightProportion);
        }


}
           
 
void 
PolarWrapper::setDisplayValues( int valueCount, int *xvalues, int *yvalues )
{
	PolarSetValues( (PolarWidget)childList[0], valueCount, xvalues, 
			yvalues );
}

void
PolarWrapper::setPolarFormPosition(int polarLayoutXOrg, int polarLayoutYOrg,
                         int polarWidthProportion, int polarHeightProportion)
{
       Arg arglist[4];
       int i = 0;
       
       XtSetArg( arglist[i], XmNleftPosition, (XtArgVal)polarLayoutXOrg); i++;
       XtSetArg( arglist[i], XmNrightPosition, 
                    (XtArgVal)(polarLayoutXOrg+polarWidthProportion)); i++;
       XtSetArg( arglist[i], XmNtopPosition, (XtArgVal)polarLayoutYOrg); i++;
       XtSetArg( arglist[i], XmNbottomPosition,
                   (XtArgVal)polarLayoutYOrg+polarHeightProportion); i++;
       XtSetValues( childList[0], arglist, i );
}


/* 
 *      Initialize the static data.   Only executed once.
 */
const char *const PolarWrapper::MY_CLASS = "PolarWrapper";
