/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Scatter3DWrapper.cc:  Class wrapper for the 3D scatter plot
  *			  performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/Scatter3DWrapper.C,v 1.14 1994/02/25 04:44:43 aydt Exp $
 */

#include "Scatter3DWrapper.h"

extern "C" {
#include "Scatter3D.h"
}

#include <Xm/Xm.h>
#include <Xm/Form.h>	// Form widget class name definition
#include <Xm/Label.h>   // For Matrix widget labelling

#include "XArgs.h"
#include "util.h"


Scatter3DWrapper::Scatter3DWrapper( WidgetBase *par,
				 const XArgs & args,
				 const CString & name ) : PerfWidget( par )
{
    	_setType("Scatter3DWrapper");

	// Create the Motif FORM
    	widget = XtCreateManagedWidget( name.getValue(),
				        xmFormWidgetClass,
				        par->getWidget(),
			         args.getArgs(), args.getNArgs() );
	Arg arg;
	XtSetArg( arg, XmNfractionBase, (XtArgVal)10000 );
	XtSetValues( widget, &arg, 1 );
	
	// Create a single Scatter3D widget to be the child
	childList = new Widget[1];
	childList[0] = XtCreateManagedWidget( "scatter3DChild",
					      scatter3DWidgetClass,
					      widget, NULL, 0 );
	
	// Create the labels
	Pixel backgroundColor;
	XtVaGetValues( widget,
		       XtNbackground, &backgroundColor,
		          NULL );
	Pixel labelColor;
	XtVaGetValues( childList[0],
		       XtNaxisXColor, &labelColor,
		         NULL );
        xLabel = XtVaCreateManagedWidget( "scatter3DLabelX",
					  xmLabelWidgetClass,
					  widget, 
					  XmNbackground, backgroundColor,
					  XmNforeground, labelColor,
					      NULL );
	XtVaGetValues( childList[0],
		       XtNaxisYColor, &labelColor,
		         NULL );
	yLabel = XtVaCreateManagedWidget( "scatter3DLabelY",
					  xmLabelWidgetClass,
					  widget, 
					  XmNbackground, backgroundColor,
					  XmNforeground, labelColor,
					      NULL);
	XtVaGetValues( childList[0],
		       XtNaxisZColor, &labelColor,
		         NULL );
	zLabel = XtVaCreateManagedWidget( "scatter3DLabelZ",
					  xmLabelWidgetClass,
					  widget,
					  XmNbackground, backgroundColor,
					  XmNforeground, labelColor,
					      NULL );
	_alignDataArea();
}


Scatter3DWrapper::~Scatter3DWrapper()
{
}



void Scatter3DWrapper::_alignDataArea()
{ 
     XmString labelString;
     char *xString, *yString, *zString;
     Boolean labelsExist = False;

     XtVaGetValues( xLabel,
		    XmNlabelString, &labelString,
		        NULL );
     XmStringGetLtoR( labelString, XmSTRING_DEFAULT_CHARSET, &xString );

     if ( strlen(xString) == 0 ) {
         XtVaGetValues( yLabel,
		        XmNlabelString, &labelString,
		           NULL );
         XmStringGetLtoR( labelString, XmSTRING_DEFAULT_CHARSET, &yString );

	 if ( strlen(yString) == 0 ) {
             XtVaGetValues( zLabel,
		            XmNlabelString, &labelString,
		                NULL );
             XmStringGetLtoR( labelString, XmSTRING_DEFAULT_CHARSET, &zString);
	     if ( strlen(zString) == 0 ) {
                XtVaSetValues( childList[0],
			       XmNbottomPosition, 10000,
			          NULL );
	     } else {
                labelsExist = True;
	     }
	 } else {
             labelsExist = True;
	 }
     } else {
         labelsExist = True;
     }

     if ( labelsExist ) {
	  int scatterBorder;
          XtVaGetValues( xLabel,
	                 XmNtopPosition, &scatterBorder,
			   NULL );
          XtVaSetValues( childList[0],
			 XmNbottomPosition, scatterBorder,
			   NULL );
     }	      
}


void 
Scatter3DWrapper::getScatterLabel( int whichLabel, char **aLabel ) const
{   
     XmString labelString;
     if ( whichLabel == L_X ) {
          XtVaGetValues( xLabel,
		         XmNlabelString, &labelString,
		         NULL );
     } else if ( whichLabel == L_Y ) {
          XtVaGetValues( yLabel,
		         XmNlabelString, &labelString,
		         NULL );
     } else if ( whichLabel == L_Z ) {
          XtVaGetValues( zLabel,
		         XmNlabelString, &labelString,
	         	 NULL );
     }
     XmStringGetLtoR( labelString, XmSTRING_DEFAULT_CHARSET, aLabel );
}


void Scatter3DWrapper::setScatterLabel( int whichLabel, const char *stringLabel)
{
     static int labelXsize = 0, labelYsize = 0, labelZsize = 0;
     static Boolean isLabelSpaceAllocated = False;

     XmString labelString = XmStringCreateLtoR( (char *)stringLabel,
					        XmSTRING_DEFAULT_CHARSET );

     if (whichLabel == L_X) {
       XtVaSetValues( xLabel,
		        XmNlabelString, labelString,
		           NULL );
     } else if (whichLabel == L_Y) {
         XtVaSetValues( yLabel,
		        XmNlabelString, labelString,
		           NULL );
     } else if (whichLabel == L_Z) {   
         XtVaSetValues( zLabel,
		        XmNlabelString, labelString,
		           NULL );
     }
     XmStringFree ( labelString );

     _alignDataArea();
}

     
void Scatter3DWrapper::getScatterAttr( String name, XtArgVal value )
{
     Arg arg[1];
 
     XtSetArg( arg[0], name, value );
     XtGetValues( childList[0], arg, 1 );
}


void Scatter3DWrapper::setScatterAttr( String name, XtArgVal value )
{
   Arg arg[1];

   XtSetArg( arg[0], name, value );
   XtSetValues( childList[0], arg, 1 );
}


void Scatter3DWrapper::setPerfWidgetValues( int *xValues, int *yValues,
					 int *zValues, int pointCount,
					 int setNumber )
{
	Scatter3DSetValues( (Scatter3DWidget) childList[0],
			    pointCount, setNumber,
			    xValues, yValues, zValues );
}

void Scatter3DWrapper::setPerfWidgetColors()
{
        colorTable.gencolor( getDisplay(), getScreen() );
	Scatter3DSetColors( (Scatter3DWidget) childList[0],
			    colorTable.getNumColors(),
			    colorTable.getColormapEntries() );
}

