/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */



#ifndef ScatterPlotMatrixFormWrapper_h
#define ScatterPlotMatrixFormWrapper_h

#include <math.h>
#include <X11/cursorfont.h>
#include <Xm/Separator.h>    
class MultivariateWidgetWrapper;

#include "Callback.h"
#include "EventHandler.h"
#include "DisplayColorTables.h"  /* Maintains widget color table information */
#include "LabelUtilities.h"      /* Motif label utilities */

extern "C" {
#include "Matrix.h"
#include "XYGraph.h"
}
#include "ScatterPlotMatrixFU.h"

extern "C" {
#include "BoxAndWhisker.h"
}


#define NONEXISTENT_INDEX         -1

typedef enum { NULL_EDITMODE, VIEW_MODE, SPRAY_MODE, PRUNE_MODE } SPMEditMode;
typedef enum { NULL_DISPMODE, DISPLAY_DENSITY } SPMDisplayMode;


typedef int SPMPreferencesMask;

typedef struct {
       XFontStruct *labelFont;
} SPMResourceList;

typedef struct {
       Widget pointSetName;
       Widget pointCount;
} SPMStatusInformation;

 

class ScatterPlotMatrixFormWrapper : public MultivariateWidgetWrapper, 
                                     public virtual Callback,
				     public virtual EventHandler
{
/*
*
* A ScatterPlotMatrixFormWrapper is tbe C++ wrapper for the ScatterPlotMatrix
*    display widget.  (Note that a "SPM" widget doesn't really exist).
*
*/

private:
        Widget spmMainWindow, dataForm, xLabelForm, yLabelForm, statusForm,
	       snapshotDialog;
	LabelUtilities labelUtilities;
	DisplayColorTables lineColorTable, brushColorTable, densityColorTable;
        VoidPtrList *plotMatrixChildren;
	VoidPtrList plotMatrixXLabels, plotMatrixYLabels;
	ScatterPlotMatrixFU *SPMFUthisPtr;
	
	SPMResourceList spmResourceList;
	SPMWidgetTypeEntry spmWidgetEntry;
	SPMPreferencesMask preferencesMask;
	SPMStatusInformation statusInformation;
	SPMClusteringOptions clusteringOptions;
	int dim;

	Widget callbackMainWindow1D, callbackMainWindow2D;
        Widget functionRadioBox, colorChoiceRadioBox;

	int currentCallbackColor;
	int currentViewingPoint;
	IntList viewingPointOldColors;

protected:
	/* Method _activatePointerTracking():  Register event handlers to
	                               track pointer motion (brush mode) */
	void _activatePointerTracking( SPMEditMode *spmEditMode );

	/* Method _addNewSPMWidget():  Create a new SPM child widget of the
	                               appropriate kind */
	Widget _addNewSPMWidget( int i, int j );

	/* Method _colorPointAcrossMatrix:  Brush a point in all children
	                                    of the matrix */
	void _colorPointAcrossMatrix( int pointIndex );

	
	/* Method _create1DCallbackWindow:  Create all the widgets associated
	                           with the Box&Whisker callback interface */
	Widget _create1DCallbackWindow(Callback1DTextWidgetSet& textWidgetSet);

	/* Method _create2DCallbackWindow:  Create all the widgets associated
	                                  with the SPM callback interface */
	Widget _create2DCallbackWindow();

	/* Method _createClusterSheet : Create all the widgets associated
	        with the cluster option sheet */
	Widget _createClusterSheet();

        /* Method _createColorChooser:  Create all the widgets associated
	        with the SPM color chooser */
	void _createColorChooser( Widget parentWidget );

	/* Method _createFunctionSetup:  Create all the widgets associated
	  with the function options for modes in the SPM callback */
	void _createFunctionSetup( Widget parentWidget );

	/* Method _createModeSetup:  Create all the widgets associated with
	        SPM callback modes */
	void _createModeSetup( Widget parentWidget );

	/* Method _createPointDisplaySetup:  Create all the widgets 
	        associated with the point display options */
	void _createPointDisplaySetup( Widget parentWidget );

	/* Method _createPreferenceSheet:  Create all the widgets associated
                with the SPM preference sheet */
	Widget  _createPreferenceSheet();

	/* Method _deactivatePointerTracking():  Turn off pointer tracking
	                                (brush mode) */
	void _deactivatePointerTracking( SPMEditMode *spmEditMode );

        /* Method _entryToClassName():  Determine the widget class name to be
	  used based on the widget entry from FU config */
	WidgetClass _entryToClassName( SPMWidgetTypeEntry spmWidgetEntry );

	/* Method _prunePointAcrossMatrix():  Delete knowledge of a 
	                     particular point from all of the data widgets */
	void _prunePointAcrossMatrix( int pointIndex );

	/* Method _rotateYLabel:  Rotate a label string 90-degrees counter-
	              clockwise */
	Pixmap _rotateYLabel(  XmString labelString, XmFontList fontList );

	/* Method _setSPMDataWidgets():  Create the widgets associated with
	              SPM data entries */
	void _setSPMDataWidgets( int dimension );
	void _unsetSPMDataWidgets( int dimension );
	
	/* Method _setSPMLabelWidgets():  Create the widgets associated with
                      SPM labels */
	void _setSPMLabelWidgets( int dimension );

	/* Method _setupInteractionArea():  Create widgets associated with
	              the interactive portion of the main display */
	void _setupInteractionArea( Widget parentWidget );

	/* Method _setupStatusArea():  Create widgets associated with the
	              status area portion of the main display */
	int _setupStatusArea( Widget parentWidget );

	/* Method _updateFormOffsets(): Adjust form offset values based on
	              the dimension of external labels being used */
	void _updateFormOffsets();
	void _updateFormOffsets( XmFontList fontList, XmString labelString );

	/* Method _viewPointAcrossMatrix():  Examine a particular data point
                      in all of the data plots */
	void _viewPointAcrossMatrix( int pointIndex );

public:
	/* Method ScatterPlotMatrixFormWrapper: 
	                   the ScatterPlotMatrixFormWrapper constructor  */
	ScatterPlotMatrixFormWrapper( Widget SPMparent,
			      ScatterPlotMatrixFU *scatterPlotMatrixFUPtr );

	/* Method ~ScatterPlotMatrixFormWrapper: 
	                    the ScatterPlotMatrixFormWrapper destructor  */
	~ScatterPlotMatrixFormWrapper();

	/* Method callback1:  Handle the SPM main callback */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method callback2:  Mode activation callback */
	virtual void callback2( Widget, XtPointer, XtPointer );

	/* Method callback3:  Handle the dismiss-callback function */
	virtual void callback3( Widget, XtPointer, XtPointer );

	/* Method callback4:  Handle activation of spray mode */
	virtual void callback4( Widget, XtPointer, XtPointer );

	/* Method callback5:  Handle color selection */
	virtual void callback5( Widget, XtPointer, XtPointer );

	/* Method callback6:  Handle activation of view mode */
	virtual void callback6( Widget, XtPointer, XtPointer );

	/* Method callback7:  Handle interactive push button options */
	virtual void callback7( Widget, XtPointer, XtPointer );

	/* Method callback8:  Handle preference changes */
	virtual void callback8( Widget, XtPointer, XtPointer );

	/* Method callback9:  Handle popup window dismiss */
	virtual void callback9( Widget, XtPointer, XtPointer );

	/* Method eventHandler1:  Monitor pointer motion (spray mode) */
	virtual void eventHandler1( Widget, XtPointer, XEvent *, Boolean *);

	/* Method getCategoryLabel: Retrieve a category label for  the given
	                            dimension of the matrix */
	char * getCategoryLabel( int theDimension );

	/* Method getClusteringInterval:  Return the point count interval
	                                  between clusterings */
	int getClusteringInterval();

	/* Method getPerfWidgetPosition:  Retrieve position and size 
	                 information for the scatterplot matrix main window */
	void getPerfWidgetPosition( int& x, int& y, int& width, int& height );

	/* Method getPointSetName:  Retrieve the dataset name label */
        char * getPointSetName();
 
	/* Method getSPMAttr:  Retrieve resource information from the SPM */
	void getSPMAttr( int dimension, String name, XtArgVal value );

	/* Method getWidgetConnectOption:  Retrieve default connect information
	                             for the widget being used */
	void getWidgetConnectOption( int& connectOption );

	/* Method getWidgetMinMaxInfo:  Retrieve widget min/max info for the
	                                widget type being used */
	void getWidgetMinMaxInfo(int& wMinX,int& wMaxX,int& wMinY,int& wMaxY);

	/* Method getWidgetTicks:  Retrieve default tick-value information
	                           for the widget being used */
	void getWidgetTicks( int& xticks, int& yticks );

	/* Method isClusteringEnabled:  Return True if clustering has
	                                been enabled by the user else False */
	Boolean isClusteringEnabled();

	/* Method realize:  Bring up the SPM main window */
	void realize();

	/* Method setCategoryLabel: Set label strings for each dimension
	                             of the matrix */
	void setCategoryLabel( XmString categoryLabelString, int theDimension);
	void setCategoryLabel( const char *categoryLabel, int theDimension );
	
	/* Method setConnectOption:  Set the connect option for child
	                             widgets of the SPM */
	void setConnectOption( Boolean connectOption );

	/* Method setDimension:  Fix the dimension of data which the SPM is
	                         to show */
	void setDimension( int dimension );

	/* Method setPerfWidgetColors: Initialize the color table for all
	      scatterplot widgets */
	void setPerfWidgetColors();

	/* Method setPointCount:  Set a label showing the current number
	                          of points being displayed */
	void setPointCount( int numPoints );

	/* Method setPointSetName:  Set a label describing the current
	      point set */
	void setPointSetName( char *name );

	/* Method setSPMAttr:  Set a widget attribute for the scatterplot
	      matrix main window */
	void setSPMAttr( int x, int y, int width, int height );
	void setSPM2DAttr( String name, XtArgVal value );

	/* Method setSPMValues: Set data values within the SPM */
	void setSPMValues(int *nDimDataPoints, int *lineIndices,
			  int lineCount, int pointCount );
	void setSPMValues(int *nDimDataPoints, int lineCount, int pointCount,
			  int *pointsPerLine);
	void setSPMValues(int *dataPoint );

	/* Method setType:  Fix which 2-D display widget is going to be used
	                    by the SPM */
	void setType( int widgetEntry );
};

#endif
