/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/bargraph/Demo/RCS/bitmaps.h,v 1.6 1994/02/25 04:45:19 aydt Exp $
 */

#define BITMAPWIDTH	16
#define BITMAPHEIGHT	16
#define BITMAPNUM	8

extern Pixmap	pixmaps[BITMAPNUM];

char bitmaps [] [32] = {
   {0x55, 0x55, 0x88, 0x88, 0x55, 0x55,		/* crossweave	*/
    0x22, 0x22, 0x55, 0x55, 0x88, 0x88,
    0x55, 0x55, 0x22, 0x22, 0x55, 0x55,
    0x88, 0x88, 0x55, 0x55, 0x22, 0x22,
    0x55, 0x55, 0x88, 0x88, 0x55, 0x55, 0x22, 0x22},

   {0xee, 0xee, 0x55, 0x55, 0xba, 0xbb,		/* stipple	*/
    0x55, 0x55, 0xee, 0xee, 0x55, 0x55,
    0xba, 0xbb, 0x55, 0x55, 0xee, 0xee,
    0x55, 0x55, 0xba, 0xbb, 0x55, 0x55,
    0xee, 0xee, 0x55, 0x55, 0xba, 0xfb, 0x55, 0x55},

   {0x0f, 0x0f, 0x09, 0x09, 0x09, 0x09,		/* boxes	*/
    0x0f, 0x0f, 0xf0, 0xf0, 0x90, 0x90,
    0x90, 0x90, 0xf0, 0xf0, 0x0f, 0x0f,
    0x09, 0x09, 0x09, 0x09, 0x0f, 0x0f,
    0xf0, 0xf0, 0x90, 0x90, 0x90, 0x90, 0xf0, 0xf0},

   {0x55, 0x55, 0x00, 0x00, 0x55, 0x55,		/* dimple	*/
    0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
    0x55, 0x55, 0x00, 0x00, 0x55, 0x55,
    0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
    0x55, 0x55, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00},

   {0x00, 0x00, 0x80, 0x00, 0x80, 0x00,		/* star		*/
    0x88, 0x08, 0x90, 0x04, 0xa0, 0x02,
    0x40, 0x01, 0x3e, 0x3e, 0x40, 0x01,
    0xa0, 0x02, 0x90, 0x04, 0x88, 0x08,
    0x80, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},

   {0x11, 0x11, 0xb8, 0xb8, 0x7c, 0x7c,		/* wide weave	*/
    0x3a, 0x3a, 0x11, 0x11, 0xa3, 0xa3,
    0xc7, 0xc7, 0x8b, 0x8b, 0x11, 0x11,
    0xb8, 0xb8, 0x7c, 0x7c, 0x3a, 0x3a,
    0x11, 0x11, 0xa3, 0xa3, 0xc7, 0xc7, 0x8b, 0x8b},

   {0x10, 0x10, 0x10, 0x10, 0x28, 0x28,		/* scales	*/
    0xc7, 0xc7, 0x01, 0x01, 0x01, 0x01,
    0x82, 0x82, 0x7c, 0x7c, 0x10, 0x10,
    0x10, 0x10, 0x28, 0x28, 0xc7, 0xc7,
    0x01, 0x01, 0x01, 0x01, 0x82, 0x82, 0x7c, 0x7c},

   {0x0f, 0x80, 0x1e, 0x80, 0x3c, 0x40,		/* X logo	*/
    0x78, 0x20, 0x78, 0x10, 0xf0, 0x08,
    0xe0, 0x09, 0xc0, 0x05, 0xc0, 0x02,
    0x40, 0x07, 0x20, 0x0f, 0x20, 0x1e,
    0x10, 0x1e, 0x08, 0x3c, 0x04, 0x78, 0x02, 0xf0}
};
