/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/bargraph/Demo/RCS/multibargraph.c,v 1.5 1994/02/25 04:45:24 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "Bargraph.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define VPADDING		2	/* vertical padding		*/
#define PERCENT_HPADDING	0.2	/* percent horizontal padding	*/

void multibargraph(formW, n, min, max, select,
		   pixmaps, colors, bargraphs)
Widget	formW;			/* form widget				*/
int	n;			/* number of bargraphs desired		*/
int	min, max;		/* min and max bargraph values		*/
XtCallbackRec *select;		/* select callback			*/
Pixmap	*pixmaps;		/* pixmap array				*/
Pixel	*colors;		/* color array				*/
Widget	*bargraphs;		/* bargraph widgets			*/
{
  int	i, argi, save_argi;
  int	padding, width, height, form_width, form_height;
  Arg	arglist[20];

  argi = 0;
  SetArg(XtNwidth, 0);
  SetArg(XtNheight, 0);
  XtGetValues(formW, arglist, 2);
  form_width = (int) arglist[0].value;
  form_height = (int) arglist[1].value;
  padding = (PERCENT_HPADDING * (float) form_width) / (float) (n+1);
  width = (form_width - (n+1)*padding) / n;
  height = form_height - 2*VPADDING;

  argi = 0;
  SetArg(XtNtitle, "Bargraph");
  SetArg(XtNwidth, width);
  SetArg(XtNheight, height);
  SetArg(XtNorientation, XtorientVertical);
  SetArg(XtNselect, select);
  SetArg(XtNborderWidth, 1);
  SetArg(XtNminValue, min);
  SetArg(XtNmaxValue, max);
  SetArg(XtNtop, XtChainTop);
  SetArg(XtNbottom, XtChainBottom);
  SetArg(XtNleft, XtRubber);
  SetArg(XtNright, XtRubber);
  save_argi = argi;

  for (i=0; i<n; i++) {
    argi = save_argi;
    if (pixmaps != NULL) {
      SetArg(XtNfillPixmap, pixmaps[i]);
    }
    else {
      SetArg(XtNfillColor, colors[i]);
    }
    SetArg(XtNfromVert, NULL);
    SetArg(XtNvertDistance, VPADDING);
    SetArg(XtNfromHoriz, NULL);
    SetArg(XtNhorizDistance, i*width + (i+1)*padding);
    bargraphs[i] = XtCreateManagedWidget("bargraph", bargraphWidgetClass,
					 formW, arglist, argi);
  }

} /* multibargraphpixmap */

void bargraph_graph(formW, n, min, minW, max, maxW, title, titleW,
		    select, pixmaps, colors, bargraphs)
Widget	formW;			/* form widget				*/
int	n;			/* number of bargraphs desired		*/
int	min, max;		/* min and max bargraph values		*/
char	*title;			/* title string				*/
Widget	*minW, *maxW, *titleW;	/* min, max, and title text widget	*/
XtCallbackRec *select;		/* select callback			*/
Pixmap	*pixmaps;		/* pixmap array				*/
Pixel	*colors;		/* color array				*/
Widget	*bargraphs;		/* bargraph widgets			*/
{
  char		string[100];
  int		i, argi, form_width, form_height, text_height;
  Arg		arglist[20];
  Widget	graphW;

  /* find container form height */
  argi = 0;
  SetArg(XtNwidth, 0);
  SetArg(XtNheight, 0);
  XtGetValues(formW, arglist, argi);
  form_width = (int) arglist[0].value;
  form_height = (int) arglist[1].value;

  /* create maximum value text */
  sprintf(string, "%d", max);
  argi = 0;
  SetArg(XtNlabel, string);
  SetArg(XtNborderWidth, 0);
  SetArg(XtNfromVert, NULL);
  SetArg(XtNvertDistance, VPADDING);
  SetArg(XtNfromHoriz, NULL);
  SetArg(XtNhorizDistance, 4);
  SetArg(XtNleft, XtChainLeft);
  SetArg(XtNright, XtChainLeft);
  SetArg(XtNtop, XtChainTop);
  SetArg(XtNbottom, XtChainTop);
  *maxW = XtCreateManagedWidget("", labelWidgetClass, formW,
				arglist, argi);
  
  /* find text height */
  argi = 0;
  SetArg(XtNheight, 0);
  XtGetValues(*maxW, arglist, argi);
  text_height = (int) arglist[0].value;

  /* create title text */
  argi = 0;
  SetArg(XtNlabel, title);
  SetArg(XtNborderWidth, 0);
  SetArg(XtNfromVert, NULL);
  SetArg(XtNvertDistance, VPADDING);
  SetArg(XtNfromHoriz, NULL);
  SetArg(XtNhorizDistance, 0);
  SetArg(XtNwidth, form_width);
  SetArg(XtNleft, XtChainLeft);
  SetArg(XtNright, XtChainRight);
  SetArg(XtNtop, XtChainTop);
  SetArg(XtNbottom, XtChainTop);
  *titleW = XtCreateManagedWidget("", labelWidgetClass, formW,
				  arglist, argi);
  
  /* create bargraph form */
  argi = 0;
  SetArg(XtNborderWidth, 0);
  SetArg(XtNwidth, form_width);
  SetArg(XtNheight, form_height - 2*text_height - 4*VPADDING);
  SetArg(XtNdefaultDistance, 0);
  SetArg(XtNfromVert, *maxW);
  SetArg(XtNvertDistance, VPADDING);
  SetArg(XtNfromHoriz, NULL);
  SetArg(XtNhorizDistance, 0);
  SetArg(XtNleft, XtChainLeft);
  SetArg(XtNright, XtChainRight);
  SetArg(XtNtop, XtChainTop);
  SetArg(XtNbottom, XtChainBottom);
  graphW = XtCreateManagedWidget("", formWidgetClass, formW,
				 arglist, argi);

  /* create minimum value text */
  sprintf(string, "%d", min);
  argi = 0;
  SetArg(XtNlabel, string);
  SetArg(XtNborderWidth, 0);
  SetArg(XtNfromVert, graphW);
  SetArg(XtNvertDistance, VPADDING);
  SetArg(XtNfromHoriz, NULL);
  SetArg(XtNhorizDistance, 4);
  SetArg(XtNleft, XtChainLeft);
  SetArg(XtNright, XtChainLeft);
  SetArg(XtNtop, XtChainBottom);
  SetArg(XtNbottom, XtChainBottom);
  *minW = XtCreateManagedWidget("", labelWidgetClass, formW,
				arglist, argi);
  
  if (pixmaps != NULL)
    multibargraph(graphW, n, min, max, select,
		  pixmaps, NULL, bargraphs);
  else
    multibargraph(graphW, n, min, max, select,
		  NULL, colors, bargraphs);

} /* bargraph_graph */
