.TH "Bargraph" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Bargraph \- A bargraph widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNminValue:int:0:minimum value
XtNmaxValue:int:100:maximum value
XtNorientation:XtOrientation:vertical:bargraph orientation
XtNfillColor:Pixel:"black":fill color
XtNfillPixmap:Pixmap:None:fill pixmap
XtNstickyHold:int:5:sticky level hold interval
XtNstickyColor:Pixel:"black":sticky mark color
XtNvalue:int:0:bargraph value (minvalue - maxvalue)
XtNselect:XtCallbackList:NULL:callbacks for bargraph selection
.TE
.sp
XtOrientation: vertical, horizontal
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records current bargraph value
notify:invokes the bargraph select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBBargraphSetValue\fR(w, v)
BargraphWidget w;
int v;
.fi
.sp
BargraphSetValue() sets the current value of the bargraph to v.
The bargraph display is automatically updated.
.sp
.nf
void \fBBargraphSetColor\fR(w, c)
BargraphWidget w;
Pixel c;
.fi
.sp
BargraphSetColor() sets the fill color of the bargraph to c.
.sp
.nf
void \fBBargraphSetPixmap\fR(w, p)
BargraphWidget w;
Pixmap p;
.fi
.sp
BargraphSetPixmap() sets the fill pixmap of the bargraph to p.
.ne 4
.SH DESCRIPTION
.br
The \fBBargraph\fR widget manages a rectangular bargraph display
in a horizontal or vertical orientation.
A fraction of the total bargraph region is filled,
either with a color or a pixmap, depending on the current bargraph
value.
The user sets the minimum and maximum values the bargraph will show.
Bargraph values must be in this range.
.PP
The most recent highest value can be made to "stick" for a specified
period of updates given by the sticky hold resource.
If the sticky hold resource is -1, no sticky value is shown.
If the sticky hold resource is 0 or greater, the sticky value will be
drawn in the sticky value color.
.PP
Clicking the left mouse button on a bargraph invokes a callback function
with the current value of the bargraph. 
.ne 4
.SH FUTURE ENHANCEMENTS
.br
Two callbacks may be supported in the future.
Clicking the middle mouse button will return value in the bargraph
range closest to the mouse position.
Clicking the right mouse button will set the bargraph value to that
value closest to the mouse position and call any registered callbacks.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
