.TH "Bubble" "3-PerfW" "Feb 18, 1991" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Bubble \- A bubble widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNcolors:Pixel*:NULL:fill colors
XtNcolumns:int:0:number of columns
XtNgridColor:Pixel:"black":grid color
XtNmaxValue:int:100:maximum array value
XtNminValue:int:0:minimum array value
XtNnumColors:int:0:number of fill colors
XtNnumPixmaps:int:0:number of fill pixmaps
XtNpixmaps:Pixmap*:NULL:fill pixmaps
XtNrows:int:0:number of rows
XtNselect:XtCallbackList:NULL:callback for bubble selection
XtNshowGrid:Boolean:TRUE:show bubble grid
XtNvalues:float*:NULL:bubble values
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records row and column for selected cell
notify:invokes the bubble select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBBubbleSetValues\fR(w, rows, columns, v)
BubbleWidget w;	/* bubble widget */
int rows;	/* number of rows */
int columns;	/* number of columns */
int *v;	/* two-dimensional array of values */
	/* minvalue <= v[][] <= maxvalue */
.fi
.sp
BubbleSetValues() set the values array to v.
The bubble display is automatically updated.
.sp
.nf
void \fBBubbleSetValue\fR(w, r, c, v)
BubbleWidget w;	/* bubble widget */
int r;	/* row */
int c;	/* column */
int v;	/* minvalue <= v <= maxvalue */
.fi
.sp
BubbleSetValue() set the value of the bubble element
at row r and column c to v.
The bubble display is automatically updated.
.sp
.nf
void \fBBubbleSetColors\fR(w, n, c)
BubbleWidget w;	/* bubble widget */
int n;	/* number of colors */
Pixel *c;	/* array of colors */
.fi
.sp
BubbleSetColor() sets the number of fill colors
to n and the fill colors to the first n in c[].
.sp
.nf
void \fBBubbleSetPixmap\fR(w, n, p)
BubbleWidget w;
int n;
Pixmap *p;
.fi
.sp
BubbleSetPixmap() sets the number of fill pixmaps
to n and the fill pixmaps to the first n in p[].
.sp
.nf
void \fBBubbleGetRowCol\fR(w, row, col)
BubbleWidget w;
int *row, *col;
.fi
.sp
BubbleGetRowCol() returns the row (0 to rows-1)
and column (0 to columns-1) values of
the last bubble element selected.
.ne 4
.SH DESCRIPTION
.br
The \fBBubble\fR widget manages a rectangular bubble display
of the specified number of rows and columns; a maximum of 200 rows and
200 columns are possible.
The bubble display shows values from an array of values of the
same dimensions.
The user sets the minimum and maximum values the bubble will show.
Bubble values must be in this range.
The array values are linearly mapped to a color (pixmap) table and the
corresponding bubble element is shown filled by with the mapped
color (pixmap).
The size of each bubble also represents the magnitude of the corresponding
data value.
A bounding circle is drawn around each bubble element, if enabled.
.PP
Bubble element selection is supported throught the XtNselect callback
resource.
Although the user-supplied callback routine is returned the
XButtonReleasedEvent as the call_data part,
usually the row and column values of the selected bubble element
will be desired.
The method BubbleGetRowCol() is provided for this purpose.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
Additional callbacks may be provided in the future for region selection.
.ne 4
.SH AUTHOR
.br
.nf
Daniel A. Reed, \fIreed@cs.uiuc.edu\fR
Department of Computer Science
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
