/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Brian K. Totty (totty@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/chart/Demo/RCS/MultiChart.c,v 1.5 1994/02/25 04:45:38 aydt Exp $
 */

/*************************************************************

	chart.c

	This file contains some convenience code to access
	stripchart widgets.  It acts as a front end for
	the chart widgets.

**************************************************************/

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>

#include "Chart.h"
#include "MultiChart.h"

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

extern void exit();


/*-----------------------------------------------------------*

	Junk()

	This silliness causes the linker to include the
	VendorShell module from Xaw, rather than the one
	from Xt.

 *-----------------------------------------------------------*/

#ifndef lint
static Junk()
{
#include <X11/Vendor.h>
	WidgetClass junk = vendorShellWidgetClass;
}
#endif



/*---------------------------------------------------------------*

	ChartWidget CreateChart(name,parent)

	This routine creates a single chart widget named
	<name> when given tthe parent widget <parent>.

 *---------------------------------------------------------------*/

ChartWidget CreateChart(name,parent)
char *name;
Widget parent;
{
	Arg arg;
	Pixmap icon_pixmap = None;
	ChartWidget chart;

	XtSetArg(arg,XtNiconPixmap,&icon_pixmap);
	XtGetValues(parent,&arg,1);
	if (icon_pixmap == None)
	{
		arg.value = (XtArgVal)XCreateBitmapFromData(XtDisplay(parent),
			XtScreen(parent)->root,chart_bits,chart_width,
			chart_height);
		XtSetValues(parent,&arg,1);
	}
	chart = (ChartWidget)XtCreateManagedWidget(name,
		chartWidgetClass,parent,NULL,0);
	return(chart);
} /* End CreateChart */



/*---------------------------------------------------------------*

	MultiChart *CreateMultiChart(name,n,parent)

	This routine creates a new multichart with name <name>,
	<n> displays, and with parent <parent>.  If the chart
	cannot be created, NULL is returned.	

 *---------------------------------------------------------------*/

MultiChart *CreateMultiChart(name,n,parent)
char *name;
int n;
Widget parent;
{
	char title_buffer[129];
	MultiChart *multi;
	Arg arglist[10];
	int i,args;
	Widget w;
	int SoYouWantColorHuh = TRUE;

	if (n < 0 || n > MAX_CHARTS) return(NULL);
	multi = (MultiChart *)XtMalloc(sizeof(MultiChart));
	strcpy(multi->name,name);
	multi->n = n;
	multi->shellW = XtCreatePopupShell("MultiChart",
		topLevelShellWidgetClass,parent,arglist,0);
	multi->formW = XtCreateManagedWidget(multi->name,formWidgetClass,
		multi->shellW,arglist,0);
	w = NULL;
	for (i = 0; i < n; i++)
	{
		XtSetArg(arglist[0],XtNfromVert,w);
		XtSetArg(arglist[1],XtNvertDistance,5);
        	XtSetArg(arglist[2], XtNselect, selectcallback);
		if (n > 1)
		{
			sprintf(title_buffer,"%s %d\n",name,i+1);
			XtSetArg(arglist[3],"title",title_buffer);
		}
		    else
		{
			strcpy(title_buffer,name);
			XtSetArg(arglist[3],"title",title_buffer);
		}
		multi->charts[i] = XtCreateManagedWidget(multi->name,
			chartWidgetClass,multi->formW,arglist,4);
		w = multi->charts[i];
	}
	XtPopup(multi->shellW,XtGrabNone);
	if (SoYouWantColorHuh)
	{
		XrmValue from,to;

		for (i = 0; i < n; i++)
		{
			from.size = sizeof(char *);
			from.addr = (caddr_t) chartcolors[TEXTCOLOR];
			XtConvert(multi->charts[i], XtRString, &from, XtRPixel, &to);
			XtSetArg(arglist[0],XtNtext,to.addr);

			from.size = sizeof(char *);
			from.addr = (caddr_t) chartcolors[MARKERCOLOR];
			XtConvert(multi->charts[i], XtRString, &from, XtRPixel, &to);
			XtSetArg(arglist[1],XtNmarker,*((Pixel *)(to.addr)));

			from.size = sizeof(char *);
			from.addr = (caddr_t) chartcolors[DATACOLOR + i];
			XtConvert(multi->charts[i], XtRString, &from, XtRPixel, &to);
			XtSetArg(arglist[2],XtNdata,*((Pixel *)(to.addr)));

			XtSetValues(multi->charts[i],arglist,3);
		}
	}
	return(multi);
} /* End CreateMultiChart */



/*---------------------------------------------------------------*

	MultiChartAddValue(multi,n,value)

	This routine takes a pointer to a multichart
	<multi> and adds the value <value> to chart
	<n> in the multichart, where 0 is the first
	chart in the multichart.

 *---------------------------------------------------------------*/

MultiChartAddValue(multi,n,value)
MultiChart *multi;
int n;
unsigned int value;
{
	ChartAddValue(multi->charts[n],value);
} /* End MultiChartAddValue */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	value = (int) call_data;

  printf("Callback:  value %d\n", value);

} /* Select */
