/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Brian K. Totty (totty@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/chart/Demo/RCS/chartdemo.c,v 1.5 1994/02/25 04:45:42 aydt Exp $
 */

/*************************************************************

	multichart.c

	This is a driver program to start up a
	multichart stripchart display.  It takes
	a command line argument of number of displays.

**************************************************************/

#include <stdio.h>

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>

#define	DISPLAYS 4

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#include "Chart.h"
#include "MultiChart.h"

extern MultiChart *CreateMultiChart();
extern MultiChartAddValue();

extern void exit();

Syntax(call)
char *call;
{
  printf("Usage: %s\n", call);
  exit(1);

} /* Syntax */



/*-----------------------------------------------------------*

	Junk()

	This silliness causes the linker to include the
	VendorShell module from Xaw, rather than the one
	from Xt.

 *-----------------------------------------------------------*/

#ifndef lint
static Junk()
{
#include <X11/Vendor.h>
	WidgetClass junk = vendorShellWidgetClass;
}
#endif




/*-----------------------------------------------------------*

	main(argc,argv)

	This is the main entry point of the chart
	widget application program.

 *-----------------------------------------------------------*/

main(argc,argv)
int argc;
char **argv;
{
	MultiChart *multi;
	XEvent event;
	int i,count[MAX_CHARTS];
	Widget hyperW;
  	Arg	arglist[20];

	for (i = 0; i < DISPLAYS; i++)
           count[i] = 10 * (random() % DISPLAYS);

	   hyperW = XtInitialize("main","XChart",NULL,
		0,&argc,argv);

        if (argc != 1)
          Syntax(argv[0]);

	multi = CreateMultiChart("Chart",DISPLAYS,hyperW);

	if (!multi)
	{
		fprintf(stderr,"Could not create multigraph!\n");
		exit(1);
	}

	XtPopup(multi->shellW, XtGrabNone);
	while (1)
	{
		if (XtPending())
		{
			XtNextEvent(&event);
			XtDispatchEvent(&event);
		}

		if (random()%20 == 0)
		   sleep (1);

		if (random()%2 == 0)
		   count[random()%DISPLAYS] += random()%10 + 10;
		else
		   count[random()%DISPLAYS] -= random()%10;

		for (i = 0; i < DISPLAYS; i++)
			MultiChartAddValue(multi,i,count[i]);
	}
} /* End main */
